/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class HeightDepthSelector
extends ParametersPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> selectorHD = null;
    private JFormattedTextField heightDepthField = null;
    private boolean editable;
    private JLabel jLabel = null;
    private boolean canceled = false;

    public HeightDepthSelector() {
        this.initialize();
    }

    @Override
    public String getErrors() {
        try {
            Double.parseDouble(this.getZField().getText());
        }
        catch (Exception e) {
            return I18n.text("The Z parameters are not valid");
        }
        return null;
    }

    public double getDepth() {
        if (this.selectorHD.getSelectedItem().equals(I18n.text("Height"))) {
            return -Double.parseDouble(this.getZField().getText());
        }
        return Double.parseDouble(this.getZField().getText());
    }

    public void setZ(double depth) {
        this.getZField().setText(String.valueOf(depth));
    }

    private JComboBox<String> getZUnitsCombo() {
        if (this.selectorHD == null) {
            this.selectorHD = new JComboBox<String>(new String[]{I18n.text("Depth"), I18n.text("Height")});
            this.selectorHD.setPreferredSize(new Dimension(90, 20));
        }
        return this.selectorHD;
    }

    private JTextField getZField() {
        if (this.heightDepthField == null) {
            this.heightDepthField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat());
            this.heightDepthField.setColumns(7);
            this.heightDepthField.addFocusListener(new SelectAllFocusListener());
        }
        return this.heightDepthField;
    }

    public static void main(String[] args) throws Exception {
        LocationType loc = new LocationType();
        loc.setDepth(10.0);
        HeightDepthSelector.showHeightDepthDialog(loc, I18n.text("Set plan depth / altitude"));
        NeptusLog.pub().info((Object)("<###> " + loc));
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.setLayout(new FlowLayout());
        this.setBounds(0, 0, 204, 30);
        this.jLabel.setText("m ");
        this.add((Component)this.getZField(), null);
        this.add((Component)this.jLabel, null);
        this.add(this.getZUnitsCombo(), null);
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getZUnitsCombo().setEnabled(this.editable);
        this.getZField().setEditable(this.editable);
    }

    public static boolean showHeightDepthDialog(LocationType loc, String title) {
        final HeightDepthSelector selector = new HeightDepthSelector();
        selector.setZ(loc.getAllZ());
        selector.setBorder(new TitledBorder(I18n.text("Value for Z")));
        final JDialog dialog = new JDialog(ConfigFetch.getSuperParentAsFrame());
        JButton btnOk = new JButton(I18n.text("OK"));
        btnOk.setPreferredSize(new Dimension(86, 24));
        JButton btnCancel = new JButton(I18n.text("Cancel"));
        btnCancel.setPreferredSize(new Dimension(86, 24));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selector.canceled = true;
                dialog.dispose();
            }
        });
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)selector, "Center");
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setSize(300, 120);
        JPanel controls = new JPanel(new FlowLayout(2));
        controls.add(btnCancel);
        controls.add(btnOk);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.add((Component)controls, "South");
        dialog.setVisible(true);
        if (!selector.canceled) {
            loc.setDepth(selector.getDepth());
        }
        return !selector.canceled;
    }
}

