/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pt.lsts.neptus.events.NeptusEventHiddenMenus;
import pt.lsts.neptus.events.NeptusEvents;

public class HideMenusListener
implements MenuListener {
    private Component[] components = new Component[0];
    private JMenuItem[] menuItems = new JMenuItem[0];
    private boolean show = false;
    private JMenu menu = null;

    public static HideMenusListener forge(Component[] components, JMenuItem[] menuItems) {
        HideMenusListener instance = new HideMenusListener(components, menuItems);
        NeptusEvents.register(instance);
        return instance;
    }

    public static HideMenusListener forge(JMenuItem[] menuItems) {
        HideMenusListener instance = new HideMenusListener(new Component[0], menuItems);
        NeptusEvents.register(instance);
        return instance;
    }

    public HideMenusListener(Component[] components, JMenuItem[] menuItems) {
        this.components = components;
        this.menuItems = menuItems;
        for (Component component : components) {
            component.setVisible(false);
        }
        for (Component component : menuItems) {
            ((JComponent)component).setVisible(false);
        }
    }

    @Subscribe
    public void handleNeptusEventHiddenMenus(NeptusEventHiddenMenus e) {
        this.show = !this.show;
        for (Component component : this.components) {
            component.setVisible(this.show);
        }
        for (Component component : this.menuItems) {
            ((JComponent)component).setVisible(this.show);
        }
        this.menu.revalidate();
        this.menu.repaint();
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.menu = (JMenu)e.getSource();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        this.menu = (JMenu)e.getSource();
    }

    @Override
    public void menuCanceled(MenuEvent e) {
        this.menu = (JMenu)e.getSource();
    }
}

