/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import pt.lsts.neptus.NeptusLog;

public class HighlightButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private Border downBorder = BorderFactory.createLoweredBevelBorder();
    private Border upBorder = BorderFactory.createRaisedBevelBorder();
    private boolean state = false;

    public HighlightButton(String txt) {
        super(txt);
        this.label = new JLabel(txt, 0);
        this.label.setBorder(this.upBorder);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                HighlightButton.this.state = true;
                HighlightButton.this.label.setBorder(HighlightButton.this.downBorder);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                HighlightButton.this.state = false;
                HighlightButton.this.label.setBorder(HighlightButton.this.upBorder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                HighlightButton.this.label.setBorder(HighlightButton.this.upBorder);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (HighlightButton.this.state) {
                    HighlightButton.this.label.setBorder(HighlightButton.this.downBorder);
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        this.label.setBounds(this.getBounds());
        this.label.setBackground(this.getBackground());
        this.label.setForeground(this.getForeground());
        this.label.setOpaque(true);
        this.label.setText(this.getText());
        this.label.paint(g);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            if (System.getProperty("os.name").equals("Linux")) {
                UIManager.put("ClassLoader", LookUtils.class.getClass().getClassLoader());
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame test = new JFrame("Unitary test");
        test.setLayout(new FlowLayout());
        HighlightButton btn = new HighlightButton("test");
        btn.setBackground(Color.RED);
        test.getContentPane().add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NeptusLog.pub().info((Object)"<###>ioops");
            }
        });
        btn = new HighlightButton("green");
        btn.setBackground(Color.GREEN);
        btn.setPreferredSize(new Dimension(100, 30));
        test.getContentPane().add(btn);
        test.pack();
        test.setVisible(true);
        test.setDefaultCloseOperation(3);
    }
}

