/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ImagePreview;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ImageFileChooser
extends JFileChooser {
    private static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File showOpenImageDialog() {
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File(ConfigFetch.getConfigFile()));
        jfc.setAccessory(new ImagePreview(jfc));
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = ImageFileChooser.getExtension(f);
                if (extension != null) {
                    return extension.equals("png") || extension.equals("jpg") || extension.equals("jpeg") || extension.equals("gif");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return I18n.text("Image files");
            }
        });
        jfc.showDialog(ConfigFetch.getSuperParentFrame(), I18n.text("Open Image"));
        return jfc.getSelectedFile();
    }

    public static void main(String[] args) {
        File f = ImageFileChooser.showOpenImageDialog();
        NeptusLog.pub().info((Object)("<###> " + f));
    }
}

