/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import pt.lsts.neptus.util.ImageUtils;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = -6728614478181991497L;
    protected Image image;
    protected String ImagePath = "";
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected boolean fit_to_panel = false;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        this.image = image;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imageWidth <= 0 | this.imageHeight <= 0) {
            if (this.fit_to_panel) {
                g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                g.drawImage(this.image, 0, 0, this);
            }
        } else if (this.fit_to_panel) {
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g.drawImage(this.image, 0, 0, this.getImageWidth(), this.getImageHeight(), this);
        }
    }

    public void adjustImageSizeToPanelSize() {
        if (this.image == null) {
            return;
        }
        Dimension dim = this.getSize();
        this.image = ImageUtils.getScaledImage(this.image, (int)dim.getWidth(), (int)dim.getHeight(), false);
        this.setImageWidth(this.image.getWidth(this));
        this.setImageHeight(this.image.getHeight(this));
    }

    public void adjustImageSizeToPreferredSize() {
        if (this.image == null) {
            return;
        }
        Dimension dim = this.getPreferredSize();
        this.image = ImageUtils.getScaledImage(this.image, (int)dim.getWidth(), (int)dim.getHeight(), false);
        this.setImageWidth(this.image.getWidth(this));
        this.setImageHeight(this.image.getHeight(this));
    }

    public void setImage(String imageURL) {
        this.ImagePath = imageURL;
        this.image = new ImageIcon(imageURL).getImage();
    }

    public void setImage(Image image) {
        this.ImagePath = null;
        this.image = image;
    }

    public String getImage() {
        return this.ImagePath;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public boolean isFit_to_panel() {
        return this.fit_to_panel;
    }

    public void setFit_to_panel(boolean fit_to_panel) {
        this.fit_to_panel = fit_to_panel;
    }
}

