/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon thumbnail = null;
    private File file = null;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(100, 50));
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            return;
        }
        if (this.file.canRead()) {
            ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
            this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

