/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class ImageScaleAndLocationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JDialog parentDialog = null;
    private MapGroup mg = MapGroup.getNewInstance(new CoordinateSystem());
    private StateRenderer2D r2d = new StateRenderer2D(this.mg);
    private MapType map;
    private ImageElement tmp;
    private ImageElement imgObject;
    private LocationType lt1;
    private LocationType lt2;
    private MarkElement mark1;
    private MarkElement mark2;
    private boolean userCancel;
    private JButton okBtn;

    public ImageScaleAndLocationPanel(ImageElement obj) {
        this.r2d.setShowWorldMapOnScreenControls(false);
        this.r2d.setShowWorldMapOnScreen(false);
        this.r2d.setLegendShown(false);
        this.r2d.removePaintersOfType(Object.class);
        this.map = new MapType();
        this.lt1 = new LocationType();
        this.lt2 = new LocationType();
        this.mark1 = null;
        this.mark2 = null;
        this.userCancel = true;
        this.okBtn = null;
        this.imgObject = obj;
        this.r2d.setLegendShown(false);
        this.r2d.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mevt) {
                if (mevt.getButton() != 3) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                final Point clickedPoint = mevt.getPoint();
                AbstractAction point1 = new AbstractAction("Set Location 1"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        LocationType tmp = LocationPanel.showLocationDialog(SwingUtilities.getWindowAncestor(ImageScaleAndLocationPanel.this.parentDialog), "Set Location 1", ImageScaleAndLocationPanel.this.lt1, null, true);
                        if (tmp != null) {
                            ImageScaleAndLocationPanel.this.lt1 = tmp;
                            ImageScaleAndLocationPanel.this.map.remove("Location 1");
                            ImageScaleAndLocationPanel.this.mark1 = new MarkElement(null, null);
                            ImageScaleAndLocationPanel.this.mark1.setCenterLocation(ImageScaleAndLocationPanel.this.r2d.getRealWorldLocation(clickedPoint));
                            ImageScaleAndLocationPanel.this.mark1.setId("Location 1");
                            ImageScaleAndLocationPanel.this.map.addObject(ImageScaleAndLocationPanel.this.mark1);
                            if (ImageScaleAndLocationPanel.this.mark2 != null) {
                                ImageScaleAndLocationPanel.this.okBtn.setEnabled(true);
                            }
                            ImageScaleAndLocationPanel.this.r2d.repaint();
                        }
                    }
                };
                AbstractAction point2 = new AbstractAction("Set Location 2"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        LocationType tmp = LocationPanel.showLocationDialog(SwingUtilities.getWindowAncestor(ImageScaleAndLocationPanel.this.parentDialog), "Set Location 2", ImageScaleAndLocationPanel.this.lt2, null, true);
                        if (tmp != null) {
                            ImageScaleAndLocationPanel.this.lt2 = tmp;
                            ImageScaleAndLocationPanel.this.map.remove("Location 2");
                            ImageScaleAndLocationPanel.this.mark2 = new MarkElement(null, null);
                            ImageScaleAndLocationPanel.this.mark2.setCenterLocation(ImageScaleAndLocationPanel.this.r2d.getRealWorldLocation(clickedPoint));
                            ImageScaleAndLocationPanel.this.mark2.setId("Location 2");
                            ImageScaleAndLocationPanel.this.map.addObject(ImageScaleAndLocationPanel.this.mark2);
                            if (ImageScaleAndLocationPanel.this.mark2 != null) {
                                ImageScaleAndLocationPanel.this.okBtn.setEnabled(true);
                            }
                            ImageScaleAndLocationPanel.this.r2d.repaint();
                        }
                    }
                };
                popup.add(point1);
                popup.add(point2);
                popup.show(ImageScaleAndLocationPanel.this.r2d, mevt.getX(), mevt.getY());
            }
        });
        this.mg.addMap(this.map);
        this.tmp = new ImageElement(this.mg, this.map);
        this.tmp.setImage(obj.getImage());
        this.map.addObject(this.tmp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.r2d, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        this.okBtn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageScaleAndLocationPanel.this.calculate();
                ImageScaleAndLocationPanel.this.userCancel = false;
                ImageScaleAndLocationPanel.this.parentDialog.setVisible(false);
                ImageScaleAndLocationPanel.this.parentDialog.dispose();
            }
        });
        this.okBtn.setPreferredSize(new Dimension(100, 30));
        this.okBtn.setEnabled(false);
        buttonsPanel.add(this.okBtn);
        JButton cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageScaleAndLocationPanel.this.parentDialog.setVisible(false);
                ImageScaleAndLocationPanel.this.parentDialog.dispose();
            }
        });
        cancelBtn.setPreferredSize(new Dimension(100, 30));
        buttonsPanel.add(cancelBtn);
        this.add((Component)buttonsPanel, "South");
    }

    public static boolean showDialog(ImageElement obj, Window parent) {
        ImageScaleAndLocationPanel panel = new ImageScaleAndLocationPanel(obj);
        JDialog dialog = new JDialog(parent);
        panel.setParentDialog(dialog);
        dialog.setContentPane(panel);
        dialog.setTitle("Image " + obj.getId() + " position and scale" + " [image must be north oriented]");
        dialog.setSize(500, 500);
        GuiUtils.centerParent(dialog, parent);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        return !panel.userCancel;
    }

    private void calculate() {
        double pixelDistance = this.mark1.getCenterLocation().getHorizontalDistanceInMeters(this.mark2.getCenterLocation());
        double meterDistance = this.lt1.getHorizontalDistanceInMeters(this.lt2);
        double scale = meterDistance / pixelDistance;
        double[] pixelOffsets = new LocationType().getOffsetFrom(this.mark1.getCenterLocation());
        LocationType finalLoc = new LocationType(this.lt1);
        finalLoc.translatePosition(pixelOffsets[0] * scale, pixelOffsets[1] * scale, pixelOffsets[2] * scale);
        this.imgObject.setCenterLocation(finalLoc);
        this.imgObject.setImageScale(scale);
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public static void main(String[] args) {
        ImageElement tmp = new ImageElement();
        tmp.setImage(ImageUtils.getImage("images/neptus-icon1.png"));
        ImageScaleAndLocationPanel.showDialog(tmp, new JFrame());
    }
}

