/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class InfiniteProgressPanel
extends JPanel {
    private JLabel text = null;
    private JXBusyLabel busyLabel = null;

    public InfiniteProgressPanel() {
        this.initialize();
    }

    public InfiniteProgressPanel(JXBusyLabel busyLabel, String message) {
        this.setText(message);
        this.setBusyLabel(busyLabel);
        this.initialize();
    }

    public InfiniteProgressPanel(String message) {
        this.setText(message);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.add(Box.createVerticalGlue());
        this.add((Component)this.getBusyLabel());
        this.add(this.getTextJLabel());
        this.add(Box.createVerticalGlue());
        if (this.busyLabel != null) {
            this.busyLabel.setBusy(false);
        }
    }

    public JXBusyLabel getBusyLabel() {
        if (this.busyLabel == null) {
            this.busyLabel = InfiniteProgressPanel.createBusyAnimationInfiniteBeans(200);
            this.busyLabel.setBusy(false);
        }
        return this.busyLabel;
    }

    public void setBusyLabel(JXBusyLabel busyLabel) {
        this.busyLabel = busyLabel;
        if (this.busyLabel != null) {
            this.busyLabel.setBusy(false);
        }
    }

    private JLabel getTextJLabel() {
        if (this.text == null) {
            this.text = new JLabel("<html><b>" + I18n.text("Wait please") + "...", 0);
            this.text.setAlignmentX(0.5f);
            this.text.setAlignmentY(0.5f);
        }
        return this.text;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String message) {
        if (message != null && !"".equalsIgnoreCase(message)) {
            this.getTextJLabel().setText("<html><b>" + message + "...");
        } else {
            this.getTextJLabel().setText("");
        }
    }

    public void start() {
        this.busyLabel.setBusy(true);
    }

    public void stop() {
        this.busyLabel.setBusy(false);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.start();
        } else {
            this.stop();
        }
    }

    private static JXBusyLabel createBusyAnimation(int size, Shape shape, Shape trajectory, int trailLength, int nShapes) {
        float scale = 0.01f * (float)size;
        JXBusyLabel label = new JXBusyLabel(new Dimension((int)(scale * 100.0f), (int)(scale * 100.0f)));
        BusyPainter painter = new BusyPainter(shape, trajectory);
        painter.setTrailLength(trailLength);
        painter.setPoints(nShapes);
        painter.setFrame(1);
        painter.setBaseColor(new Color(168, 204, 241));
        painter.setPaintCentered(true);
        label.setPreferredSize(new Dimension((int)(scale * 100.0f), (int)(scale * 100.0f)));
        label.setIcon((Icon)new EmptyIcon((int)(scale * 100.0f), (int)(scale * 100.0f)));
        label.setBusyPainter(painter);
        label.setAlignmentX(0.5f);
        label.setAlignmentY(0.5f);
        label.setBusy(false);
        return label;
    }

    private static InfiniteProgressPanel createPanel(JXBusyLabel label, String message) {
        return new InfiniteProgressPanel(label, message);
    }

    public static JXBusyLabel createBusyAnimationInfiniteBeans(int size) {
        float scale = 0.01f * (float)size;
        return InfiniteProgressPanel.createBusyAnimation(size, new Ellipse2D.Float(0.0f, 0.0f, scale * 10.5f, scale * 24.5f), new Ellipse2D.Float(scale * 15.0f, scale * 15.0f, scale * 70.0f, scale * 70.0f), 5, 8);
    }

    public static InfiniteProgressPanel createInfinitePanelBeans(String message) {
        return InfiniteProgressPanel.createInfinitePanelBeans(message, 200);
    }

    public static InfiniteProgressPanel createInfinitePanelBeans(String message, int size) {
        JXBusyLabel label = InfiniteProgressPanel.createBusyAnimationInfiniteBeans(size);
        return InfiniteProgressPanel.createPanel(label, message);
    }

    public static JXBusyLabel createBusyAnimationInfiniteCircles(int size) {
        float scale = 0.01f * (float)size;
        return InfiniteProgressPanel.createBusyAnimation(size, new Ellipse2D.Float(0.0f, 0.0f, scale * 10.5f, scale * 10.5f), new Ellipse2D.Float(scale * 15.0f, scale * 15.0f, scale * 70.0f, scale * 70.0f), 5, 12);
    }

    public static InfiniteProgressPanel createInfinitePanelCircles(String message) {
        return InfiniteProgressPanel.createInfinitePanelCircles(message, 200);
    }

    public static InfiniteProgressPanel createInfinitePanelCircles(String message, int size) {
        JXBusyLabel label = InfiniteProgressPanel.createBusyAnimationInfiniteCircles(size);
        return InfiniteProgressPanel.createPanel(label, message);
    }

    public static JXBusyLabel createBusyAnimationInfiniteFeather2(int size) {
        float scale = 0.01f * (float)size;
        return InfiniteProgressPanel.createBusyAnimation(size, new RoundRectangle2D.Float(0.0f, 0.0f, scale * 30.5f, scale * 10.0f, scale * 10.0f, scale * 10.0f), new Ellipse2D.Float(scale * 15.0f, scale * 15.0f, scale * 70.0f, scale * 70.0f), 4, 8);
    }

    public static InfiniteProgressPanel createInfinitePanelFeather2(String message) {
        return InfiniteProgressPanel.createInfinitePanelFeather2(message, 200);
    }

    public static InfiniteProgressPanel createInfinitePanelFeather2(String message, int size) {
        JXBusyLabel label = InfiniteProgressPanel.createBusyAnimationInfiniteFeather2(size);
        return InfiniteProgressPanel.createPanel(label, message);
    }

    public static JXBusyLabel createBusyAnimationInfiniteFeather(int size) {
        float scale = 0.01f * (float)size;
        return InfiniteProgressPanel.createBusyAnimation(size, new RoundRectangle2D.Float(0.0f, 0.0f, scale * 22.0f, scale * 6.5f, scale * 8.0f, scale * 8.0f), new Ellipse2D.Float(scale * 15.0f, scale * 15.0f, scale * 70.0f, scale * 70.0f), 4, 14);
    }

    public static InfiniteProgressPanel createInfinitePanelFeather(String message) {
        return InfiniteProgressPanel.createInfinitePanelFeather(message, 200);
    }

    public static InfiniteProgressPanel createInfinitePanelFeather(String message, int size) {
        JXBusyLabel label = InfiniteProgressPanel.createBusyAnimationInfiniteFeather(size);
        return InfiniteProgressPanel.createPanel(label, message);
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(InfiniteProgressPanel.createInfinitePanelBeans("Please wait"), "", 400, 400);
    }
}

