/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.LatLongSelector;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class LatLonConv
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final short DECIMAL_DEGREES = 0;
    private static final short DM = 1;
    private static final short DMS = 2;
    private LatLongSelector latLongSelector = null;
    private JButton btnCopy = null;
    private JButton btnPaste = null;
    private LocationType locationType = new LocationType();
    private JPanel copyPastePanel = null;
    private JButton okButton = null;
    private JFrame jFrame = null;
    private JPanel frameContentPane = null;
    private JDialog jDialog = null;
    private JPanel dialogContentPane = null;
    private JPanel cardsPanel = null;
    private JPanel radsPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField latRad = null;
    private NumberFormat df = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel71 = null;
    private JFormattedTextField lonRad = null;
    private JPanel selectorDegRadPanel = null;
    private JRadioButton cardDegRadioButton = null;
    private JRadioButton cardRadRadioButton = null;

    public LatLonConv() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(419, 190);
        this.setLayout(null);
        this.add((Component)this.getCopyPastePanel(), null);
        this.add((Component)this.getOkButton(), null);
        this.add((Component)this.getCardsPanel(), null);
        this.add((Component)this.getSelectorDegRadPanel(), null);
    }

    public LocationType getLocationType() {
        if (this.getLatLongSelector().getErrors() != null) {
            return null;
        }
        this.locationType.setLatitudeStr(this.getLatLongSelector().getLatitude());
        this.locationType.setLongitudeStr(this.getLatLongSelector().getLongitude());
        return this.locationType;
    }

    public void setLocationType(LocationType locationType) {
        this.locationType = locationType;
        this.getLatLongSelector().setLatitude(CoordinateUtil.parseLatitudeStringToDMS(locationType.getLatitudeStr()));
        this.getLatLongSelector().setLongitude(CoordinateUtil.parseLongitudeStringToDMS(locationType.getLongitudeStr()));
    }

    private LatLongSelector getLatLongSelector() {
        if (this.latLongSelector == null) {
            this.latLongSelector = new LatLongSelector();
            this.latLongSelector.setName("latLongSelector");
        }
        return this.latLongSelector;
    }

    private JButton getBtnCopy() {
        if (this.btnCopy == null) {
            this.btnCopy = new JButton();
            this.btnCopy.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editcopy.png")));
            this.btnCopy.setMargin(new Insets(0, 0, 0, 0));
            this.btnCopy.setToolTipText(I18n.text("Copy this location to the clipboard"));
            this.btnCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LatLonConv.this.btnPaste.setEnabled(true);
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(LatLonConv.this.getLocationType().getClipboardText()), owner);
                }
            });
        }
        return this.btnCopy;
    }

    private JButton getBtnPaste() {
        if (this.btnPaste == null) {
            this.btnPaste = new JButton();
            this.btnPaste.setPreferredSize(new Dimension(20, 20));
            this.btnPaste.setToolTipText(I18n.text("Paste from clipboard"));
            this.btnPaste.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editpaste.png")));
            this.btnPaste.setMargin(new Insets(0, 0, 0, 0));
            this.btnPaste.setEnabled(true);
            this.btnPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean hasTransferableText;
                    LatLonConv.this.btnPaste.setEnabled(true);
                    Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                    if (hasTransferableText) {
                        try {
                            String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                            LocationType lt = new LocationType();
                            lt.fromClipboardText(text);
                            LatLonConv.this.setLocationType((LocationType)lt.getNewAbsoluteLatLonDepth());
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                }
            });
        }
        return this.btnPaste;
    }

    private JPanel getCopyPastePanel() {
        if (this.copyPastePanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(3, 3, 2, 5);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(2, 5, 1, 2);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridx = 0;
            this.copyPastePanel = new JPanel();
            this.copyPastePanel.setLayout(new GridBagLayout());
            this.copyPastePanel.setBounds(new Rectangle(12, 147, 135, 35));
            this.copyPastePanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.copyPastePanel.add((Component)this.getBtnCopy(), gridBagConstraints3);
            this.copyPastePanel.add((Component)this.getBtnPaste(), gridBagConstraints4);
        }
        return this.copyPastePanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(317, 156, 87, 20));
            this.okButton.setText(I18n.text("OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LatLonConv.this.jFrame != null) {
                        LatLonConv.this.jFrame.setVisible(false);
                        LatLonConv.this.jFrame.dispose();
                    }
                    if (LatLonConv.this.jDialog != null) {
                        LatLonConv.this.jDialog.setVisible(false);
                        LatLonConv.this.jDialog.dispose();
                    }
                }
            });
        }
        return this.okButton;
    }

    public JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/neptus-icon.png")));
            this.jFrame.setSize(new Dimension(419, 224));
            this.jFrame.setTitle(I18n.text("Lat/Lon"));
            this.jFrame.setContentPane(this.getFrameContentPane());
            this.jFrame.add(this);
        }
        return this.jFrame;
    }

    private JPanel getFrameContentPane() {
        if (this.frameContentPane == null) {
            this.frameContentPane = new JPanel();
            this.frameContentPane.setLayout(new BorderLayout());
        }
        return this.frameContentPane;
    }

    public JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog(this.getJFrame());
            this.jDialog.setSize(new Dimension(419, 224));
            this.jDialog.setContentPane(this.getDialogContentPane());
            this.jDialog.add(this);
        }
        return this.jDialog;
    }

    private JPanel getDialogContentPane() {
        if (this.dialogContentPane == null) {
            this.dialogContentPane = new JPanel();
            this.dialogContentPane.setLayout(new BorderLayout());
        }
        return this.dialogContentPane;
    }

    protected boolean convertLatLonTo(short type) {
        LocationType loc = this.getLocationType();
        switch (type) {
            case 0: {
                this.latLongSelector.setLatitude(new double[]{MathMiscUtils.round(loc.getLatitudeDegs(), 6), 0.0, 0.0});
                this.latLongSelector.setLongitude(new double[]{MathMiscUtils.round(loc.getLongitudeDegs(), 6), 0.0, 0.0});
                break;
            }
            case 1: {
                double[] dmLat = CoordinateUtil.decimalDegreesToDM(loc.getLatitudeDegs());
                double[] dmLon = CoordinateUtil.decimalDegreesToDM(loc.getLongitudeDegs());
                this.latLongSelector.setLatitude(new double[]{dmLat[0], MathMiscUtils.round(dmLat[1], 4), 0.0});
                this.latLongSelector.setLongitude(new double[]{dmLon[0], MathMiscUtils.round(dmLon[1], 4), 0.0});
                break;
            }
            case 2: {
                double[] dmsLat = CoordinateUtil.decimalDegreesToDMS(loc.getLatitudeDegs());
                double[] dmsLon = CoordinateUtil.decimalDegreesToDMS(loc.getLongitudeDegs());
                this.latLongSelector.setLatitude(new double[]{dmsLat[0], dmsLat[1], MathMiscUtils.round(dmsLat[2], 2)});
                this.latLongSelector.setLongitude(new double[]{dmsLon[0], dmsLon[1], MathMiscUtils.round(dmsLon[2], 2)});
                break;
            }
        }
        return true;
    }

    private JPanel getCardsPanel() {
        if (this.cardsPanel == null) {
            this.cardsPanel = new JPanel();
            this.cardsPanel.setLayout(new CardLayout());
            this.cardsPanel.setSize(new Dimension(401, 134));
            this.cardsPanel.setLocation(new Point(10, 9));
            this.cardsPanel.add((Component)this.getLatLongSelector(), I18n.text("degs"));
            this.cardsPanel.add((Component)this.getRadsPanel(), I18n.text("rad"));
        }
        return this.cardsPanel;
    }

    private JPanel getRadsPanel() {
        if (this.radsPanel == null) {
            this.jLabel71 = new JLabel();
            this.jLabel71.setHorizontalTextPosition(0);
            this.jLabel71.setText(I18n.text("rad"));
            this.jLabel71.setLocation(new Point(180, 109));
            this.jLabel71.setSize(new Dimension(31, 15));
            this.jLabel71.setHorizontalAlignment(0);
            this.jLabel7 = new JLabel();
            this.jLabel7.setHorizontalTextPosition(0);
            this.jLabel7.setText(I18n.text("rad"));
            this.jLabel7.setSize(new Dimension(31, 15));
            this.jLabel7.setLocation(new Point(180, 49));
            this.jLabel7.setHorizontalAlignment(0);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(I18n.text("Longitude:"));
            this.jLabel1.setLocation(new Point(10, 84));
            this.jLabel1.setSize(new Dimension(66, 20));
            this.jLabel = new JLabel();
            this.jLabel.setText(I18n.text("Latitude:"));
            this.jLabel.setLocation(new Point(10, 24));
            this.jLabel.setSize(new Dimension(104, 20));
            this.radsPanel = new JPanel();
            this.radsPanel.setLayout(null);
            this.radsPanel.setSize(new Dimension(401, 134));
            this.radsPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Radians"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.radsPanel.add((Component)this.jLabel, null);
            this.radsPanel.add((Component)this.jLabel1, null);
            this.radsPanel.add((Component)this.getLatRad(), null);
            this.radsPanel.add((Component)this.jLabel7, null);
            this.radsPanel.add((Component)this.jLabel71, null);
            this.radsPanel.add((Component)this.getLonRad(), null);
        }
        return this.radsPanel;
    }

    private NumberFormat getDf() {
        if (this.df == null) {
            this.df = GuiUtils.getNeptusDecimalFormat();
        }
        return this.df;
    }

    private JFormattedTextField getLatRad() {
        if (this.latRad == null) {
            this.latRad = new JFormattedTextField(this.getDf());
            this.latRad.setText("0");
            this.latRad.setLocation(new Point(10, 49));
            this.latRad.setSize(new Dimension(167, 20));
        }
        return this.latRad;
    }

    private JFormattedTextField getLonRad() {
        if (this.lonRad == null) {
            this.lonRad = new JFormattedTextField(this.getDf());
            this.lonRad.setText("0");
            this.lonRad.setLocation(new Point(10, 109));
            this.lonRad.setSize(new Dimension(167, 20));
        }
        return this.lonRad;
    }

    private JPanel getSelectorDegRadPanel() {
        if (this.selectorDegRadPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 3, 0, 17);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 16, 0, 2);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            this.selectorDegRadPanel = new JPanel();
            this.selectorDegRadPanel.setLayout(new GridBagLayout());
            this.selectorDegRadPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 8), new Color(51, 51, 51)));
            this.selectorDegRadPanel.setLocation(new Point(154, 147));
            this.selectorDegRadPanel.setSize(new Dimension(151, 35));
            this.selectorDegRadPanel.setEnabled(true);
            this.selectorDegRadPanel.add((Component)this.getCardDegRadioButton(), gridBagConstraints);
            this.selectorDegRadPanel.add((Component)this.getCardRadRadioButton(), gridBagConstraints1);
        }
        return this.selectorDegRadPanel;
    }

    private JRadioButton getCardDegRadioButton() {
        if (this.cardDegRadioButton == null) {
            this.cardDegRadioButton = new JRadioButton();
            this.cardDegRadioButton.setText(I18n.text("Degrees"));
            this.cardDegRadioButton.setEnabled(false);
            this.cardDegRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LatLonConv.this.cardRadRadioButton.setSelected(false);
                        CardLayout cl = (CardLayout)LatLonConv.this.getCardsPanel().getLayout();
                        cl.show(LatLonConv.this.getCardsPanel(), "degs");
                    }
                }
            });
        }
        return this.cardDegRadioButton;
    }

    private JRadioButton getCardRadRadioButton() {
        if (this.cardRadRadioButton == null) {
            this.cardRadRadioButton = new JRadioButton();
            this.cardRadRadioButton.setText(I18n.text("Rads"));
            this.cardRadRadioButton.setEnabled(false);
            this.cardRadRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LatLonConv.this.cardDegRadioButton.setSelected(false);
                        CardLayout cl = (CardLayout)LatLonConv.this.getCardsPanel().getLayout();
                        cl.show(LatLonConv.this.getCardsPanel(), "rads");
                    }
                }
            });
        }
        return this.cardRadRadioButton;
    }

    public static void main(String[] args) {
        LatLonConv latLonConv = new LatLonConv();
        JFrame jf = latLonConv.getJFrame();
        jf.setDefaultCloseOperation(2);
        jf.setVisible(true);
    }
}

