/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class LatLongSelector
extends ParametersPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    public static final short DECIMAL_DEGREES_DISPLAY = 0;
    public static final short DM_DISPLAY = 1;
    public static final short DMS_DISPLAY = 2;
    private JPanel dmsPanel = null;
    private JLabel jLabel = null;
    private NumberFormat df = GuiUtils.getNeptusDecimalFormat();
    private JFormattedTextField latDeg = null;
    private JFormattedTextField latMin = null;
    private JFormattedTextField latSec = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField lonDeg = null;
    private JFormattedTextField lonMin = null;
    private JFormattedTextField lonSec = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel6 = null;
    private JLabel jLabel7 = null;
    private JTextField latDecDegrees = null;
    private JTextField lonDecDegrees = null;
    private boolean editable;
    private JPanel convPanel = null;
    private JRadioButton ddegreesRadioButton = null;
    private JRadioButton dmRadioButton = null;
    private JRadioButton dmsRadioButton = null;

    public LatLongSelector() {
        this.initialize();
    }

    private JPanel getDMSPanel() {
        if (this.dmsPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel7 = new JLabel();
            this.jLabel6 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel1 = new JLabel();
            this.dmsPanel = new JPanel();
            this.dmsPanel.setLayout(null);
            this.jLabel.setBounds(10, 24, 59, 20);
            this.jLabel.setText(I18n.text("Latitude:"));
            this.jLabel1.setBounds(10, 84, 90, 20);
            this.jLabel1.setText(I18n.text("Longitude:"));
            this.jLabel2.setBounds(167, 109, 10, 20);
            this.jLabel2.setText("'");
            this.jLabel2.setHorizontalTextPosition(0);
            this.jLabel2.setHorizontalAlignment(0);
            this.jLabel3.setBounds(252, 109, 10, 20);
            this.jLabel3.setText("''");
            this.jLabel3.setHorizontalTextPosition(0);
            this.jLabel3.setHorizontalAlignment(0);
            this.jLabel4.setBounds(81, 109, 10, 20);
            this.jLabel4.setText("\u00b0");
            this.jLabel4.setHorizontalTextPosition(0);
            this.jLabel4.setHorizontalAlignment(0);
            this.jLabel4.setFont(new Font("Dialog", 1, 14));
            this.jLabel5.setBounds(81, 49, 10, 20);
            this.jLabel5.setText("\u00b0");
            this.jLabel5.setHorizontalTextPosition(0);
            this.jLabel5.setHorizontalAlignment(0);
            this.jLabel5.setFont(new Font("Dialog", 1, 14));
            this.jLabel6.setBounds(167, 49, 10, 20);
            this.jLabel6.setText("'");
            this.jLabel6.setHorizontalTextPosition(0);
            this.jLabel6.setHorizontalAlignment(0);
            this.jLabel7.setBounds(252, 49, 10, 20);
            this.jLabel7.setText("''");
            this.jLabel7.setHorizontalTextPosition(0);
            this.jLabel7.setHorizontalAlignment(0);
            this.dmsPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Degrees/Minutes/Seconds"), 2, 0, null, null));
            this.dmsPanel.add((Component)this.jLabel, null);
            this.dmsPanel.add((Component)this.getLatDeg(), null);
            this.dmsPanel.add((Component)this.getLatMin(), null);
            this.dmsPanel.add((Component)this.getLatSec(), null);
            this.dmsPanel.add((Component)this.jLabel1, null);
            this.dmsPanel.add((Component)this.getLonDeg(), null);
            this.dmsPanel.add((Component)this.getLonMin(), null);
            this.dmsPanel.add((Component)this.getLonSec(), null);
            this.dmsPanel.add((Component)this.jLabel2, null);
            this.dmsPanel.add((Component)this.jLabel3, null);
            this.dmsPanel.add((Component)this.jLabel4, null);
            this.dmsPanel.add((Component)this.jLabel5, null);
            this.dmsPanel.add((Component)this.jLabel6, null);
            this.dmsPanel.add((Component)this.jLabel7, null);
            this.dmsPanel.add((Component)this.getConvPanel(), null);
        }
        return this.dmsPanel;
    }

    public void setDMSStyleIndicatorTo(int style) {
        this.clearConvRadioButtons();
        switch (style) {
            case 0: {
                this.ddegreesRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.dmRadioButton.setSelected(true);
                break;
            }
            default: {
                this.dmsRadioButton.setSelected(true);
            }
        }
    }

    public String getLatitude() {
        String latString = CoordinateUtil.dmsToLatString(Double.parseDouble(this.getLatDeg().getText()), Double.parseDouble(this.getLatMin().getText()), Double.parseDouble(this.getLatSec().getText()));
        return latString;
    }

    public String getLongitude() {
        return CoordinateUtil.dmsToLonString(Double.parseDouble(this.getLonDeg().getText()), Double.parseDouble(this.getLonMin().getText()), Double.parseDouble(this.getLonSec().getText()));
    }

    public double getLatitudeValue() {
        try {
            return CoordinateUtil.parseLatitudeCoordToDoubleValue(this.getLatitude());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getLongitudeValue() {
        try {
            return CoordinateUtil.parseLongitudeCoordToDoubleValue(this.getLongitude());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void setLatitude(double[] dms) {
        this.getLatDeg().setText(String.valueOf(dms[0]));
        this.getLatMin().setText(String.valueOf(dms[1]));
        this.getLatSec().setText(String.valueOf(dms[2]));
        if (this.isEditable()) {
            this.latMin.setEnabled(true);
            this.latSec.setEnabled(true);
            this.latMin.setBackground(Color.WHITE);
            this.latSec.setBackground(Color.WHITE);
        }
    }

    public void setLongitude(double[] dms) {
        this.getLonDeg().setText(String.valueOf(dms[0]));
        this.getLonMin().setText(String.valueOf(dms[1]));
        this.getLonSec().setText(String.valueOf(dms[2]));
        if (this.isEditable()) {
            this.lonMin.setEnabled(true);
            this.lonSec.setEnabled(true);
            this.lonMin.setBackground(Color.WHITE);
            this.lonSec.setBackground(Color.WHITE);
        }
    }

    public void setLatitudeValue(double latitude) {
        double[] dms = CoordinateUtil.decimalDegreesToDMS(latitude);
        this.getLatDeg().setText(String.valueOf(dms[0]));
        this.getLatMin().setText(String.valueOf(dms[1]));
        this.getLatSec().setText(String.valueOf(dms[2]));
    }

    public void setLongitudeValue(double longitude) {
        double[] dms = CoordinateUtil.decimalDegreesToDMS(longitude);
        this.getLonDeg().setText(String.valueOf(dms[0]));
        this.getLonMin().setText(String.valueOf(dms[1]));
        this.getLonSec().setText(String.valueOf(dms[2]));
    }

    private JFormattedTextField getLatDeg() {
        if (this.latDeg == null) {
            this.latDeg = new JFormattedTextField(this.df);
            this.latDeg.setBounds(10, 49, 72, 20);
            this.latDeg.setText("0");
            this.latDeg.addKeyListener(this);
            this.latDeg.addFocusListener(new SelectAllFocusListener());
        }
        return this.latDeg;
    }

    private JFormattedTextField getLatMin() {
        if (this.latMin == null) {
            this.latMin = new JFormattedTextField(this.df);
            this.latMin.setBounds(96, 49, 72, 20);
            this.latMin.setText("0");
            this.latMin.addKeyListener(this);
            this.latMin.addFocusListener(new SelectAllFocusListener());
        }
        return this.latMin;
    }

    private JFormattedTextField getLatSec() {
        if (this.latSec == null) {
            this.latSec = new JFormattedTextField(this.df);
            this.latSec.setBounds(181, 49, 72, 20);
            this.latSec.setText("0");
            this.latSec.addKeyListener(this);
            this.latSec.addFocusListener(new SelectAllFocusListener());
        }
        return this.latSec;
    }

    private JFormattedTextField getLonDeg() {
        if (this.lonDeg == null) {
            this.lonDeg = new JFormattedTextField(this.df);
            this.lonDeg.setBounds(10, 109, 72, 20);
            this.lonDeg.setText("0");
            this.lonDeg.addKeyListener(this);
            this.lonDeg.addFocusListener(new SelectAllFocusListener());
        }
        return this.lonDeg;
    }

    private JFormattedTextField getLonMin() {
        if (this.lonMin == null) {
            this.lonMin = new JFormattedTextField(this.df);
            this.lonMin.setBounds(96, 109, 72, 20);
            this.lonMin.setText("0");
            this.lonMin.addKeyListener(this);
            this.lonMin.addFocusListener(new SelectAllFocusListener());
        }
        return this.lonMin;
    }

    private JFormattedTextField getLonSec() {
        if (this.lonSec == null) {
            this.lonSec = new JFormattedTextField(this.df);
            this.lonSec.setBounds(181, 109, 72, 20);
            this.lonSec.setText("0");
            this.lonSec.addKeyListener(this);
            this.lonSec.addFocusListener(new SelectAllFocusListener());
        }
        return this.lonSec;
    }

    private JTextField getLatDecDegrees() {
        if (this.latDecDegrees == null) {
            this.latDecDegrees = new JTextField();
            this.latDecDegrees.setBounds(42, 50, 120, 20);
            this.latDecDegrees.setText("0");
            this.latDecDegrees.addKeyListener(this);
            this.latDecDegrees.addFocusListener(new SelectAllFocusListener());
        }
        return this.latDecDegrees;
    }

    private JTextField getLonDecDegrees() {
        if (this.lonDecDegrees == null) {
            this.lonDecDegrees = new JTextField();
            this.lonDecDegrees.setBounds(42, 110, 120, 20);
            this.lonDecDegrees.setText("0");
            this.lonDecDegrees.addKeyListener(this);
            this.lonDecDegrees.addFocusListener(new SelectAllFocusListener());
        }
        return this.lonDecDegrees;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!Character.isDefined(e.getKeyChar())) {
            return;
        }
        if (e.getSource() != this.latDeg && e.getSource() != this.lonDeg && e.getSource() != this.latDecDegrees && e.getSource() != this.lonDecDegrees && e.getKeyChar() == '-') {
            JTextField src = (JTextField)e.getSource();
            src.setText(src.getText().replaceAll("-", ""));
        }
        if (e.getSource() == this.latDeg) {
            if (this.latDeg.getText().contains(".")) {
                this.latMin.setText("0");
                this.latMin.setEnabled(false);
                this.latSec.setText("0");
                this.latSec.setEnabled(false);
                this.latMin.setBackground(Color.GRAY);
                this.latSec.setBackground(Color.GRAY);
            } else {
                this.latMin.setEnabled(true);
                this.latSec.setEnabled(true);
                this.latMin.setBackground(Color.WHITE);
                this.latSec.setBackground(Color.WHITE);
            }
        }
        if (e.getSource() == this.lonDeg) {
            if (this.lonDeg.getText().contains(".")) {
                this.lonMin.setText("0");
                this.lonMin.setEnabled(false);
                this.lonSec.setText("0");
                this.lonSec.setEnabled(false);
                this.lonMin.setBackground(Color.GRAY);
                this.lonSec.setBackground(Color.GRAY);
            } else {
                this.lonMin.setEnabled(true);
                this.lonSec.setEnabled(true);
                this.lonMin.setBackground(Color.WHITE);
                this.lonSec.setBackground(Color.WHITE);
            }
        }
        if (e.getSource() == this.latMin) {
            if (this.latMin.getText().contains(".")) {
                this.latSec.setText("0");
                this.latSec.setEnabled(false);
                this.latSec.setBackground(Color.GRAY);
            } else {
                this.latSec.setEnabled(true);
                this.latSec.setBackground(Color.WHITE);
            }
        }
        if (e.getSource() == this.lonMin) {
            if (this.lonMin.getText().contains(".")) {
                this.lonSec.setText("0");
                this.lonSec.setEnabled(false);
                this.lonSec.setBackground(Color.GRAY);
            } else {
                this.lonSec.setEnabled(true);
                this.lonSec.setBackground(Color.WHITE);
            }
        }
        this.clearConvRadioButtons();
    }

    @Override
    public String getErrors() {
        int counter = 0;
        try {
            Double.parseDouble(this.getLatDeg().getText());
            Double.parseDouble(this.getLatMin().getText());
            Double.parseDouble(this.getLatSec().getText());
            counter = 1;
            Double.parseDouble(this.getLonDeg().getText());
            Double.parseDouble(this.getLonMin().getText());
            Double.parseDouble(this.getLonSec().getText());
        }
        catch (Exception e) {
            switch (counter) {
                case 0: {
                    return I18n.text("The D/M/S latitude is invalid");
                }
                case 1: {
                    return I18n.text("The D/M/S longitude is invalid");
                }
                case 2: {
                    return I18n.text("The Decimal Degrees Latitude is invalid");
                }
                case 3: {
                    return I18n.text("The Decimal Degrees Longitude is invalid");
                }
            }
            return I18n.text("The Latitude/Longitude parameters are not valid");
        }
        return null;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(420, 145);
        this.add((Component)this.getDMSPanel(), "Center");
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getLatDeg().setEditable(this.editable);
        this.getLatMin().setEditable(this.editable);
        this.getLatSec().setEditable(this.editable);
        this.getLonDeg().setEditable(this.editable);
        this.getLonMin().setEditable(this.editable);
        this.getLonSec().setEditable(this.editable);
        this.getLatDecDegrees().setEditable(this.editable);
        this.getLonDecDegrees().setEditable(this.editable);
        this.getConvPanel().setEnabled(this.editable);
        this.getDdegreesRadioButton().setEnabled(this.editable);
        this.getDmRadioButton().setEnabled(this.editable);
        this.getDmsRadioButton().setEnabled(this.editable);
    }

    private JPanel getConvPanel() {
        if (this.convPanel == null) {
            this.convPanel = new JPanel();
            this.convPanel.setLayout(new BoxLayout(this.getConvPanel(), 1));
            this.convPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Lat/Lon Display"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.convPanel.setBounds(new Rectangle(261, 30, 149, 98));
            this.convPanel.add((Component)this.getDdegreesRadioButton(), null);
            this.convPanel.add((Component)this.getDmRadioButton(), null);
            this.convPanel.add((Component)this.getDmsRadioButton(), null);
        }
        return this.convPanel;
    }

    private JRadioButton getDdegreesRadioButton() {
        if (this.ddegreesRadioButton == null) {
            this.ddegreesRadioButton = new JRadioButton();
            this.ddegreesRadioButton.setText(I18n.text("Decimal Degrees"));
            this.ddegreesRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LatLongSelector.this.dmRadioButton.setSelected(false);
                        LatLongSelector.this.dmsRadioButton.setSelected(false);
                        LatLongSelector.this.convertLatLonTo((short)0);
                    }
                }
            });
        }
        return this.ddegreesRadioButton;
    }

    private JRadioButton getDmRadioButton() {
        if (this.dmRadioButton == null) {
            this.dmRadioButton = new JRadioButton();
            this.dmRadioButton.setText(I18n.text("Degrees, Minutes"));
            this.dmRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LatLongSelector.this.ddegreesRadioButton.setSelected(false);
                        LatLongSelector.this.dmsRadioButton.setSelected(false);
                        LatLongSelector.this.convertLatLonTo((short)1);
                    }
                }
            });
        }
        return this.dmRadioButton;
    }

    private JRadioButton getDmsRadioButton() {
        if (this.dmsRadioButton == null) {
            this.dmsRadioButton = new JRadioButton();
            this.dmsRadioButton.setHorizontalAlignment(10);
            this.dmsRadioButton.setText(I18n.text("DMS"));
            this.dmsRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LatLongSelector.this.ddegreesRadioButton.setSelected(false);
                        LatLongSelector.this.dmRadioButton.setSelected(false);
                        LatLongSelector.this.convertLatLonTo((short)2);
                    }
                }
            });
        }
        return this.dmsRadioButton;
    }

    private void clearConvRadioButtons() {
        this.ddegreesRadioButton.setSelected(false);
        this.dmRadioButton.setSelected(false);
        this.dmsRadioButton.setSelected(false);
    }

    protected boolean convertLatLonTo(short type) {
        LocationType loc = new LocationType();
        loc.setLatitudeStr(this.getLatitude());
        loc.setLongitudeStr(this.getLongitude());
        switch (type) {
            case 0: {
                this.setLatitude(new double[]{MathMiscUtils.round(loc.getLatitudeDegs(), 6), 0.0, 0.0});
                this.setLongitude(new double[]{MathMiscUtils.round(loc.getLongitudeDegs(), 6), 0.0, 0.0});
                break;
            }
            case 1: {
                double[] dmLat = CoordinateUtil.decimalDegreesToDM(loc.getLatitudeDegs());
                double[] dmLon = CoordinateUtil.decimalDegreesToDM(loc.getLongitudeDegs());
                this.setLatitude(new double[]{dmLat[0], MathMiscUtils.round(dmLat[1], 4), 0.0});
                this.setLongitude(new double[]{dmLon[0], MathMiscUtils.round(dmLon[1], 4), 0.0});
                break;
            }
            case 2: {
                double[] dmsLat = CoordinateUtil.decimalDegreesToDMS(loc.getLatitudeDegs());
                double[] dmsLon = CoordinateUtil.decimalDegreesToDMS(loc.getLongitudeDegs());
                this.setLatitude(new double[]{dmsLat[0], dmsLat[1], MathMiscUtils.round(dmsLat[2], 2)});
                this.setLongitude(new double[]{dmsLon[0], dmsLon[1], MathMiscUtils.round(dmsLon[2], 2)});
                break;
            }
        }
        return true;
    }
}

