/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class Loader
extends JFrame
implements ActionListener {
    public static final long serialVersionUID = 237536234L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel2 = null;
    private String imgFileName = "images/neptus_version1.png";
    private String typedString = "";
    private Color backColor = new Color(242, 251, 254);
    private Color frontColor = Color.GRAY;

    public Loader() {
        this.initialize();
    }

    public Loader(String splashImageURL) {
        this.imgFileName = splashImageURL;
        this.initialize();
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("...");
            this.jLabel.setForeground(this.frontColor);
            this.jLabel.setBackground(this.backColor);
            this.jLabel.setAutoscrolls(true);
        }
        return this.jLabel;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Neptus " + ConfigFetch.getNeptusVersion());
            this.jLabel2.setFont(new Font("Arial", 0, 10));
            this.jLabel2.setForeground(new Color(150, 150, 150));
            this.jLabel2.setBackground(this.backColor);
            this.jLabel2.setAutoscrolls(true);
        }
        return this.jLabel2;
    }

    public void start() {
        this.setVisible(true);
    }

    public void waitMoreAndEnd(int milliseconds) {
        this.end();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        NeptusLog.pub().info((Object)"<###>end");
        ((Timer)action.getSource()).stop();
        this.end();
    }

    public void end() {
        this.setVisible(false);
        this.dispose();
    }

    private void initialize() {
        this.setSize(500, 230);
        this.setBackground(this.backColor);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Neptus ...");
        this.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Loader.this.typedString = Loader.this.typedString + String.valueOf(e.getKeyChar());
            }
        });
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(false);
        this.setUndecorated(true);
    }

    private JPanel getJContentPane() {
        Image image = ImageUtils.getImage(this.imgFileName);
        ImagePanel ipan = new ImagePanel(image);
        ipan.setBackground(this.backColor);
        ipan.setSize(500, 213);
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.backColor));
            this.jContentPane.setBackground(this.backColor);
            this.jContentPane.add((Component)ipan, "Center");
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.setBackground(this.backColor);
            JProgressBar bar = new JProgressBar(0);
            bar.setIndeterminate(true);
            bar.setBackground(this.backColor);
            bar.setForeground(this.frontColor);
            bottomPanel.add((Component)bar, "South");
            bottomPanel.add((Component)this.getJLabel(), "West");
            bottomPanel.add((Component)this.getJLabel2(), "East");
            this.jContentPane.add((Component)bottomPanel, "South");
        }
        return this.jContentPane;
    }

    public boolean setText(String text, long delayAfter) {
        this.setText(text);
        try {
            Thread.sleep(delayAfter);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean setText(String text) {
        this.getJLabel().setText(" ".concat(text));
        return true;
    }

    public boolean appendText(String text, long delayAfter) {
        this.appendText(text);
        try {
            Thread.sleep(delayAfter);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean appendText(String text) {
        this.getJLabel().setText(this.getJLabel().getText().concat(text));
        return true;
    }

    public String getTypedString() {
        return this.typedString;
    }

    public static void main(String[] args) throws InterruptedException {
        File fx = new File(".").getAbsoluteFile();
        Loader ld = new Loader();
        ld.start();
        Thread.sleep(2000L);
        ld.setText("Connecting... " + fx.getAbsoluteFile(), 5000L);
        ld.end();
    }
}

