/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class LocationCopyPastePanel
extends JPanel {
    private static final long serialVersionUID = 6057200519930411065L;
    private LocationType locationType = new LocationType();
    private JButton btnCopy = null;
    private JButton btnPaste = null;

    public LocationCopyPastePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(3, 3, 2, 5);
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(2, 5, 1, 2);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setBounds(new Rectangle(12, 147, 135, 35));
        this.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getBtnCopy(), gridBagConstraints3);
        this.add((Component)this.getBtnPaste(), gridBagConstraints4);
    }

    private JButton getBtnCopy() {
        if (this.btnCopy == null) {
            this.btnCopy = new JButton();
            this.btnCopy.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editcopy.png")));
            this.btnCopy.setMargin(new Insets(0, 0, 0, 0));
            this.btnCopy.setToolTipText(I18n.text("Copy this location to the clipboard"));
            this.btnCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LocationCopyPastePanel.this.btnPaste.setEnabled(true);
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(LocationCopyPastePanel.this.getLocationType().getClipboardText()), owner);
                }
            });
        }
        return this.btnCopy;
    }

    private JButton getBtnPaste() {
        if (this.btnPaste == null) {
            this.btnPaste = new JButton();
            this.btnPaste.setPreferredSize(new Dimension(20, 20));
            this.btnPaste.setToolTipText(I18n.text("Paste from clipboard"));
            this.btnPaste.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editpaste.png")));
            this.btnPaste.setMargin(new Insets(0, 0, 0, 0));
            this.btnPaste.setEnabled(true);
            this.btnPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean hasTransferableText;
                    LocationCopyPastePanel.this.btnPaste.setEnabled(true);
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                    if (hasTransferableText) {
                        try {
                            String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                            LocationType lt = new LocationType();
                            lt.fromClipboardText(text);
                            LocationCopyPastePanel.this.setLocationType(lt);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                }
            });
        }
        return this.btnPaste;
    }

    public LocationType getLocationType() {
        return this.locationType;
    }

    public void setLocationType(LocationType locationType) {
        this.locationType = locationType;
    }

    public static void main(String[] args) {
        LocationCopyPastePanel locPanel = new LocationCopyPastePanel();
        GuiUtils.testFrame(locPanel, "", 100, 100);
    }
}

