/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

class LocationObject
extends AbstractElement {
    LocationType center = new LocationType();

    public LocationObject(MapGroup mg, MapType map) {
        super(mg, map);
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return point.getDistanceInMeters(this.getCenterLocation()) < (double)renderer.getZoom();
    }

    @Override
    public LocationType getCenterLocation() {
        return this.center;
    }

    @Override
    public int getLayerPriority() {
        return 0;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return null;
    }

    @Override
    public String getType() {
        return I18n.text("Location");
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        g.setTransform(new AffineTransform());
        Point2D pt = renderer.getScreenPosition(this.center);
        if (pt != null) {
            g.translate(pt.getX(), pt.getY());
            g.setColor(new Color(0, 0, 0, 100));
            g.fill(new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0));
            g.setColor(Color.WHITE);
            g.draw(new Line2D.Double(-10.0, -10.0, 10.0, 10.0));
            g.draw(new Line2D.Double(-10.0, 10.0, 10.0, -10.0));
        }
    }

    @Override
    public void setCenterLocation(LocationType l) {
        this.center.setLocation(l);
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_OTHER;
    }
}

