/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MapLocationSelector;
import pt.lsts.neptus.gui.MarkSelector;
import pt.lsts.neptus.gui.MarksComboListener;
import pt.lsts.neptus.gui.PointSelector;
import pt.lsts.neptus.gui.PolarOffsetPanel;
import pt.lsts.neptus.gui.RegularOffset;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class LocationPanel
extends ParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 8283415165348726797L;
    public static LocationType clipboard = null;
    private JDialog dialog = new JDialog();
    private LocationType location = new LocationType();
    private JPanel jPanel = null;
    private JTabbedPane refPointTabs = null;
    private JPanel jPanel1 = null;
    private JButton cancelBtn = null;
    private JTabbedPane OffsetTabs = null;
    private JPanel nedOffsetPanel = null;
    private JPanel panel1 = null;
    private JPanel existingLocationPanel = null;
    private JButton okBtn = null;
    private MissionType missionType = null;
    private PointSelector pointSelector = null;
    private MarkSelector markSelector = null;
    private RegularOffset regularOffset = null;
    private PolarOffsetPanel polarOffsetPanel = null;
    private boolean editable = true;
    private boolean userCancel = false;
    private JButton btnCopy = null;
    private JButton btnPaste = null;
    private JButton findOnMap = null;
    private JButton makeLocAbsolute = null;
    private Component hg1 = Box.createHorizontalGlue();
    private Component hg2 = Box.createHorizontalGlue();
    private boolean hideOkCancelButtons = false;

    public LocationPanel(LocationType location, MissionType missionType) {
        this.missionType = missionType;
        this.setLocationType(location);
        this.initialize();
    }

    public LocationPanel(MissionType missionType) {
        this.missionType = missionType;
        this.initialize();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBounds(15, 15, 413, 225);
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Reference Point"), 0, 0, null, null));
            this.jPanel.add((Component)this.getRefPointTabs(), "Center");
        }
        return this.jPanel;
    }

    private JTabbedPane getRefPointTabs() {
        if (this.refPointTabs == null) {
            this.refPointTabs = new JTabbedPane();
            this.refPointTabs.addTab(I18n.text("New Location"), null, this.getPointSelector(), null);
            if (this.getMissionType() != null) {
                this.refPointTabs.addTab(I18n.text("Existing location"), null, this.getExistingLocationPanel(), null);
            }
        }
        return this.refPointTabs;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.setBounds(16, 244, 412, 109);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Offset"), 0, 0, null, null));
            this.jPanel1.add((Component)this.getOffsetTabs(), "Center");
        }
        return this.jPanel1;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setBounds(337, 375, 90, 30);
            this.cancelBtn.setText(I18n.text("Cancel"));
            this.cancelBtn.addActionListener(this);
            this.cancelBtn.setActionCommand("cancel");
        }
        return this.cancelBtn;
    }

    public JTabbedPane getOffsetTabs() {
        if (this.OffsetTabs == null) {
            this.OffsetTabs = new JTabbedPane();
            this.OffsetTabs.addTab(I18n.text("Orthogonal Offsets"), null, this.getNedOffsetPanel(), null);
            this.OffsetTabs.addTab(I18n.text("Spherical Offsets"), null, this.getJPanel2(), null);
        }
        return this.OffsetTabs;
    }

    public JPanel getNedOffsetPanel() {
        if (this.nedOffsetPanel == null) {
            this.nedOffsetPanel = new JPanel();
            this.nedOffsetPanel.add((Component)this.getRegularOffset(), null);
        }
        return this.nedOffsetPanel;
    }

    public JPanel getJPanel2() {
        if (this.panel1 == null) {
            this.panel1 = new JPanel();
            this.panel1.add((Component)this.getPolarOffsetPanel(), null);
        }
        return this.panel1;
    }

    public JPanel getExistingLocationPanel() {
        if (this.existingLocationPanel == null) {
            this.existingLocationPanel = new JPanel();
            this.existingLocationPanel.add((Component)this.getMarkSelector(), null);
        }
        return this.existingLocationPanel;
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton();
            this.okBtn.setBounds(227, 375, 90, 30);
            this.okBtn.setText(I18n.text("OK"));
            this.okBtn.addActionListener(this);
            this.okBtn.setActionCommand("ok");
        }
        return this.okBtn;
    }

    public PointSelector getPointSelector() {
        if (this.pointSelector == null) {
            this.pointSelector = new PointSelector();
            this.pointSelector.setMissionType(this.getMissionType());
        }
        return this.pointSelector;
    }

    private MarkSelector getMarkSelector() {
        if (this.markSelector == null) {
            this.markSelector = new MarkSelector(this.missionType);
            this.markSelector.addMarksComboListener(new MarksComboListener(){

                @Override
                public void MarkComboChanged(MarkElement selectedMarkObject) {
                    if (selectedMarkObject != null) {
                        LocationPanel.this.setLocationType(new LocationType(selectedMarkObject.getCenterLocation()));
                    }
                }
            });
        }
        return this.markSelector;
    }

    public void hideButtons() {
        this.hideOkCancelButtons = true;
        this.getOkBtn().setVisible(false);
        this.getCancelBtn().setVisible(false);
    }

    private RegularOffset getRegularOffset() {
        if (this.regularOffset == null) {
            this.regularOffset = new RegularOffset();
        }
        return this.regularOffset;
    }

    private PolarOffsetPanel getPolarOffsetPanel() {
        if (this.polarOffsetPanel == null) {
            this.polarOffsetPanel = new PolarOffsetPanel();
        }
        return this.polarOffsetPanel;
    }

    private JButton getBtnCopy() {
        if (this.btnCopy == null) {
            this.btnCopy = new JButton();
            this.btnCopy.setMargin(new Insets(0, 0, 0, 0));
            this.btnCopy.setSize(new Dimension(20, 20));
            this.btnCopy.setLocation(new Point(16, 360));
            this.btnCopy.setToolTipText(I18n.text("Copy this location to the clipboard"));
            this.btnCopy.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editcopy.png")));
            this.btnCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LocationPanel.this.btnPaste.setEnabled(LocationPanel.this.isEditable());
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(LocationPanel.this.getLocationType().getClipboardText()), owner);
                }
            });
        }
        return this.btnCopy;
    }

    private JButton getBtnPaste() {
        if (this.btnPaste == null) {
            this.btnPaste = new JButton();
            this.btnPaste.setPreferredSize(new Dimension(20, 20));
            this.btnPaste.setEnabled(this.isEditable());
            this.btnPaste.setMargin(new Insets(0, 0, 0, 0));
            this.btnPaste.setBounds(new Rectangle(42, 360, 20, 20));
            this.btnPaste.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/editpaste.png")));
            this.btnPaste.setToolTipText(I18n.text("Paste from clipboard"));
            this.btnPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean hasTransferableText;
                    LocationPanel.this.btnPaste.setEnabled(LocationPanel.this.isEditable());
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                    if (hasTransferableText) {
                        try {
                            String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                            LocationType lt = new LocationType();
                            lt.fromClipboardText(text);
                            LocationPanel.this.setLocationType(lt);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                }
            });
        }
        return this.btnPaste;
    }

    private JButton getFindOnMap() {
        if (this.findOnMap == null) {
            this.findOnMap = new JButton();
            this.findOnMap.setBounds(new Rectangle(68, 360, 20, 20));
            this.findOnMap.setIcon(new ImageIcon(ImageUtils.getImage("images/buttons/findOnMap.png")));
            this.findOnMap.setMargin(new Insets(0, 0, 0, 0));
            this.findOnMap.setEnabled(false);
            this.findOnMap.setToolTipText(I18n.text("Select a location on map..."));
            this.findOnMap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Window w = SwingUtilities.getWindowAncestor(LocationPanel.this);
                    LocationType lt = MapLocationSelector.showDialog(w instanceof Frame ? (Frame)w : null, MapGroup.getMapGroupInstance(LocationPanel.this.missionType));
                }
            });
        }
        return this.findOnMap;
    }

    private JButton getMakeLocAbsolute() {
        if (this.makeLocAbsolute == null) {
            this.makeLocAbsolute = new JButton();
            this.makeLocAbsolute.setBounds(new Rectangle(68, 360, 80, 20));
            this.makeLocAbsolute.setText(I18n.textc("Abs", "Abs is the absolute value, don't use more than 3 letters"));
            this.makeLocAbsolute.setFont(this.makeLocAbsolute.getFont().deriveFont(10));
            this.makeLocAbsolute.setMargin(new Insets(0, 0, 0, 0));
            this.makeLocAbsolute.setEnabled(true);
            this.makeLocAbsolute.setToolTipText(I18n.text("Make the location absolute"));
            this.makeLocAbsolute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LocationPanel.this.setLocationType((LocationType)LocationPanel.this.getLocationType().getNewAbsoluteLatLonDepth());
                }
            });
        }
        return this.makeLocAbsolute;
    }

    private void initialize() {
        this.setBounds(0, 0, 467, 428);
        GuiUtils.reactEnterKeyPress(this.getOkBtn());
        GuiUtils.reactEscapeKeyPress(this.getCancelBtn());
        GroupLayout gl = new GroupLayout(this);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        this.setLayout(gl);
        gl.setHorizontalGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getJPanel()).addComponent(this.getJPanel1()).addGroup(gl.createSequentialGroup().addComponent(this.getBtnCopy()).addComponent(this.getBtnPaste()).addComponent(this.getFindOnMap()).addGap(20).addComponent(this.getMakeLocAbsolute()).addComponent(this.hg1)).addGroup(gl.createSequentialGroup().addComponent(this.hg2).addComponent(this.getOkBtn()).addComponent(this.getCancelBtn())));
        gl.setVerticalGroup(gl.createSequentialGroup().addComponent(this.getJPanel()).addComponent(this.getJPanel1(), 100, 100, 100).addGroup(gl.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBtnCopy()).addComponent(this.getBtnPaste()).addComponent(this.getFindOnMap()).addComponent(this.getMakeLocAbsolute()).addComponent(this.hg1)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.hg2).addComponent(this.getOkBtn()).addComponent(this.getCancelBtn())));
        gl.linkSize(0, this.getOkBtn(), this.getCancelBtn());
        gl.linkSize(0, this.getBtnCopy(), this.getBtnPaste(), this.getFindOnMap());
        gl.linkSize(1, this.getBtnCopy(), this.getBtnPaste(), this.getFindOnMap(), this.getMakeLocAbsolute());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("ok".equals(ae.getActionCommand())) {
            if (this.getErrors() != null) {
                JOptionPane.showMessageDialog(this, this.getErrors(), I18n.text("Errors in the parameters"), 0);
                return;
            }
            LocationType loc2 = this.getPointSelector().getLocationType();
            this.location.setLocation(loc2);
            char[] selectedOffsets = this.regularOffset.getSelectedOrientations();
            this.location.setOffsetNorth(this.regularOffset.getNorthOffset(), selectedOffsets[0] == 'N');
            this.location.setOffsetEast(this.regularOffset.getEastOffset(), selectedOffsets[1] == 'E');
            this.location.setOffsetDown(this.regularOffset.getDownOffset(), selectedOffsets[2] == 'D');
            this.location.setAzimuth(this.getPolarOffsetPanel().getAzimuthOffset());
            this.location.setOffsetDistance(this.getPolarOffsetPanel().getDistanceOffset());
            this.location.setZenith(this.getPolarOffsetPanel().getZenithOffset());
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        if ("cancel".equals(ae.getActionCommand())) {
            this.location = null;
            this.setUserCancel(true);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public LocationType getLocationType() {
        LocationType loc2 = this.getPointSelector().getLocationType();
        this.location.setLocation(loc2);
        char[] selectedOffsets = this.regularOffset.getSelectedOrientations();
        this.location.setOffsetNorth(this.regularOffset.getNorthOffset(), selectedOffsets[0] == 'N');
        this.location.setOffsetEast(this.regularOffset.getEastOffset(), selectedOffsets[1] == 'E');
        this.location.setOffsetDown(this.regularOffset.getDownOffset(), selectedOffsets[2] == 'D');
        this.location.setAzimuth(this.getPolarOffsetPanel().getAzimuthOffset());
        this.location.setOffsetDistance(this.getPolarOffsetPanel().getDistanceOffset());
        this.location.setZenith(this.getPolarOffsetPanel().getZenithOffset());
        return this.location;
    }

    public void setLocationType(LocationType location) {
        this.location = location;
        this.getPointSelector().setLocationType(location);
        this.getPolarOffsetPanel().setLocationType(location);
        this.getRegularOffset().setLocationType(location);
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getMarkSelector().setEnabled(this.editable);
        this.getPointSelector().setEditable(this.editable);
        this.getRegularOffset().setEditable(this.editable);
        this.getPolarOffsetPanel().setEditable(this.editable);
        this.getCancelBtn().setVisible(!this.hideOkCancelButtons && this.editable);
        this.getBtnPaste().setEnabled(this.editable);
        this.getMakeLocAbsolute().setEnabled(this.editable);
    }

    private JDialog getLocationDialog(Component parent, String title) {
        this.dialog = parent instanceof Window ? new JDialog((Window)parent) : new JDialog(SwingUtilities.getWindowAncestor(parent));
        this.dialog.setTitle(title);
        this.dialog.setSize(this.getWidth() + 5, this.getHeight() + 35);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog.setAlwaysOnTop(false);
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LocationPanel.this.location = null;
                LocationPanel.this.setUserCancel(true);
                LocationPanel.this.dialog.setVisible(false);
                LocationPanel.this.dialog.dispose();
            }
        });
        this.dialog.setVisible(true);
        return this.dialog;
    }

    @Override
    public String getErrors() {
        if (this.regularOffset.getErrors() != null) {
            return I18n.textf("<html>Error in the <b>offset</b> parameters:<br>%errors</html>", this.regularOffset.getErrors());
        }
        if (this.polarOffsetPanel.getErrors() != null) {
            return I18n.textf("<html>Error in the <b>polar offset</b> parameters:<br>%errors</html>", this.polarOffsetPanel.getErrors());
        }
        if (this.pointSelector.getErrors() != null) {
            return I18n.textf("<html>The entered <b>location</b> is invalid:<br>%errors</html>", this.pointSelector.getErrors());
        }
        return null;
    }

    public static LocationType showLocationDialog(String title, LocationType previousLocation, MissionType mt) {
        return LocationPanel.showLocationDialog(title, previousLocation, mt, true);
    }

    public static LocationType showLocationDialog(Component parent, String title, LocationType previousLocation, MissionType mt, boolean editable) {
        LocationType location = new LocationType();
        location.setLocation(previousLocation);
        location.setOffsetDown(previousLocation.getOffsetDown(), !previousLocation.isOffsetUpUsed());
        location.setOffsetNorth(previousLocation.getOffsetNorth(), previousLocation.isOffsetNorthUsed());
        location.setOffsetEast(previousLocation.getOffsetEast(), previousLocation.isOffsetEastUsed());
        LocationPanel locPanel = new LocationPanel(location, mt);
        locPanel.setEditable(editable);
        if (parent == null) {
            locPanel.getLocationDialog(ConfigFetch.getSuperParentAsFrame(), title);
        } else {
            locPanel.getLocationDialog(parent, title);
        }
        if (locPanel.isUserCancel()) {
            return null;
        }
        return locPanel.getLocationType();
    }

    public static LocationType showLocationDialog(String title, LocationType previousLocation, MissionType mt, boolean editable) {
        return LocationPanel.showLocationDialog(null, title, previousLocation, mt, editable);
    }

    @Override
    public MissionType getMissionType() {
        return this.missionType;
    }

    @Override
    public void setMissionType(MissionType missionType) {
        this.missionType = missionType;
        this.getMarkSelector().setMissionType(this.missionType);
    }

    public boolean isUserCancel() {
        return this.userCancel;
    }

    public void setUserCancel(boolean userCancel) {
        this.userCancel = userCancel;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        LocationType loc = new LocationType(41.0, -8.0);
        loc.setDepth(-45.0);
        NeptusLog.pub().info((Object)("<###> " + loc.asXML()));
        LocationType other = new LocationType();
        other.setLocation(loc);
        NeptusLog.pub().info((Object)("<###> " + other.asXML()));
        loc = LocationPanel.showLocationDialog("Testing..", loc, null);
        NeptusLog.pub().info((Object)"<###>AFTER:");
        NeptusLog.pub().info((Object)("<###> " + loc.asXML()));
    }
}

