/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class LogBook
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private JTextPane msgTextArea = new JTextPane();
    private static String operatorName = System.getProperty("user.name");
    private JLabel operatorLbl = new JLabel(operatorName);
    private JTextField messageField = new JTextField();
    private IMCMessage logMsg = new IMCMessage("LogBookEntry");

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        LogBook.operatorName = operatorName;
    }

    private String getTimeStamp() {
        return this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    private synchronized void writeMessageText(String message) {
        SimpleAttributeSet attrTS = new SimpleAttributeSet();
        attrTS.addAttribute(StyleConstants.ColorConstants.Foreground, Color.DARK_GRAY);
        attrTS.addAttribute(StyleConstants.Bold, true);
        this.logMsg.setValue("source", (Object)"ccu");
        this.logMsg.setValue("destination", (Object)"ccu");
        Document doc = this.msgTextArea.getDocument();
        try {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            attr.addAttribute(StyleConstants.ColorConstants.Foreground, Color.blue);
            doc.insertString(doc.getLength(), "[" + this.getTimeStamp() + "]: ", attrTS);
            attr = new SimpleAttributeSet();
            attr.addAttribute(StyleConstants.ColorConstants.Foreground, Color.black);
            doc.insertString(doc.getLength(), message + "\n", attr);
            this.msgTextArea.setCaretPosition(doc.getLength());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public LogBook() {
        this.msgTextArea.setEditable(false);
        this.setLayout(new BorderLayout(3, 3));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel topPanel = new JPanel(new FlowLayout(2));
        topPanel.add(new JLabel("Operator: "));
        this.operatorLbl.setForeground(Color.blue.darker());
        topPanel.add(this.operatorLbl);
        JButton btn = new JButton("Change...");
        topPanel.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String opName = JOptionPane.showInputDialog(LogBook.this, "Change operator name", operatorName);
                if (opName != null) {
                    operatorName = opName;
                    LogBook.this.operatorLbl.setText(operatorName);
                }
            }
        });
        this.add((Component)topPanel, "North");
        this.add((Component)new JScrollPane(this.msgTextArea), "Center");
        JPanel bottom = new JPanel(new BorderLayout(3, 3));
        bottom.add((Component)this.messageField, "Center");
        JButton btn2 = new JButton("Add Entry");
        ActionListener addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogBook.this.messageField.getText().isEmpty()) {
                    return;
                }
                LogBook.this.writeMessageText(LogBook.this.messageField.getText());
                try {
                    LogBook.this.logMsg.setValue("context", (Object)operatorName);
                    LogBook.this.logMsg.setValue("htime", (Object)DateTimeUtil.timeStampSeconds());
                    LogBook.this.logMsg.setValue("type", (Object)0);
                    LogBook.this.logMsg.setValue("text", (Object)LogBook.this.messageField.getText());
                    LsfMessageLogger.log((IMCMessage)LogBook.this.logMsg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                LogBook.this.messageField.setText("");
            }
        };
        btn2.addActionListener(addActionListener);
        this.messageField.addActionListener(addActionListener);
        bottom.add((Component)btn2, "East");
        this.add((Component)bottom, "South");
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        GuiUtils.testFrame(new LogBook());
    }
}

