/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MapPreview;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MapFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -8791840446640115089L;

    public static File showOpenMapDialog(File basedir) {
        return MapFileChooser.showOpenDialog(null, I18n.text("Open Map"), basedir);
    }

    public static File showOpenMapDialog(Component parent, File basedir) {
        return MapFileChooser.showOpenDialog(parent, I18n.text("Open Map"), basedir);
    }

    public static File showOpenMapDialog(Component parent) {
        return MapFileChooser.showOpenDialog(parent, I18n.text("Open Map"), null);
    }

    public static File showOpenMapDialog() {
        return MapFileChooser.showOpenDialog(null, I18n.text("Open Map"), null);
    }

    public static File showSaveMapDialog(File basedir) {
        return MapFileChooser.showOpenDialog(null, I18n.text("Save Map"), basedir);
    }

    public static File showSaveMapDialog() {
        return MapFileChooser.showOpenDialog(null, I18n.text("Save Map"), null);
    }

    public static File showSaveMapDialog(Component parent, File basedir) {
        return MapFileChooser.showOpenDialog(parent, I18n.text("Save Map"), basedir);
    }

    public static File showSaveMapDialog(Component parent) {
        return MapFileChooser.showOpenDialog(parent, I18n.text("Save Map"), null);
    }

    private static File showOpenDialog(Component parent, String title, File basedir) {
        File fx;
        JFileChooser jfc = new JFileChooser();
        if (basedir != null && basedir.exists()) {
            fx = basedir;
        } else {
            fx = new File(ConfigFetch.getConfigFile());
            if (!fx.exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                fx = new File(".");
            }
        }
        jfc.setCurrentDirectory(fx);
        jfc.setAccessory(new MapPreview(jfc));
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getFileExtension(f);
                if (extension != null) {
                    return extension.equals("nmap") || extension.equals("xml");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return I18n.text("Map files") + " ('" + "nmap" + "', '" + "xml" + "')";
            }
        });
        int result = jfc.showDialog(parent == null ? new JFrame() : parent, title);
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        File f = MapFileChooser.showOpenMapDialog();
        NeptusLog.pub().info((Object)("<###> " + f));
    }
}

