/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.LocationObject;
import pt.lsts.neptus.renderer2d.CursorLocationPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.util.GuiUtils;

public class MapLocationSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    StateRenderer2D r2d = null;
    MapType dummyMap = new MapType();
    public LocationObject lo = null;
    JDialog dialog = null;

    public MapLocationSelector(final MapGroup mg) {
        this.setLayout(new BorderLayout());
        this.r2d = new StateRenderer2D(mg);
        this.r2d.addPostRenderPainter(new CursorLocationPainter(), "Cursor Location Painter");
        this.add((Component)this.r2d, "Center");
        this.r2d.setIgnoreRightClicks(true);
        this.r2d.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LocationType lt = MapLocationSelector.this.r2d.getRealWorldLocation(e.getPoint());
                if (MapLocationSelector.this.lo == null) {
                    MapLocationSelector.this.lo = new LocationObject(mg, MapLocationSelector.this.dummyMap);
                }
                MapLocationSelector.this.lo.setCenterLocation(lt);
                MapLocationSelector.this.dummyMap.addObject(MapLocationSelector.this.lo);
                mg.removeMap(MapLocationSelector.this.dummyMap.getId());
                mg.addMap(MapLocationSelector.this.dummyMap);
                e.consume();
            }
        });
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.setLayout(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(80, 25));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MapLocationSelector.this.lo == null) {
                    GuiUtils.errorMessage(MapLocationSelector.this.dialog, "Did not set a location", "You have to set a location first");
                    return;
                }
                if (MapLocationSelector.this.dialog != null) {
                    MapLocationSelector.this.dialog.dispose();
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapLocationSelector.this.lo = null;
                if (MapLocationSelector.this.dialog != null) {
                    MapLocationSelector.this.dialog.dispose();
                }
            }
        });
        cancelButton.setPreferredSize(new Dimension(80, 25));
        okCancelPanel.add(okButton);
        okCancelPanel.add(cancelButton);
        this.add((Component)okCancelPanel, "South");
    }

    public static LocationType showDialog(Frame parent, MapGroup mg) {
        MapLocationSelector mls = new MapLocationSelector(mg);
        JDialog dialog = new JDialog(parent);
        mls.setDialog(dialog);
        dialog.setContentPane(mls);
        dialog.pack();
        GuiUtils.centerOnScreen(dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (mls.lo == null) {
            return null;
        }
        return mls.lo.getCenterLocation();
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new MapLocationSelector(MapGroup.getNewInstance(new CoordinateSystem())), "test");
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }
}

