/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.mission.MapMission;

class MapPreview
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2591033311036253447L;
    ImageIcon thumbnail = null;
    File file = null;
    StateRenderer2D r2d = new StateRenderer2D();
    JLabel id = new JLabel(" ");

    public MapPreview(JFileChooser fc) {
        this.r2d.setLegendShown(false);
        this.r2d.setVisible(false);
        this.setPreferredSize(new Dimension(120, 120));
        this.setLayout(new BorderLayout());
        this.add((Component)this.id, "North");
        this.add((Component)this.r2d, "Center");
        fc.addPropertyChangeListener(this);
    }

    public void loadFile() {
        if (this.file == null) {
            return;
        }
        try {
            MapMission mm = new MapMission();
            mm.loadMap(this.file.getAbsolutePath());
            if (mm != null) {
                this.r2d.setMap(mm.getMap());
                this.r2d.showAllMap();
                this.r2d.setVisible(true);
                this.id.setText(mm.getId());
            }
        }
        catch (Exception e) {
            this.r2d.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadFile();
                this.repaint();
            }
        }
    }
}

