/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MarksComboListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.MissionType;

public class MarkSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel = null;
    private JComboBox<AbstractElement> marksCombo = null;
    private MissionType missionType = null;

    public MarkSelector() {
        this.initialize();
    }

    public MarkSelector(MissionType mt) {
        this.setMissionType(mt);
        this.initialize();
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.setSize(217, 60);
        this.jLabel.setText(I18n.text("Choose an existing Mark:"));
        this.add((Component)this.jLabel, null);
        this.add(this.getMarksCombo(), null);
        this.initializeMarksCombo();
    }

    public LocationType getLocationType() {
        try {
            return ((MarkElement)this.marksCombo.getSelectedItem()).getCenterLocation();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void initializeMarksCombo() {
        this.marksCombo = this.getMarksCombo();
        this.marksCombo.removeAllItems();
        MapGroup mg = MapGroup.getMapGroupInstance(this.getMissionType());
        AbstractElement[] objs = mg.getAllObjects();
        NeptusLog.pub().debug((Object)(this + "Number of objects: " + objs.length));
        for (int i = 0; i < objs.length; ++i) {
            AbstractElement obj = objs[i];
            if (!obj.getType().equals("Mark")) continue;
            this.marksCombo.addItem(obj);
        }
    }

    private JComboBox<AbstractElement> getMarksCombo() {
        if (this.marksCombo == null) {
            this.marksCombo = new JComboBox();
            this.marksCombo.setPreferredSize(new Dimension(130, 24));
        }
        return this.marksCombo;
    }

    public MissionType getMissionType() {
        if (this.missionType == null) {
            this.missionType = new MissionType();
            this.missionType.setId("dummy_mission");
        }
        return this.missionType;
    }

    public void setMissionType(MissionType missionType) {
        this.missionType = missionType;
        this.initializeMarksCombo();
    }

    public void addMarksComboListener(MarksComboListener mcl) {
        final MarksComboListener markListener = mcl;
        this.marksCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MarkElement mobj = (MarkElement)MarkSelector.this.marksCombo.getSelectedItem();
                    markListener.MarkComboChanged(mobj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

