/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import pt.lsts.neptus.util.ImageUtils;

public class MiniButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon = ImageUtils.getIcon("images/buttons/web.png");
    private String toolTipText = "";
    private String actionCommand = "";
    private JButton myButton = null;
    private JToggleButton myToggleButton = null;
    private boolean toggle = false;
    private Vector<ActionListener> actionListeners = new Vector();

    public MiniButton() {
        this.setLayout(new BorderLayout());
        this.myButton = new JButton(this.icon);
        this.myButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.myButton, "Center");
    }

    public void doClick() {
        if (this.isToggle()) {
            this.myToggleButton.doClick();
        } else {
            this.myButton.doClick();
        }
    }

    public void doClick(int pressTime) {
        if (this.isToggle()) {
            this.myToggleButton.doClick(pressTime);
        } else {
            this.myButton.doClick(pressTime);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isToggle()) {
            this.myToggleButton.setEnabled(enabled);
        } else {
            this.myButton.setEnabled(enabled);
        }
    }

    public boolean getState() {
        if (this.myToggleButton != null) {
            return this.myToggleButton.isSelected();
        }
        return false;
    }

    public void setState(boolean state) {
        if (state != this.myToggleButton.isSelected()) {
            this.myToggleButton.setSelected(state);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        if (this.myButton != null) {
            this.myButton.setIcon(icon);
        }
        if (this.myToggleButton != null) {
            this.myToggleButton.setIcon(icon);
        }
        this.icon = icon;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
        if (this.myButton != null && toggle) {
            this.remove(this.myButton);
            this.myButton = null;
            this.myToggleButton = new JToggleButton(this.icon);
            this.myToggleButton.setMargin(new Insets(0, 0, 0, 0));
            this.myToggleButton.setActionCommand(this.actionCommand);
            this.myToggleButton.setToolTipText(this.toolTipText);
            this.add((Component)this.myToggleButton, "Center");
            for (ActionListener al : this.actionListeners) {
                this.myToggleButton.addActionListener(al);
            }
        }
        if (this.myToggleButton != null && !toggle) {
            this.remove(this.myToggleButton);
            this.myToggleButton = null;
            this.myButton = new JButton(this.icon);
            this.myButton.setMargin(new Insets(0, 0, 0, 0));
            this.myButton.setActionCommand(this.actionCommand);
            this.myButton.setToolTipText(this.toolTipText);
            this.add((Component)this.myButton, "Center");
            for (ActionListener al : this.actionListeners) {
                this.myButton.addActionListener(al);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (this.myButton != null) {
            this.myButton.setToolTipText(toolTipText);
        }
        if (this.myToggleButton != null) {
            this.myToggleButton.setToolTipText(toolTipText);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
        if (this.myButton != null) {
            this.myButton.setActionCommand(actionCommand);
        }
        if (this.myToggleButton != null) {
            this.myToggleButton.setActionCommand(actionCommand);
        }
    }

    public void addActionListener(ActionListener newListener) {
        this.actionListeners.add(newListener);
        if (this.myButton != null) {
            this.myButton.addActionListener(newListener);
        }
        if (this.myToggleButton != null) {
            this.myToggleButton.addActionListener(newListener);
        }
    }
}

