/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.LblConfig;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.HTTPUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.plugins.PlanChangeListener;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.gui.MissionTreeCellRenderer;
import pt.lsts.neptus.gui.MissionTreeModel;
import pt.lsts.neptus.gui.tree.ExtendedTreeNode;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.types.NameId;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.misc.LBLRangesTimer;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MissionBrowser
extends JPanel
implements PlanChangeListener {
    private static final long serialVersionUID = 1L;
    private final MissionTreeCellRenderer cellRenderer;
    private final JTree elementTree;
    private final MissionTreeModel treeModel;
    private final ArrayList<String> transToMerge;

    public MissionBrowser() {
        ConfigFetch.mark("MissionBrowser");
        this.elementTree = new JTree();
        ConfigFetch.mark("MissionTreeCellRenderer");
        this.cellRenderer = new MissionTreeCellRenderer();
        this.elementTree.setCellRenderer(this.cellRenderer);
        this.elementTree.setRootVisible(false);
        this.elementTree.setShowsRootHandles(true);
        ConfigFetch.benchmark("MissionTreeCellRenderer");
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.elementTree), "Center");
        ConfigFetch.benchmark("MissionBrowser");
        this.treeModel = new MissionTreeModel();
        this.elementTree.setModel(this.treeModel);
        this.transToMerge = new ArrayList();
    }

    public ArrayList<NameId> getSelectedItems() {
        TreePath[] selectionPaths = this.elementTree.getSelectionPaths();
        ArrayList<NameId> sel = new ArrayList<NameId>();
        if (selectionPaths == null) {
            return sel;
        }
        for (TreePath path : selectionPaths) {
            ExtendedTreeNode node = (ExtendedTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NameId)) {
                return new ArrayList<NameId>();
            }
            sel.add((NameId)userObject);
        }
        return sel;
    }

    public ExtendedTreeNode getSelectedTreeNode() {
        if (this.elementTree.getSelectionPath() == null) {
            return null;
        }
        ExtendedTreeNode node = (ExtendedTreeNode)this.elementTree.getSelectionPath().getLastPathComponent();
        return node;
    }

    public void addTransToMerge(ArrayList<NameId> remoteTrans) {
        for (NameId nameId : remoteTrans) {
            this.transToMerge.add(nameId.getIdentification());
        }
    }

    public Object getSelectedItem() {
        ExtendedTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    public void addTransponderElement(ConsoleLayout console2) {
        if (console2 == null) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Add transponder"), I18n.text("Unable to find a parent console"));
            return;
        }
        if (console2.getMission() == null) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Add transponder"), I18n.text("No mission opened in the console"));
            return;
        }
        MissionType mt = console2.getMission();
        TransponderElement te = this.transponderDialog(mt, null);
        if (!te.userCancel) {
            te.getParentMap().addObject(te);
            this.saveMission(mt);
            this.treeModel.addTransponderNode(te);
            ImcMsgManager.disseminate(te, "Transponder");
        }
    }

    private TransponderElement transponderDialog(MissionType mt, TransponderElement te) {
        String[] transNames;
        MapGroup mapGroupInstance = MapGroup.getMapGroupInstance(mt);
        MapType map = this.getMap(mt);
        try {
            Vector<TransponderElement> vector = mapGroupInstance.getAllObjectsOfType(TransponderElement.class);
            transNames = new String[vector.size()];
            int i = 0;
            for (TransponderElement transponderElement : vector) {
                transNames[i] = transponderElement.getIdentification();
                ++i;
            }
        }
        catch (NullPointerException e) {
            transNames = new String[]{};
        }
        if (te == null) {
            te = new TransponderElement(mapGroupInstance, map);
        }
        te.showParametersDialog(this, transNames, map, true);
        return te;
    }

    public void editTransponder(TransponderElement elem, MissionType mission, String vehicleId) {
        ExtendedTreeNode selectedTreeNode = this.getSelectedTreeNode();
        TransponderElement elemBefore = elem.clone();
        State state = (State)((Object)selectedTreeNode.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
        this.transponderDialog(mission, elem);
        if (!elem.userCancel) {
            if (state == State.SYNC && !elemBefore.equals(elem)) {
                this.setNodeSyncState(selectedTreeNode, State.NOT_SYNC);
            }
            MapType pivot = elem.getParentMap();
            MapChangeEvent mce = new MapChangeEvent(0);
            mce.setSourceMap(pivot);
            mce.setMapGroup(MapGroup.getMapGroupInstance(mission));
            mce.setChangedObject(elem);
            pivot.warnChangeListeners(mce);
            this.saveMission(mission);
            this.treeModel.nodeChanged(selectedTreeNode);
            this.repaint();
        }
    }

    private MapType getMap(MissionType mt) {
        MapGroup mg = MapGroup.getMapGroupInstance(mt);
        return mg.getMaps()[0];
    }

    private void saveMission(MissionType mission) {
        if (mission.getCompressedFilePath() != null) {
            mission.save(false);
        }
    }

    public void removeTransponder(TransponderElement elem, ConsoleLayout console2) {
        int ret = JOptionPane.showConfirmDialog(this, I18n.textf("Delete '%transponderName'?", elem.getDisplayName()), I18n.text("Delete"), 0);
        if (ret == 0) {
            this.treeModel.removeById(elem.getIdentification(), MissionTreeModel.ParentNodes.TRANSPONDERS);
            MapType parentMap = elem.getParentMap();
            parentMap.remove(elem.getIdentification());
            this.getMap(console2.getMission()).remove(elem.getIdentification());
            this.saveMission(console2.getMission());
        }
    }

    public void swithLocationsTransponder(TransponderElement tel1, TransponderElement tel2, ConsoleLayout console2) {
        LocationType loc1 = tel1.getCenterLocation();
        LocationType loc2 = tel2.getCenterLocation();
        tel1.setCenterLocation(loc2);
        tel2.setCenterLocation(loc1);
        MapType pivot = tel1.getParentMap();
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(pivot);
        mce.setMapGroup(MapGroup.getMapGroupInstance(console2.getMission()));
        mce.setChangedObject(tel1);
        pivot.warnChangeListeners(mce);
        MapType pivot2 = tel2.getParentMap();
        MapChangeEvent mce2 = new MapChangeEvent(0);
        mce2.setSourceMap(pivot2);
        mce2.setMapGroup(MapGroup.getMapGroupInstance(console2.getMission()));
        mce2.setChangedObject(tel2);
        pivot2.warnChangeListeners(mce2);
        LinkedHashMap<String, MapMission> mapsList = console2.getMission().getMapsList();
        MapMission mm = mapsList.get(pivot.getId());
        mm.setMap(pivot);
        pivot.saveFile(mm.getHref());
        mm = mapsList.get(pivot2.getId());
        mm.setMap(pivot2);
        pivot2.saveFile(mm.getHref());
        if (console2 != null && console2.getMission() != null && console2.getMission().getCompressedFilePath() != null) {
            console2.getMission().save(false);
            console2.updateMissionListeners();
        }
    }

    public void refreshBrowser(MissionType mission, String mainVehicleId, ConsoleLayout console) {
        TreePath[] selectedNodes = this.getSelectionPath();
        this.treeModel.setHomeRef(mission.getHomeRef());
        TreeMap<String, PlanType> localPlans = this.getLocalPlans(mission);
        this.updatePlansStateEDT(localPlans, mainVehicleId);
        this.updateTransStateEDT(mission, mainVehicleId, console);
        this.setSelectedNodes(selectedNodes);
    }

    private TreeMap<String, PlanType> getLocalPlans(MissionType mission) {
        TreeMap<String, PlanType> localPlans;
        try {
            localPlans = mission.getIndividualPlansList();
        }
        catch (NullPointerException e) {
            localPlans = new TreeMap();
        }
        return localPlans;
    }

    @Override
    public void planChange(PlanType plan) {
        this.setSelectedPlan(plan);
    }

    public boolean setContent(Transferable tr, MissionType mission) {
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].isMimeTypeEqual("text/plain; class=java.lang.String; charset=Unicode")) continue;
            String url = null;
            try {
                Object data = tr.getTransferData(flavors[i]);
                if (data instanceof InputStreamReader) {
                    BufferedReader reader = new BufferedReader((InputStreamReader)data);
                    url = reader.readLine();
                    reader.close();
                } else if (data instanceof String) {
                    url = data.toString();
                }
                return this.parseURL(url, mission);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        return false;
    }

    public void setMultiSelect(MouseEvent e) {
        TreePath path = this.elementTree.getPathForLocation(e.getX(), e.getY());
        this.elementTree.setSelectionPath(path);
    }

    public void addMouseAdapter(MouseAdapter mouseAdapter) {
        this.elementTree.addMouseListener(mouseAdapter);
    }

    public boolean parseURL(String url, MissionType mission) {
        NeptusLog.pub().error((Object)("parsing " + url));
        if (url == null || mission == null) {
            return false;
        }
        if (url.startsWith("http")) {
            String xml = HTTPUtils.get(url);
            return this.parseContents(xml, mission);
        }
        return false;
    }

    public boolean parseContents(String file, MissionType mission) {
        block22: {
            try {
                Document doc = DocumentHelper.parseText((String)file);
                String root = doc.getRootElement().getName();
                if (root.equalsIgnoreCase("home-reference")) {
                    HomeReference homeRef = new HomeReference();
                    boolean loadOk = homeRef.load(file);
                    if (loadOk) {
                        mission.getHomeRef().setCoordinateSystem(homeRef);
                        Vector<HomeReferenceElement> hrefElems = MapGroup.getMapGroupInstance(mission).getAllObjectsOfType(HomeReferenceElement.class);
                        hrefElems.get(0).setCoordinateSystem(mission.getHomeRef());
                        mission.save(false);
                        return true;
                    }
                    break block22;
                }
                if (root.equalsIgnoreCase("StartLocation")) {
                    MarkElement start = new MarkElement(file);
                    AbstractElement[] startLocs = MapGroup.getMapGroupInstance(mission).getMapObjectsByID("start");
                    MapType pivot = null;
                    if (startLocs.length == 1 && startLocs[0] instanceof MarkElement) {
                        ((MarkElement)startLocs[0]).setCenterLocation(start.getCenterLocation());
                        pivot = startLocs[0].getParentMap();
                        MapChangeEvent mce = new MapChangeEvent(0);
                        mce.setSourceMap(pivot);
                        mce.setMapGroup(pivot.getMapGroup());
                        mce.setChangedObject(startLocs[0]);
                        pivot.warnChangeListeners(mce);
                    } else if (startLocs.length == 0) {
                        try {
                            pivot = this.getMap(mission);
                            start.setId("start");
                            start.setParentMap(pivot);
                            start.setMapGroup(pivot.getMapGroup());
                            pivot.addObject(start);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                    if (pivot != null) {
                        pivot.saveFile(pivot.getHref());
                        if (mission != null && mission.getCompressedFilePath() != null) {
                            mission.save(false);
                        }
                    }
                    return true;
                }
                if (root.equalsIgnoreCase("Transponder")) {
                    TransponderElement transponder = new TransponderElement(file);
                    AbstractElement[] sameId = MapGroup.getMapGroupInstance(mission).getMapObjectsByID(transponder.getId());
                    MapType pivot = null;
                    if (sameId.length == 1 && sameId[0] instanceof TransponderElement) {
                        ((TransponderElement)sameId[0]).setCenterLocation(transponder.getCenterLocation());
                        ((TransponderElement)sameId[0]).setBuoyAttached(transponder.isBuoyAttached());
                        ((TransponderElement)sameId[0]).setConfiguration(transponder.getConfiguration());
                        pivot = sameId[0].getParentMap();
                        MapChangeEvent mce = new MapChangeEvent(0);
                        mce.setSourceMap(pivot);
                        mce.setMapGroup(pivot.getMapGroup());
                        mce.setChangedObject(sameId[0]);
                        pivot.warnChangeListeners(mce);
                    } else if (sameId.length == 0) {
                        try {
                            pivot = this.getMap(mission);
                            transponder.setParentMap(pivot);
                            transponder.setMapGroup(pivot.getMapGroup());
                            pivot.addObject(transponder);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                    if (pivot != null) {
                        pivot.saveFile(pivot.getHref());
                        if (mission != null && mission.getCompressedFilePath() != null) {
                            mission.save(false);
                        }
                    }
                    return true;
                }
                if (root.equalsIgnoreCase("Plan") && mission != null) {
                    PlanType plan = new PlanType(file, mission);
                    mission.getIndividualPlansList().put(plan.getId(), plan);
                    if (mission != null && mission.getCompressedFilePath() != null) {
                        mission.save(false);
                    }
                    return true;
                }
            }
            catch (DocumentException e) {
                NeptusLog.pub().error((Object)e);
                return false;
            }
        }
        return false;
    }

    public void addTreeListener(final ConsoleLayout console2) {
        this.elementTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selPath = MissionBrowser.this.elementTree.getSelectionPath();
                if (selPath == null) {
                    return;
                }
                ExtendedTreeNode node = (ExtendedTreeNode)selPath.getLastPathComponent();
                if (node.getUserObject() instanceof PlanType) {
                    PlanType selectedPlan = (PlanType)node.getUserObject();
                    if (console2 != null) {
                        console2.setPlan(selectedPlan);
                    }
                } else if (console2 != null) {
                    console2.setPlan(null);
                }
            }
        });
    }

    public void setSelectedPlan(PlanType plan) {
        if (this.getSelectedItem() == null || plan == null || this.getSelectedItem() == plan) {
            return;
        }
        ExtendedTreeNode planNode = null;
        ExtendedTreeNode.ChildIterator planIt = this.treeModel.getIterator(MissionTreeModel.ParentNodes.PLANS);
        try {
            NameId tmpPlan;
            while (planIt.hasNext() && !(tmpPlan = (NameId)(planNode = planIt.next()).getUserObject()).getIdentification().equals(plan.getIdentification())) {
            }
            if (planNode == null) {
                NeptusLog.pub().error((Object)("Cannot find a plan with id " + plan.getIdentification() + ". It was not set as selected."));
                return;
            }
            TreePath selPath = new TreePath(this.treeModel.getPathToRoot(planNode));
            this.elementTree.setSelectionPath(selPath);
            this.elementTree.scrollPathToVisible(selPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<ExtendedTreeNode> getSelectedNodes() {
        ArrayList<ExtendedTreeNode> nodes = new ArrayList<ExtendedTreeNode>();
        TreePath[] selectionPaths = this.elementTree.getSelectionPaths();
        if (selectionPaths == null) {
            return nodes;
        }
        for (int i = 0; i < selectionPaths.length; ++i) {
            ExtendedTreeNode node = (ExtendedTreeNode)selectionPaths[i].getLastPathComponent();
            nodes.add(node);
        }
        return nodes;
    }

    public TreePath[] getSelectionPath() {
        return this.elementTree.getSelectionPaths();
    }

    public void setSelectedNodes(TreePath[] selectedNodes) {
        this.elementTree.setSelectionPaths(selectedNodes);
    }

    public void updatePlansStateEDT(final TreeMap<String, PlanType> localPlans, final String sysName) {
        final Map<String, PlanDBInfo> remotePlans = this.getRemotePlans(sysName);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashSet existingPlans = MissionBrowser.this.mergeLocalPlans(localPlans, sysName, MissionBrowser.this.treeModel);
                MissionBrowser.this.treeModel.removeSet(existingPlans, MissionTreeModel.ParentNodes.PLANS);
                existingPlans = MissionBrowser.this.mergeRemotePlans(sysName, remotePlans, MissionBrowser.this.treeModel, existingPlans);
                MissionBrowser.this.elementTree.expandPath(MissionBrowser.this.treeModel.getPathToParent(MissionTreeModel.ParentNodes.PLANS));
                MissionBrowser.this.revalidate();
                MissionBrowser.this.repaint();
            }
        });
    }

    private HashSet<String> mergeRemotePlans(String sysName, Map<String, PlanDBInfo> remotePlans, MissionTreeModel treeModel, HashSet<String> existingPlans) {
        HashSet<String> remotePlansIds = new HashSet<String>();
        remotePlansIds.addAll(remotePlans.keySet());
        for (String planId : remotePlansIds) {
            existingPlans.add(planId);
            ExtendedTreeNode target = treeModel.findNode(planId, MissionTreeModel.ParentNodes.PLANS);
            PlanDBInfo remotePlan = remotePlans.get(planId);
            if (target == null) {
                target = new ExtendedTreeNode(remotePlan);
                target.getUserInfo().put(MissionTreeModel.NodeInfoKey.ID.name(), planId);
                this.setNodeSyncState(target, State.REMOTE);
                treeModel.insertAlphabetically(target, MissionTreeModel.ParentNodes.PLANS);
            } else {
                Object existingPlan = target.getUserObject();
                if (existingPlan instanceof PlanDBInfo) {
                    this.setNodeSyncState(target, State.REMOTE);
                    target.setUserObject(remotePlan);
                } else if (existingPlan instanceof PlanType) {
                    byte[] remoteMD5;
                    PlanType existingLocalPlan = (PlanType)existingPlan;
                    byte[] localMD5 = existingLocalPlan.asIMCPlan().payloadMD5();
                    if (ByteUtil.equal(localMD5, remoteMD5 = remotePlan.getMd5())) {
                        this.setNodeSyncState(target, State.SYNC);
                    } else {
                        this.setNodeSyncState(target, State.NOT_SYNC);
                    }
                }
            }
            target.getUserInfo().put(MissionTreeModel.NodeInfoKey.VEHICLE.name(), sysName);
        }
        return existingPlans;
    }

    private HashSet<String> mergeRemoteTrans(String sysName, Vector<LblBeacon> remoteList, MissionTreeModel treeModel, HashSet<String> existing, MissionType mission, ConsoleLayout console) {
        TransponderElement tempTrans;
        ExtendedTreeNode tempNode;
        HashMap<String, TransponderElement> idMap = new HashMap<String, TransponderElement>();
        ExtendedTreeNode.ChildIterator transIt = treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        while (transIt.hasNext()) {
            tempNode = transIt.next();
            TransponderElement transponderElement = (TransponderElement)tempNode.getUserObject();
            idMap.put(transponderElement.getIdentification(), transponderElement);
        }
        boolean saveMisison = false;
        boolean found = false;
        short id = 0;
        for (LblBeacon lblBeacon : remoteList) {
            found = false;
            transIt = treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
            tempTrans = null;
            while (transIt.hasNext()) {
                tempNode = transIt.next();
                tempTrans = (TransponderElement)tempNode.getUserObject();
                if (!tempTrans.getIdentification().equals(lblBeacon.getBeacon())) continue;
                if (tempTrans.equals(lblBeacon)) {
                    this.setNodeSyncState(tempNode, State.SYNC);
                } else if (this.transToMerge.contains(tempTrans.getIdentification())) {
                    ExtendedTreeNode treeNode = treeModel.findNode(lblBeacon.getBeacon(), MissionTreeModel.ParentNodes.TRANSPONDERS);
                    TransponderElement newTrans = new TransponderElement(lblBeacon, id, tempTrans.getMapGroup(), tempTrans.getParentMap());
                    treeNode.setUserObject(newTrans);
                    this.transToMerge.remove(lblBeacon.getBeacon());
                    this.setNodeSyncState(treeNode, State.SYNC);
                    newTrans.getParentMap().addObject(newTrans);
                    this.saveMission(mission);
                } else {
                    this.setNodeSyncState(tempNode, State.NOT_SYNC);
                }
                tempTrans.setDuneId(id);
                idMap.remove(tempTrans.getIdentification());
                found = true;
                break;
            }
            if (!found) {
                MapGroup mapGroup = MapGroup.getMapGroupInstance(mission);
                MapType map = this.getMap(mission);
                tempTrans = new TransponderElement(lblBeacon, id, mapGroup, map);
                ExtendedTreeNode node = new ExtendedTreeNode(tempTrans);
                this.setNodeSyncState(node, State.SYNC);
                treeModel.insertAlphabetically(node, MissionTreeModel.ParentNodes.TRANSPONDERS);
                map.addObject(tempTrans);
                saveMisison = true;
            }
            existing.add(tempTrans.getIdentification());
            id = (short)(id + 1);
        }
        if (saveMisison) {
            this.saveMission(mission);
        }
        transIt = treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        while (transIt.hasNext() && idMap.size() > 0) {
            tempNode = transIt.next();
            tempTrans = (TransponderElement)tempNode.getUserObject();
            String tempId = tempTrans.getIdentification();
            if (!idMap.containsKey(tempId)) continue;
            ((TransponderElement)tempNode.getUserObject()).setDuneId((short)-1);
            idMap.remove(tempId);
        }
        return existing;
    }

    private HashSet<String> mergeLocalPlans(TreeMap<String, PlanType> localPlans, String sysName, MissionTreeModel treeModel) {
        Set<String> localPlansIds = localPlans.keySet();
        HashSet<String> existingPlans = new HashSet<String>();
        for (String planId : localPlansIds) {
            existingPlans.add(planId);
            ExtendedTreeNode target = treeModel.findNode(planId, MissionTreeModel.ParentNodes.PLANS);
            PlanType plan = localPlans.get(planId);
            if (target == null) {
                ExtendedTreeNode newNode = new ExtendedTreeNode(plan);
                newNode.getUserInfo().put(MissionTreeModel.NodeInfoKey.ID.name(), planId);
                treeModel.insertAlphabetically(newNode, MissionTreeModel.ParentNodes.PLANS);
                target = newNode;
            } else {
                target.setUserObject(plan);
            }
            this.setNodeSyncState(target, State.LOCAL);
            target.getUserInfo().put(MissionTreeModel.NodeInfoKey.VEHICLE.name(), sysName);
        }
        return existingPlans;
    }

    private HashSet<String> mergeLocalTrans(LinkedHashMap<String, TransponderElement> local, String sysName, MissionTreeModel treeModel, MissionTreeModel.ParentNodes itemType) {
        Set<String> localIds = local.keySet();
        HashSet<String> existing = new HashSet<String>();
        for (String id : localIds) {
            existing.add(id);
            ExtendedTreeNode target = treeModel.findNode(id, itemType);
            TransponderElement localTrans = local.get(id);
            if (target == null) {
                localTrans.setDuneId((short)-1);
                ExtendedTreeNode newNode = new ExtendedTreeNode(localTrans);
                treeModel.insertAlphabetically(newNode, itemType);
                target = newNode;
            } else {
                target.setUserObject(localTrans);
            }
            this.setNodeSyncState(target, State.LOCAL);
            target.getUserInfo().put(MissionTreeModel.NodeInfoKey.VEHICLE.name(), sysName);
        }
        return existing;
    }

    private Map<String, PlanDBInfo> getRemotePlans(String sysName) {
        Map<String, PlanDBInfo> remotePlans;
        try {
            remotePlans = ImcSystemsHolder.lookupSystemByName(sysName).getPlanDBControl().getRemoteState().getStoredPlans();
        }
        catch (NullPointerException e) {
            remotePlans = new LinkedHashMap<String, PlanDBInfo>();
        }
        return remotePlans;
    }

    private Vector<LblBeacon> getRemoteTrans(String sysName) {
        try {
            return ((LblConfig)ImcSystemsHolder.lookupSystemByName(sysName).retrieveData("LblConfig")).getBeacons();
        }
        catch (NullPointerException e) {
            return new Vector<LblBeacon>();
        }
    }

    public void transUpdateTimer(short id, String mainVehicle) {
        ExtendedTreeNode.ChildIterator transIt = this.treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        boolean reval = false;
        while (transIt.hasNext()) {
            ExtendedTreeNode transNode = transIt.next();
            TransponderElement trans = (TransponderElement)transNode.getUserObject();
            HashMap<String, Object> userInfo = transNode.getUserInfo();
            short nodeId = trans.duneId;
            String transVehicle = (String)userInfo.get(MissionTreeModel.NodeInfoKey.VEHICLE.name());
            if (nodeId != id || !transVehicle.equals(mainVehicle)) continue;
            ImcSystem imcSystems = ImcSystemsHolder.lookupSystemByName(transVehicle);
            if (imcSystems == null) break;
            String name = trans.getIdentification();
            LBLRangesTimer timer = (LBLRangesTimer)imcSystems.retrieveData(name);
            if (timer == null) {
                timer = new LBLRangesTimer();
                imcSystems.storeData(name, timer);
            }
            timer.resetTime();
            reval = true;
            break;
        }
        if (reval) {
            this.revalidate();
        }
    }

    public void transStartVehicleTimers(String mainVehicle) {
        ExtendedTreeNode.ChildIterator transIt = this.treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        while (transIt.hasNext()) {
            ImcSystem imcSystems;
            ExtendedTreeNode transNode = transIt.next();
            HashMap<String, Object> userInfo = transNode.getUserInfo();
            String transVehicle = (String)userInfo.get(MissionTreeModel.NodeInfoKey.VEHICLE.name());
            State nodeSync = (State)((Object)userInfo.get(MissionTreeModel.NodeInfoKey.SYNC.name()));
            if (nodeSync != State.SYNC || !transVehicle.equals(mainVehicle) || (imcSystems = ImcSystemsHolder.lookupSystemByName(transVehicle)) == null) continue;
            String name = ((TransponderElement)transNode.getUserObject()).getIdentification();
            LBLRangesTimer timer = (LBLRangesTimer)imcSystems.retrieveData(name);
            if (timer == null) {
                timer = new LBLRangesTimer();
                imcSystems.storeData(name, timer);
            }
            timer.resetTime();
        }
        this.revalidate();
    }

    public void transStopTimers() {
        ExtendedTreeNode.ChildIterator transIt = this.treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        while (transIt.hasNext()) {
            String name;
            LBLRangesTimer timer;
            ExtendedTreeNode transNode = transIt.next();
            HashMap<String, Object> transInfo = transNode.getUserInfo();
            String transVehicle = (String)transInfo.get(MissionTreeModel.NodeInfoKey.VEHICLE.name());
            ImcSystem imcSystems = ImcSystemsHolder.lookupSystemByName(transVehicle);
            if (imcSystems == null || (timer = (LBLRangesTimer)imcSystems.retrieveData(name = ((TransponderElement)transNode.getUserObject()).getIdentification())) == null) continue;
            timer.stopTimer();
        }
        this.revalidate();
    }

    public void updateTransStateEDT(final MissionType mission, final String sysName, final Vector<LblBeacon> remoteTrans, final ConsoleLayout console) {
        final LinkedHashMap<String, TransponderElement> localTrans = this.getLocalTrans(mission);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashSet existingTrans = MissionBrowser.this.mergeLocalTrans(localTrans, sysName, MissionBrowser.this.treeModel, MissionTreeModel.ParentNodes.TRANSPONDERS);
                existingTrans = MissionBrowser.this.mergeRemoteTrans(sysName, remoteTrans, MissionBrowser.this.treeModel, existingTrans, mission, console);
                MissionBrowser.this.treeModel.removeSet(existingTrans, MissionTreeModel.ParentNodes.TRANSPONDERS);
                MissionBrowser.this.elementTree.expandPath(MissionBrowser.this.treeModel.getPathToParent(MissionTreeModel.ParentNodes.TRANSPONDERS));
                MissionBrowser.this.repaint();
            }
        });
    }

    public void updateTransStateEDT(MissionType mission, String sysName, ConsoleLayout console) {
        this.updateTransStateEDT(mission, sysName, this.getRemoteTrans(sysName), console);
    }

    private LinkedHashMap<String, TransponderElement> getLocalTrans(MissionType mission) {
        LinkedHashMap<String, TransponderElement> map = new LinkedHashMap<String, TransponderElement>();
        try {
            Vector<TransponderElement> vector = MapGroup.getMapGroupInstance(mission).getAllObjectsOfType(TransponderElement.class);
            for (TransponderElement transponderElement : vector) {
                map.put(transponderElement.getIdentification(), transponderElement);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return map;
    }

    public <T extends NameId> void removeCurrSelectedNodeRemotely() {
        ExtendedTreeNode selectionNode = this.getSelectedTreeNode();
        if (selectionNode == null) {
            return;
        }
        State syncState = (State)((Object)selectionNode.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
        switch (syncState) {
            case SYNC: 
            case NOT_SYNC: {
                this.setNodeSyncState(selectionNode, State.LOCAL);
                break;
            }
            case REMOTE: {
                Object selectedItem = this.getSelectedItem();
                this.treeModel.removeById(((NameId)selectedItem).getIdentification(), MissionTreeModel.ParentNodes.PLANS);
                break;
            }
            case LOCAL: {
                NeptusLog.pub().error((Object)"Invalid removal of local plan, this is ok if it is triggered by duplicate sending of plan deletion.");
                break;
            }
            default: {
                NeptusLog.pub().error((Object)"Invalid local removal of plan with unkown state");
            }
        }
    }

    public <T extends NameId> void deleteCurrSelectedNodeLocally() {
        ArrayList<ExtendedTreeNode> selectedNodes = this.getSelectedNodes();
        block5: for (ExtendedTreeNode selectionNode : selectedNodes) {
            State syncState = (State)((Object)selectionNode.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
            NameId userObject = (NameId)selectionNode.getUserObject();
            switch (syncState) {
                case SYNC: 
                case NOT_SYNC: {
                    PlanDBInfo remoteNode = new PlanDBInfo();
                    remoteNode.setPlanId(userObject.getIdentification());
                    ExtendedTreeNode node = new ExtendedTreeNode(remoteNode);
                    this.setNodeSyncState(node, State.REMOTE);
                    this.treeModel.insertAlphabetically(node, MissionTreeModel.ParentNodes.PLANS);
                }
                case LOCAL: {
                    this.treeModel.removeById(userObject.getIdentification(), MissionTreeModel.ParentNodes.PLANS);
                    continue block5;
                }
                case REMOTE: {
                    NeptusLog.pub().error((Object)"Invalid local removal of remote plan");
                    continue block5;
                }
            }
            NeptusLog.pub().error((Object)"Invalid local removal of plan with unkown state");
        }
    }

    public void setPlanAsSync(String planId) {
        ExtendedTreeNode plan = this.treeModel.findNode(planId, MissionTreeModel.ParentNodes.PLANS);
        if (plan != null) {
            this.setNodeSyncState(plan, State.SYNC);
        }
    }

    private void setNodeSyncState(ExtendedTreeNode child, State state) {
        child.getUserInfo().put(MissionTreeModel.NodeInfoKey.SYNC.name(), (Object)state);
        this.repaint();
    }

    public void setDebugOn(boolean value) {
        TreeCellRenderer cr = this.elementTree.getCellRenderer();
        if (cr instanceof MissionTreeCellRenderer) {
            ((MissionTreeCellRenderer)cr).debugOn = value;
        }
    }

    public void setMaxAcceptableElapsedTime(int maxAcceptableElapsedTime) {
        this.cellRenderer.maxAcceptableElapsedTime = maxAcceptableElapsedTime;
    }

    public ArrayList<TransponderElement> getTransponders() {
        ExtendedTreeNode.ChildIterator transIt = this.treeModel.getIterator(MissionTreeModel.ParentNodes.TRANSPONDERS);
        ArrayList<TransponderElement> trans = new ArrayList<TransponderElement>();
        ExtendedTreeNode transNode = null;
        while (transIt.hasNext()) {
            transNode = transIt.next();
            TransponderElement t = (TransponderElement)transNode.getUserObject();
            trans.add(t);
        }
        return trans;
    }

    public static enum State {
        SYNC("Sync"),
        NOT_SYNC("Unsync"),
        REMOTE("Remote"),
        LOCAL("Local");

        private final String fileName;

        private State(String name) {
            this.fileName = name;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

