/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MissionPreview;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MissionFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -749492337802300793L;

    private static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File showOpenMissionDialog(String[] possibleExtensions) {
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File(ConfigFetch.getConfigFile()));
        jfc.setAccessory(new MissionPreview(jfc));
        jfc.setFileView(new NeptusFileView());
        final String[] exts = possibleExtensions;
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MissionFileChooser.getExtension(f);
                if (extension != null) {
                    for (String ext : exts) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                if (exts.length == 0) {
                    return I18n.text("Mission Files");
                }
                String desc = I18n.text("Mission files") + " ('" + exts[0] + "'";
                for (int i = 1; i < exts.length; ++i) {
                    desc = desc + ", '" + exts[i] + "'";
                }
                desc = desc + ")";
                return desc;
            }
        });
        int result = jfc.showDialog(ConfigFetch.getSuperParentFrame(), I18n.text("Open Mission"));
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        File f = MissionFileChooser.showOpenMissionDialog(new String[]{"nmis", "xml"});
        NeptusLog.pub().info((Object)("<###> " + f));
    }
}

