/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MissionInfoPanel
extends ParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel1 = null;
    private JTextField missionNameField = null;
    private JLabel jLabel1 = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel = null;
    private JTextField missionIDField = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel2 = null;
    private JComboBox<?> typeCombo = null;
    private JLabel jLabel3 = null;
    private JButton cancelBtn = null;
    private JButton okBtn = null;
    private MissionType mission;
    private JDialog dialog;
    private boolean userCanceled = false;
    private boolean editable;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JTextPane description = null;

    public MissionInfoPanel() {
        this.initialize();
        this.add((Component)this.getJPanel1(), "Center");
    }

    private void initialize() {
        this.jLabel3 = new JLabel();
        this.setLayout(null);
        this.setSize(327, 324);
        this.setMinimumSize(new Dimension(327, 324));
        this.jLabel3.setBounds(10, 128, 151, 21);
        this.jLabel3.setText("Mission Description:");
        this.add((Component)this.getJPanel1(), null);
        this.add((Component)this.getJPanel2(), null);
        this.add((Component)this.getJPanel4(), null);
        this.add((Component)this.jLabel3, null);
        this.add((Component)this.getCancelBtn(), null);
        this.add((Component)this.getOkBtn(), null);
        this.add((Component)this.getJPanel(), null);
    }

    @Override
    public String getErrors() {
        if (this.getMissionNameField().getText().length() == 0) {
            return "The mission must have a name";
        }
        if (this.getJTextField().getText().length() == 0) {
            return "The mission must have an identifier";
        }
        if (!NameNormalizer.isNeptusValidIdentifier(this.getJTextField().getText())) {
            return "The mission identifier is not vallid";
        }
        if (this.getDescription().getText().length() == 0) {
            return "The mission description is empty";
        }
        return null;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel1 = new JLabel();
            this.jPanel1 = new JPanel();
            this.jLabel1.setText("Mission Name:");
            this.jPanel1.setBounds(10, 8, 310, 29);
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add((Component)this.getMissionNameField(), null);
            this.jPanel1.add((Component)this.getMissionNameField(), null);
        }
        return this.jPanel1;
    }

    private JTextField getMissionNameField() {
        if (this.missionNameField == null) {
            this.missionNameField = new JTextField("Unnamed Mission");
            this.missionNameField.setColumns(15);
        }
        return this.missionNameField;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jLabel = new JLabel();
            this.jLabel.setText("Mission Identifier:");
            this.jPanel2.setBounds(10, 47, 310, 29);
            this.jPanel2.add((Component)this.jLabel, null);
            this.jPanel2.add((Component)this.getJTextField(), null);
        }
        return this.jPanel2;
    }

    private JTextField getJTextField() {
        if (this.missionIDField == null) {
            this.missionIDField = new JTextField("MissionID");
            this.missionIDField.setColumns(15);
        }
        return this.missionIDField;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel2 = new JLabel();
            this.jPanel4 = new JPanel();
            this.jLabel2.setText("Mission Type:");
            this.jPanel4.setBounds(10, 86, 310, 30);
            this.jPanel4.add((Component)this.jLabel2, null);
            this.jPanel4.add(this.getTypeCombo(), null);
        }
        return this.jPanel4;
    }

    private JComboBox<?> getTypeCombo() {
        if (this.typeCombo == null) {
            this.typeCombo = new JComboBox<Object>(new Object[]{"Inspection", "Test", "Other"});
            this.typeCombo.setPreferredSize(new Dimension(100, 20));
        }
        return this.typeCombo;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setBounds(230, 280, 80, 25);
            this.cancelBtn.setText("Cancel");
            this.cancelBtn.setActionCommand("cancel");
            this.cancelBtn.addActionListener(this);
        }
        return this.cancelBtn;
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton();
            this.okBtn.setBounds(140, 280, 80, 25);
            this.okBtn.setText("OK");
            this.okBtn.setActionCommand("ok");
            this.okBtn.addActionListener(this);
        }
        return this.okBtn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            if (this.getErrors() != null) {
                JOptionPane.showMessageDialog(this, this.getErrors(), "Error in the parameters", 0);
            } else {
                this.mission.setDescription(this.getDescription().getText());
                this.mission.setName(this.getMissionNameField().getText());
                this.mission.setId(this.getJTextField().getText());
                this.mission.setType(this.getTypeCombo().getSelectedItem().toString());
                this.setUserCanceled(true);
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
        if ("cancel".equals(e.getActionCommand())) {
            this.setUserCanceled(true);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public void showDialog() {
        this.dialog = new JDialog(ConfigFetch.getSuperParentAsFrame(), "Mission Information");
        this.dialog.add(this);
        this.dialog.setSize(this.getWidth() + 15, this.getHeight() + 25);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setResizable(false);
        this.dialog.setModal(true);
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MissionInfoPanel.this.setUserCanceled(true);
                MissionInfoPanel.this.dialog.setVisible(false);
                MissionInfoPanel.this.dialog.dispose();
            }
        });
    }

    public static MissionType changeMissionParameters(MissionType mission) {
        if (mission == null) {
            JOptionPane.showMessageDialog(null, "You have to create a mission first", "Create a mission first", 2);
            return null;
        }
        MissionInfoPanel panel = new MissionInfoPanel();
        panel.setMission(mission);
        panel.showDialog();
        return panel.getMission();
    }

    public static MissionType showMissionInfoDialog(MissionType mission) {
        if (mission == null) {
            JOptionPane.showMessageDialog(null, "You have to create a mission first", "Create a mission first", 2);
            return null;
        }
        MissionInfoPanel panel = new MissionInfoPanel();
        panel.setMission(mission);
        panel.setEditable(false);
        panel.showDialog();
        return panel.getMission();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBounds(10, 158, 307, 111);
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getDescription());
        }
        return this.jScrollPane;
    }

    private JTextPane getDescription() {
        if (this.description == null) {
            this.description = new JTextPane();
        }
        return this.description;
    }

    public static void main(String[] args) {
        MissionType mt = new MissionType();
        mt = MissionInfoPanel.changeMissionParameters(mt);
        NeptusLog.pub().info((Object)("<###> " + mt));
    }

    public MissionType getMission() {
        return this.mission;
    }

    public void setMission(MissionType mission) {
        this.mission = mission;
        this.getDescription().setText(mission.getDescription());
        this.getMissionNameField().setText(mission.getName());
        this.getJTextField().setText(mission.getId());
        this.getTypeCombo().setSelectedItem(mission.getType());
    }

    public boolean isUserCanceled() {
        return this.userCanceled;
    }

    public void setUserCanceled(boolean userCanceled) {
        this.userCanceled = userCanceled;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getMissionNameField().setEditable(this.editable);
        this.getDescription().setEditable(this.editable);
        this.getJTextField().setEditable(this.editable);
        this.getTypeCombo().setEnabled(this.editable);
        this.getCancelBtn().setVisible(this.editable);
    }

    public void setIdEditable(boolean value) {
        this.getJTextField().setEditable(this.editable);
        this.getCancelBtn().setVisible(this.editable);
    }
}

