/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.ZipUtils;

class MissionPreview
extends JLabel
implements PropertyChangeListener {
    private static final long serialVersionUID = 288244642142172020L;
    ImageIcon thumbnail = null;
    File file = null;

    public MissionPreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(120, 50));
        this.setFont(new Font("Lucida Sans", 0, 10));
        fc.addPropertyChangeListener(this);
    }

    private LinkedHashMap<String, String> loadHeader(File f) {
        final LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        final SAXReader reader = new SAXReader();
        reader.addHandler("/mission-def/header/name", new ElementHandler(){

            public void onEnd(ElementPath arg0) {
                header.put("name", arg0.getCurrent().getText());
                reader.removeHandler("/mission-def/header/name");
            }

            public void onStart(ElementPath arg0) {
            }
        });
        reader.addHandler("/mission-def/header/description", new ElementHandler(){

            public void onEnd(ElementPath arg0) {
                header.put("description", arg0.getCurrent().getText());
                reader.removeHandler("/mission-def/header/description");
            }

            public void onStart(ElementPath arg0) {
            }
        });
        if (FileUtil.getFileExtension(f).equalsIgnoreCase("nmisz") || FileUtil.getFileExtension(f).equalsIgnoreCase("zip")) {
            try {
                InputStream is = ZipUtils.getMissionZipedAsInputSteam(f.getAbsolutePath());
                if (is != null) {
                    reader.read(is);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        } else {
            try {
                reader.read(f);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        return header;
    }

    public void loadFile() {
        if (this.file == null) {
            this.setText("");
            return;
        }
        try {
            LinkedHashMap<String, String> header = this.loadHeader(this.file);
            if (header.values().size() != 2) {
                this.setText("<html><font color='red'>" + I18n.text("Not a valid mission") + "</font></html>");
            } else {
                this.setText("<html><font color='blue'>Name: </font>" + header.get("name") + "<hr><font color='blue'>" + I18n.text("Description") + ":</font><br>" + header.get("description") + "</html>");
            }
        }
        catch (Exception e) {
            this.setText("<html><font color='red'>" + I18n.text("Not a valid mission") + "</font></html>");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadFile();
                this.repaint();
            }
        }
    }
}

