/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.gui.MissionBrowser;
import pt.lsts.neptus.gui.MissionTreeModel;
import pt.lsts.neptus.gui.tree.ExtendedTreeNode;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.misc.LBLRangesTimer;
import pt.lsts.neptus.types.mission.ChecklistMission;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.VehicleMission;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class MissionTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ImageIcon MAP_ICON = ImageUtils.createImageIcon("images/menus/mapeditor.png");
    private final ImageIcon SETTINGS_ICON = ImageUtils.createImageIcon("images/menus/settings.png");
    private final ImageIcon CHECKLIST_ICON = ImageUtils.createImageIcon("images/buttons/checklist.png");
    private final ImageIcon DIR_ICON = ImageUtils.createImageIcon("images/menus/open.png");
    private final ImageIcon DIR_CLOSED_ICON = ImageUtils.createImageIcon("images/menus/folder_closed.png");
    private final ImageIcon HOMEREF_ICON = ImageUtils.getScaledIcon("images/buttons/homeRef.png", 16, 16);
    private final ImageIcon START_ICON = ImageUtils.getScaledIcon("images/flag2_green32.png", 16, 16);
    private final ImageIcon PLAN_LOCAL = ImageUtils.getScaledIcon("images/plans/planLocal.png", 16, 16);
    private final ImageIcon PLAN_LOCAL_ACOUSTIC = ImageUtils.getScaledIcon("images/plans/planLocalAcoustic.png", 16, 16);
    private final ImageIcon PLAN_REMOTE = ImageUtils.getScaledIcon("images/plans/planRemote.png", 16, 16);
    private final ImageIcon PLAN_REMOTE_ACOUSTIC = ImageUtils.getScaledIcon("images/plans/planRemoteAcoustic.png", 16, 16);
    private final ImageIcon PLAN_UNSYNC = ImageUtils.getScaledIcon("images/plans/planUnsync.png", 16, 16);
    private final ImageIcon PLAN_UNSYNC_ACOUSTIC = ImageUtils.getScaledIcon("images/plans/planUnsyncAcoustic.png", 16, 16);
    private final ImageIcon PLAN_SYNC = ImageUtils.getScaledIcon("images/plans/planSync.png", 16, 16);
    private final ImageIcon PLAN_SYNC_ACOUSTIC = ImageUtils.getScaledIcon("images/plans/planSyncAcoustic.png", 16, 16);
    public int maxAcceptableElapsedTime;
    public boolean debugOn = false;
    private static final long serialVersionUID = -2666337254439313801L;
    private static HashMap<String, ImageIcon> VEHICLES_ICONS = new HashMap();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setToolTipText(null);
        if (leaf) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof MapType || node.getUserObject() instanceof MapMission) {
                this.setIcon(this.MAP_ICON);
                this.setToolTipText("Edit the map");
            } else if (node.getUserObject() instanceof PlanType) {
                MissionBrowser.State state = MissionBrowser.State.LOCAL;
                try {
                    ExtendedTreeNode ptn;
                    MissionBrowser.State sync;
                    if (node instanceof ExtendedTreeNode && (sync = (MissionBrowser.State)((Object)(ptn = (ExtendedTreeNode)node).getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()))) != null) {
                        state = sync;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PlanType plan = (PlanType)node.getUserObject();
                try {
                    this.setPlanIcon(plan.getId(), state, plan.hasMultipleVehiclesAssociated());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setToolTipText(plan.toStringWithVehicles());
            } else if (node.getUserObject() instanceof PlanDBInfo) {
                PlanDBInfo plan = (PlanDBInfo)node.getUserObject();
                this.setPlanIcon(plan.getPlanId(), MissionBrowser.State.REMOTE, false);
            } else if (node.getUserObject() instanceof HomeReference) {
                this.setIcon(this.HOMEREF_ICON);
                this.setText(new LocationType((HomeReference)node.getUserObject()).toString());
                this.setToolTipText("View/Edit home reference");
            } else if (node.getUserObject() instanceof MarkElement) {
                this.setIcon(this.START_ICON);
                this.setText(((MarkElement)node.getUserObject()).getPosition().toString());
                this.setToolTipText("View/Edit navigation startup position");
            } else if (node.getUserObject() instanceof VehicleMission) {
                ImageIcon vehicleIcon = null;
                try {
                    vehicleIcon = VEHICLES_ICONS.get(((VehicleMission)node.getUserObject()).getVehicle().getId());
                    if (vehicleIcon == null) {
                        int width;
                        Image vehicleImage = !((VehicleMission)node.getUserObject()).getVehicle().getPresentationImageHref().equalsIgnoreCase("") ? ImageUtils.getImage(((VehicleMission)node.getUserObject()).getVehicle().getPresentationImageHref()) : ImageUtils.getImage(((VehicleMission)node.getUserObject()).getVehicle().getSideImageHref());
                        int desiredWidth = 16;
                        int desiredHeight = 16;
                        int height = vehicleImage.getHeight(null);
                        if (height > (width = vehicleImage.getWidth(null))) {
                            desiredWidth = (int)(16.0 * ((double)width / (double)height));
                        } else {
                            desiredHeight = (int)(16.0 * ((double)height / (double)width));
                        }
                        ImageIcon vIcon = new ImageIcon(vehicleImage.getScaledInstance(desiredWidth, desiredHeight, 1));
                        this.setIcon(vIcon);
                        VEHICLES_ICONS.put(((VehicleMission)node.getUserObject()).getVehicle().getId(), vIcon);
                    } else {
                        this.setIcon(vehicleIcon);
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().info((Object)(((VehicleMission)node.getUserObject()).getId() + " vehicle not found!"));
                }
                this.setToolTipText("View/Edit the vehicle information");
            } else if (node.getUserObject() == "Mission Information" || node.getUserObject() == "Info") {
                this.setIcon(this.SETTINGS_ICON);
            } else if (node.getUserObject() instanceof ChecklistType || node.getUserObject() instanceof ChecklistMission) {
                this.setIcon(this.CHECKLIST_ICON);
                this.setToolTipText("Edit the checklist");
            } else if (node.getUserObject() instanceof TransponderElement) {
                MissionBrowser.State state = MissionBrowser.State.LOCAL;
                ExtendedTreeNode ptn = (ExtendedTreeNode)node;
                TransponderElement nodeObj = (TransponderElement)node.getUserObject();
                HashMap<String, Object> info = ptn.getUserInfo();
                ImcSystem imcSystem = ImcSystemsHolder.lookupSystemByName((String)info.get(MissionTreeModel.NodeInfoKey.VEHICLE.name()));
                this.setBeaconLabel(nodeObj, imcSystem);
                this.setBeaconIcon(state, ptn);
            } else if (node.getUserObject() == "Settings") {
                this.setIcon(this.SETTINGS_ICON);
            } else {
                this.setIcon(expanded ? this.DIR_ICON : this.DIR_CLOSED_ICON);
            }
        } else {
            this.setIcon(expanded ? this.DIR_ICON : this.DIR_CLOSED_ICON);
        }
        this.setPreferredSize(new Dimension(200, 120));
        return this;
    }

    private void setBeaconIcon(MissionBrowser.State state, ExtendedTreeNode ptn) {
        MissionBrowser.State sync = (MissionBrowser.State)((Object)ptn.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
        if (sync != null) {
            state = sync;
        }
        StringBuilder fileName = new StringBuilder(Icons.PATH_SOURCE.getName());
        fileName.append(Icons.BEACONS_PATH.getName());
        fileName.append(Icons.BEACON.getName());
        fileName.append(state.getFileName());
        fileName.append(Icons.EXTENSION.getName());
        this.setIcon(ImageUtils.getIcon(fileName.toString()));
    }

    private void setBeaconLabel(TransponderElement nodeObj, ImcSystem imcSystem) {
        LBLRangesTimer timer;
        this.setText(nodeObj.getDisplayName());
        if (imcSystem != null && (timer = (LBLRangesTimer)imcSystem.retrieveData(nodeObj.getIdentification())) != null) {
            int time = timer.getTime();
            if (time == -1) {
                this.setText(nodeObj.getDisplayName());
            } else {
                String color = time <= this.maxAcceptableElapsedTime ? "green" : "red";
                int minutes = time / 60;
                int seconds = time % 60;
                String formatedTime = minutes > 0 ? minutes + "min " + seconds + "s" : seconds + "s";
                this.setText("<html>" + nodeObj.getDisplayName() + " (<span color='" + color + "'>&#916;t " + formatedTime + "</span>)");
            }
        }
    }

    private void setPlanIcon(String planId, MissionBrowser.State state, boolean hasMultpVehicles) {
        String fileName;
        StringBuilder fileNameBuilder = new StringBuilder(Icons.PLAN.getName());
        fileNameBuilder.append(state.getFileName());
        if (planId.length() <= GeneralPreferences.maximumSizePlanNameForAcoustics) {
            fileNameBuilder.append(Icons.ACOUSTIC.getName());
        }
        if (hasMultpVehicles) {
            fileNameBuilder.append(Icons.MULTIPLE_VEHICLES.getName());
        }
        switch (fileName = fileNameBuilder.toString()) {
            case "planLocal": {
                this.setIcon(this.PLAN_LOCAL);
                break;
            }
            case "planLocalAcoustic": {
                this.setIcon(this.PLAN_LOCAL_ACOUSTIC);
                break;
            }
            case "planRemote": {
                this.setIcon(this.PLAN_REMOTE);
                break;
            }
            case "planRemoteAcoustic": {
                this.setIcon(this.PLAN_REMOTE_ACOUSTIC);
                break;
            }
            case "planUnsync": {
                this.setIcon(this.PLAN_UNSYNC);
                break;
            }
            case "planUnsyncAcoustic": {
                this.setIcon(this.PLAN_UNSYNC_ACOUSTIC);
                break;
            }
            case "planSync": {
                this.setIcon(this.PLAN_SYNC);
                break;
            }
            case "planSyncAcoustic": {
                this.setIcon(this.PLAN_SYNC_ACOUSTIC);
                break;
            }
            default: {
                NeptusLog.pub().error((Object)("No match for " + planId + " " + (Object)((Object)state) + " " + fileName + " need to add support for this state."));
            }
        }
    }

    private static enum Icons {
        PATH_SOURCE("images/"),
        PLAN("plan"),
        PLAN_PATH("plans/"),
        BEACON("beacon"),
        BEACONS_PATH("beacons/"),
        ACOUSTIC("Acoustic"),
        MULTIPLE_VEHICLES("Multp"),
        EXTENSION(".png");

        private final String name;

        private Icons(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

