/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.text.Collator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MissionBrowser;
import pt.lsts.neptus.gui.tree.ExtendedTreeNode;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.NameId;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class MissionTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 5581485271978065950L;
    private final ExtendedTreeNode trans;
    private final ExtendedTreeNode maps;
    private final ExtendedTreeNode plans;
    private ExtendedTreeNode homeR;

    public MissionTreeModel() {
        super(new ExtendedTreeNode("Mission Elements"));
        this.maps = new ExtendedTreeNode(ParentNodes.MAP.nodeName);
        this.trans = new ExtendedTreeNode(ParentNodes.TRANSPONDERS.nodeName);
        ((DefaultMutableTreeNode)this.root).add(this.trans);
        this.plans = new ExtendedTreeNode(ParentNodes.PLANS.nodeName);
        ((DefaultMutableTreeNode)this.root).add(this.plans);
    }

    private MissionTreeModel(ExtendedTreeNode maps, ExtendedTreeNode plans, ExtendedTreeNode trans) {
        super(new ExtendedTreeNode("Mission Elements"));
        this.maps = maps;
        this.trans = trans;
        this.plans = plans;
    }

    public MissionTreeModel clone() {
        ExtendedTreeNode mapsClone = this.maps.clone();
        mapsClone.cloneExtendedTreeNodeChildren(this.maps);
        ExtendedTreeNode plansClone = this.plans.clone();
        plansClone.cloneExtendedTreeNodeChildren(this.plans);
        ExtendedTreeNode transClone = this.trans.clone();
        transClone.cloneExtendedTreeNodeChildren(this.trans);
        MissionTreeModel newModel = new MissionTreeModel(mapsClone, plansClone, transClone);
        mapsClone.setParent((MutableTreeNode)newModel.root);
        plansClone.setParent((MutableTreeNode)newModel.root);
        transClone.setParent((MutableTreeNode)newModel.root);
        return newModel;
    }

    public ExtendedTreeNode findNode(String id, ParentNodes parentType) {
        ExtendedTreeNode parent = this.getParent(parentType);
        if (parent == null) {
            return null;
        }
        int nodeChildCount = this.getChildCount(parent);
        for (int c = 0; c < nodeChildCount; ++c) {
            ExtendedTreeNode childAt = (ExtendedTreeNode)parent.getChildAt(c);
            NameId temp = (NameId)childAt.getUserObject();
            if (!temp.getIdentification().equals(id)) continue;
            return childAt;
        }
        return null;
    }

    public ExtendedTreeNode addTransponderNode(TransponderElement elem) {
        ExtendedTreeNode node = new ExtendedTreeNode(elem);
        HashMap<String, Object> transInfo = node.getUserInfo();
        transInfo.put(NodeInfoKey.ID.name(), (short)-1);
        transInfo.put(NodeInfoKey.SYNC.name(), (Object)MissionBrowser.State.LOCAL);
        transInfo.put(NodeInfoKey.VEHICLE.name(), "");
        this.insertAlphabetically(node, ParentNodes.TRANSPONDERS);
        return node;
    }

    public boolean insertAlphabetically(ExtendedTreeNode newNode, ParentNodes parentType) {
        ExtendedTreeNode parent = this.getParent(parentType);
        if (parent == null) {
            return false;
        }
        NameId missionElem = (NameId)newNode.getUserObject();
        int nodeChildCount = this.getChildCount(parent);
        Collator collator = Collator.getInstance(Locale.US);
        for (int c = 0; c < nodeChildCount; ++c) {
            ExtendedTreeNode childAt = (ExtendedTreeNode)parent.getChildAt(c);
            NameId temp = (NameId)childAt.getUserObject();
            if (collator.compare(temp.getDisplayName(), missionElem.getDisplayName()) <= 0) continue;
            this.addToParents(newNode, parentType, c);
            return true;
        }
        this.addToParents(newNode, parentType, nodeChildCount);
        return true;
    }

    private void addToParents(ExtendedTreeNode node, ParentNodes parentType, int index) {
        boolean inTree;
        ExtendedTreeNode parent = this.getParent(parentType);
        this.insertNodeInto(node, parent, index);
        boolean bl = inTree = parent.getParent() != null;
        if (!inTree) {
            int parentIndex = 0;
            if (this.homeR.getParent() != null) {
                ++parentIndex;
            }
            switch (parentType) {
                case PLANS: {
                    if (this.trans.getParent() == null) break;
                    ++parentIndex;
                    break;
                }
                case TRANSPONDERS: {
                    break;
                }
                default: {
                    NeptusLog.pub().error((Object)("There is no support for " + parentType.name() + " in MissionTreeModel.addToParents()"));
                }
            }
            this.insertNodeInto(parent, (MutableTreeNode)this.root, parentIndex);
        }
    }

    public <E extends NameId> boolean removeById(E item, ExtendedTreeNode parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NameId userObject = (NameId)((ExtendedTreeNode)parent.getChildAt(i)).getUserObject();
            if (!userObject.getIdentification().equals(item.getIdentification())) continue;
            MutableTreeNode child = (MutableTreeNode)parent.getChildAt(i);
            this.removeNodeFromParent(child);
            if (childCount == 0) {
                this.removeNodeFromParent(parent);
                parent = null;
            }
            return true;
        }
        return false;
    }

    public void removeSet(HashSet<String> toDelete, ParentNodes parentType) {
        ExtendedTreeNode parent = this.getParent(parentType);
        if (parent == null) {
            return;
        }
        int count = parent.getChildCount();
        for (int p = 0; p < count; ++p) {
            ExtendedTreeNode child = (ExtendedTreeNode)parent.getChildAt(p);
            NameId childObj = (NameId)child.getUserObject();
            String id = childObj.getIdentification();
            if (toDelete.contains(id)) continue;
            this.removeById(childObj, parent);
            --count;
            --p;
        }
    }

    private ExtendedTreeNode getParent(ParentNodes parentType) {
        ExtendedTreeNode parent;
        switch (parentType) {
            case PLANS: {
                parent = this.plans;
                break;
            }
            case TRANSPONDERS: {
                parent = this.trans;
                break;
            }
            default: {
                NeptusLog.pub().error((Object)("ADD SUPPORT FOR " + parentType.name() + " IN Model.removeSet()"));
                return null;
            }
        }
        return parent;
    }

    public <E extends NameId> boolean removeById(String id, ParentNodes parentType) {
        ExtendedTreeNode parent;
        switch (parentType) {
            case PLANS: {
                parent = this.plans;
                break;
            }
            case TRANSPONDERS: {
                parent = this.trans;
                break;
            }
            default: {
                NeptusLog.pub().error((Object)("ADD SUPPORT FOR " + parentType.name() + " IN MissionBrowser.removeById()"));
                return false;
            }
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NameId userObject = (NameId)((ExtendedTreeNode)parent.getChildAt(i)).getUserObject();
            if (!userObject.getIdentification().equals(id)) continue;
            MutableTreeNode child = (MutableTreeNode)parent.getChildAt(i);
            this.removeNodeFromParent(child);
            if (childCount == 0) {
                this.removeNodeFromParent(parent);
                parent = null;
            }
            return true;
        }
        NeptusLog.pub().error((Object)("Could not find " + id));
        return false;
    }

    public void setHomeRef(HomeReference href) {
        if (this.root.getChildCount() == 0 || !(((ExtendedTreeNode)this.root.getChildAt(0)).getUserObject() instanceof HomeReference)) {
            this.homeR = new ExtendedTreeNode(href);
            this.insertNodeInto(this.homeR, (MutableTreeNode)this.root, 0);
        } else {
            this.homeR.setUserObject(href);
        }
    }

    public TreePath getPlanPath(PlanType plan) {
        if (plan == null) {
            return null;
        }
        if (this.plans != null) {
            int numPlans = this.getChildCount(this.plans);
            for (int i = 0; i < numPlans; ++i) {
                ExtendedTreeNode tmp = (ExtendedTreeNode)this.getChild(this.plans, i);
                if (tmp.getUserObject() != plan) continue;
                TreePath selPath = new TreePath(this.getPathToRoot(tmp));
                return selPath;
            }
        }
        return null;
    }

    public TreePath getPathToParent(ParentNodes parentType) {
        ExtendedTreeNode parent = this.getParent(parentType);
        return new TreePath(parent.getPath());
    }

    public ExtendedTreeNode.ChildIterator getIterator(ParentNodes parentType) {
        ExtendedTreeNode parent = this.getParent(parentType);
        if (parent == null) {
            return null;
        }
        return parent.iterator();
    }

    public void printTree(String msg, ParentNodes parentType) {
        ExtendedTreeNode.ChildIterator parentIt = this.getIterator(parentType);
        StringBuilder treeString = new StringBuilder();
        int size = 0;
        while (parentIt.hasNext()) {
            ExtendedTreeNode tempNode = parentIt.next();
            NameId tempElem = (NameId)tempNode.getUserObject();
            treeString.append(tempElem.toString());
            treeString.append(", ");
            ++size;
        }
        NeptusLog.pub().error((Object)(msg + size + " in tree:    [" + treeString + "]"));
    }

    public static enum NodeInfoKey {
        ID,
        SYNC,
        VEHICLE;

    }

    public static enum ParentNodes {
        MAP(I18n.text("Maps")),
        TRANSPONDERS(I18n.text("Transponders")),
        PLANS(I18n.text("Plans")),
        MARKS(I18n.text("Marks")),
        CHECKLISTS(I18n.text("Checklists"));

        public final String nodeName;

        private ParentNodes(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

