/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.swing.JRoundButton;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class NeptusComboButton
extends JButton
implements ActionListener {
    JButton actionButton = new ToolbarButton("images/buttons/undo.png", "undo", "undo");
    ToolbarButton dropButton = new ToolbarButton("images/buttons/drop.png", "", "drop");
    LinkedHashMap<String, Image> images = new LinkedHashMap();
    LinkedHashMap<String, String> toolTipTexts = new LinkedHashMap();
    LinkedList<String> disabledActions = new LinkedList();

    public NeptusComboButton() {
        this(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintComponents(g);
    }

    public NeptusComboButton(boolean useRoundButton) {
        int ss = 26;
        if (useRoundButton) {
            this.actionButton = new JRoundButton("images/buttons/undo.png", "undo", "undo");
            ss = 30;
        }
        this.setBorderPainted(false);
        this.setLayout(null);
        this.actionButton.setSize(ss, ss);
        this.actionButton.setBounds(0, 0, ss, ss);
        this.add(this.actionButton);
        this.dropButton.setSize(14, ss);
        this.dropButton.setBounds(ss, 0, 14, ss);
        this.dropButton.setToolTipText("Choose another option");
        this.add((Component)((Object)this.dropButton), "East");
        this.setPreferredSize(new Dimension(ss + 14, ss));
        this.setMinimumSize(new Dimension(ss + 14, ss));
        this.setMaximumSize(new Dimension(ss + 14, ss));
        this.dropButton.addActionListener(this);
        this.actionButton.addActionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                NeptusComboButton.this.dropButton.setBorderPainted(true);
                NeptusComboButton.this.actionButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                NeptusComboButton.this.dropButton.setBorderPainted(false);
                NeptusComboButton.this.actionButton.setBorderPainted(false);
            }
        };
        this.dropButton.addMouseListener(ml);
        this.actionButton.addMouseListener(ml);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("drop".equalsIgnoreCase(e.getActionCommand())) {
            JPopupMenu popup = new JPopupMenu();
            popup.setLightWeightPopupEnabled(false);
            for (String action : this.toolTipTexts.keySet().toArray(new String[0])) {
                if (this.disabledActions.contains(action)) continue;
                AbstractAction act = new AbstractAction(action, new ImageIcon(this.images.get(action))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String action = e.getActionCommand();
                        NeptusComboButton.this.actionButton.setActionCommand(action);
                        NeptusComboButton.this.actionButton.setIcon(new ImageIcon(NeptusComboButton.this.images.get(action)));
                        NeptusComboButton.this.actionButton.setToolTipText(NeptusComboButton.this.toolTipTexts.get(action));
                        NeptusComboButton.this.fireActionPerformed(new ActionEvent(this, 2000, action));
                    }
                };
                act.putValue("ShortDescription", this.toolTipTexts.get(action));
                popup.add(act);
            }
            popup.show(this, 26, 26);
        } else {
            this.fireActionPerformed(e);
        }
    }

    public void addAction(String action, String tooltipText, Image image) {
        this.toolTipTexts.put(action, tooltipText);
        this.images.put(action, image);
        if (this.toolTipTexts.size() == 1) {
            this.actionButton.setIcon(new ImageIcon(image));
            this.actionButton.setToolTipText(tooltipText);
            this.actionButton.setActionCommand(action);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.actionButton.setEnabled(b);
        this.dropButton.setEnabled(b);
    }

    public void setEnabledAction(String action, boolean b) {
        if (this.toolTipTexts.get(action) == null) {
            return;
        }
        if (b) {
            this.disabledActions.remove(action);
        } else if (!this.disabledActions.contains(action)) {
            this.disabledActions.add(action);
        }
        this.fixGui();
    }

    private void fixGui() {
        Vector<String> vecEnable = this.getEnableActions();
        if (vecEnable.size() <= 1) {
            this.dropButton.setEnabled(false);
            this.dropButton.setVisible(false);
            this.setPreferredSize(this.actionButton.getSize());
            this.setMaximumSize(this.actionButton.getSize());
            this.setMinimumSize(this.actionButton.getSize());
        } else {
            this.dropButton.setEnabled(true);
        }
        if (vecEnable.size() >= 1) {
            String action = vecEnable.firstElement();
            String ttStr = this.toolTipTexts.get(action);
            Image image = this.images.get(action);
            this.actionButton.setIcon(new ImageIcon(image));
            this.actionButton.setToolTipText(ttStr);
            this.actionButton.setActionCommand(action);
            this.actionButton.setEnabled(true);
        } else {
            this.actionButton.setIcon(new ImageIcon(ImageUtils.getImage("images/buttons/drop.png")));
            this.actionButton.setToolTipText("No enable actions");
            this.actionButton.setActionCommand("NO_ACTION");
            this.actionButton.setEnabled(false);
        }
    }

    private Vector<String> getEnableActions() {
        Vector<String> vecEnable = new Vector<String>();
        for (String ac : this.toolTipTexts.keySet()) {
            if (this.disabledActions.contains(ac)) continue;
            vecEnable.add(ac);
        }
        return vecEnable;
    }

    public boolean isAnyActionEnable() {
        return this.getEnableActions().size() > 0;
    }

    public boolean isEnabled(String action) {
        return !this.disabledActions.contains(action);
    }

    public static void main(String[] args) {
        NeptusComboButton but = new NeptusComboButton(false);
        but.addAction("Save File", "Save file", ImageUtils.getImage("images/buttons/save.png"));
        but.addAction("grid", "Show Grid", ImageUtils.getImage("images/buttons/grid.png"));
        but.setEnabled(true);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NeptusLog.pub().info((Object)("<###>ACTION: " + e.getActionCommand()));
            }
        });
        NeptusComboButton but2 = new NeptusComboButton(true);
        but2.addAction("Save File", "Save file", ImageUtils.getImage("images/buttons/save.png"));
        but2.addAction("grid", "Show Grid", ImageUtils.getImage("images/buttons/grid.png"));
        but2.setEnabled(true);
        but2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NeptusLog.pub().info((Object)("<###>ACTION: " + e.getActionCommand()));
            }
        });
        JPanel jp = new JPanel();
        jp.add(but2);
        jp.add(but);
        GuiUtils.testFrame(jp, "test");
        but2.setEnabledAction("grid", true);
        but2.setEnabledAction("Save File", false);
    }
}

