/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;
import pt.lsts.neptus.util.ImageUtils;

public class NudgeGlassPane
extends JPanel {
    private Color backColor = new Color(255, 100, 100, 75);
    private Color foreColor = new Color(100, 25, 0);
    private static ImageIcon icon = ImageUtils.getIcon("images/critical-transparent.png");

    private NudgeGlassPane(String messageToShow) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JXLabel msgLabel = new JXLabel(messageToShow, (Icon)icon, 0);
        msgLabel.setBackgroundPainter((Painter)new PinstripePainter((Paint)new Color(100, 50, 0, 128)));
        msgLabel.setFont(new Font("Arial", 0, 20));
        msgLabel.setForeground(this.foreColor);
        msgLabel.setBackground(this.backColor);
        msgLabel.setOpaque(true);
        this.add((Component)msgLabel);
        this.setVisible(true);
    }

    public static void nudge(JRootPane rootpane, String message, int delay) {
        NudgeGlassPane nudgePane = new NudgeGlassPane(message);
        final JRootPane root = rootpane;
        root.setGlassPane(nudgePane);
        nudgePane.setVisible(true);
        nudgePane.revalidate();
        final Timer nudgeTimer = new Timer("Nudge Timer");
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            root.setGlassPane(new JRootPane().getGlassPane());
                            root.repaint();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                nudgeTimer.cancel();
            }
        };
        nudgeTimer.schedule(tt, delay * 1000);
    }
}

