/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class PasswordPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title = "Enter password";
    private String username = "root";
    private String password = "";
    private boolean savePassword = false;
    private JPasswordField passwordField = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField usernameField = null;
    private JCheckBox savePasswordCheckBox = null;
    private JButton okButton = null;
    private JPanel jContentPane = null;
    private JDialog jDialog = null;

    public PasswordPanel() {
        this.initialize();
    }

    public PasswordPanel(String title, String username, String password, boolean savePassword) {
        this.title = title;
        this.username = username;
        this.password = password;
        this.savePassword = savePassword;
        this.initialize();
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setPreferredSize(new Dimension(150, 20));
            this.passwordField.setLocation(92, 38);
            this.passwordField.setSize(150, 20);
            this.passwordField.setText(this.password);
            this.passwordField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PasswordPanel.this.okAction();
                    }
                }
            });
            this.passwordField.setSelectionStart(0);
            this.passwordField.setSelectionEnd(this.passwordField.getPassword().length);
        }
        return this.passwordField;
    }

    private JTextField getUsernameField() {
        if (this.usernameField == null) {
            this.usernameField = new JTextField();
            this.usernameField.setPreferredSize(new Dimension(150, 20));
            this.usernameField.setLocation(92, 13);
            this.usernameField.setSize(150, 20);
            this.usernameField.setEditable(false);
            this.usernameField.setText(this.username);
            this.usernameField.setSelectionStart(0);
            this.usernameField.setSelectionEnd(this.usernameField.getText().length());
        }
        return this.usernameField;
    }

    private JCheckBox getSavePasswordCheckBox() {
        if (this.savePasswordCheckBox == null) {
            this.savePasswordCheckBox = new JCheckBox();
            this.savePasswordCheckBox.setBounds(23, 61, 121, 21);
            this.savePasswordCheckBox.setSelected(this.savePassword);
            this.savePasswordCheckBox.setText("Save password");
        }
        return this.savePasswordCheckBox;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(179, 89, 79, 22);
            this.okButton.setText("Ok");
            this.okButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PasswordPanel.this.okAction();
                    }
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PasswordPanel.this.okAction();
                }
            });
        }
        return this.okButton;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setContentPane(this.getJContentPane());
            this.jDialog.setTitle(this.title);
            this.jDialog.setSize(this.getWidth() + 5, this.getHeight() + 35);
            this.jDialog.setLayout(new BorderLayout());
            this.jDialog.getContentPane().add((Component)this, "Center");
            this.jDialog.setModal(true);
            this.jDialog.setAlwaysOnTop(true);
            GuiUtils.centerOnScreen(this.jDialog);
            this.jDialog.setResizable(false);
            this.jDialog.setAlwaysOnTop(true);
            this.jDialog.setDefaultCloseOperation(0);
            this.jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JOptionPane.showMessageDialog(PasswordPanel.this.jDialog, "You must enter a password!");
                }
            });
            this.jDialog.setIconImage(ImageUtils.getImage("images/neptus-icon.png"));
            this.jDialog.toFront();
            this.jDialog.setFocusTraversalPolicy(new PasswordPanelFocusTraversalPolicy());
            this.jDialog.setVisible(true);
        }
        return this.jDialog;
    }

    private void initialize() {
        this.jLabel1 = new JLabel();
        this.jLabel = new JLabel();
        this.setLayout(null);
        this.setSize(278, 122);
        this.setPreferredSize(new Dimension(150, 20));
        this.jLabel.setText("Password");
        this.jLabel.setLocation(23, 39);
        this.jLabel.setSize(58, 16);
        this.jLabel1.setText("Username");
        this.jLabel1.setLocation(23, 15);
        this.jLabel1.setSize(59, 16);
        this.add((Component)this.getPasswordField(), null);
        this.add((Component)this.jLabel, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.getUsernameField(), null);
        this.add((Component)this.getSavePasswordCheckBox(), null);
        this.add((Component)this.getOkButton(), null);
    }

    private String getPassword() {
        return new String(this.getPasswordField().getPassword());
    }

    private boolean isPasswordSave() {
        return this.getSavePasswordCheckBox().isSelected();
    }

    public void okAction() {
        this.jDialog.setVisible(false);
        this.jDialog.dispose();
    }

    public static String[] showPasswordDialog(String title, String username, String password, boolean savePassword) {
        PasswordPanel pp = new PasswordPanel(title, username, password, savePassword);
        pp.getJDialog();
        String[] ret = new String[]{pp.getPassword(), Boolean.toString(pp.isPasswordSave())};
        return ret;
    }

    public static void main(String[] args) {
        PasswordPanel.showPasswordDialog("Enter password", "root", "djhgjg", false);
    }

    public class PasswordPanelFocusTraversalPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PasswordPanel.this.usernameField)) {
                return PasswordPanel.this.passwordField;
            }
            if (aComponent.equals(PasswordPanel.this.passwordField)) {
                return PasswordPanel.this.savePasswordCheckBox;
            }
            if (aComponent.equals(PasswordPanel.this.savePasswordCheckBox)) {
                return PasswordPanel.this.okButton;
            }
            if (aComponent.equals(PasswordPanel.this.okButton)) {
                return PasswordPanel.this.usernameField;
            }
            return PasswordPanel.this.passwordField;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PasswordPanel.this.usernameField)) {
                return PasswordPanel.this.okButton;
            }
            if (aComponent.equals(PasswordPanel.this.passwordField)) {
                return PasswordPanel.this.usernameField;
            }
            if (aComponent.equals(PasswordPanel.this.savePasswordCheckBox)) {
                return PasswordPanel.this.passwordField;
            }
            if (aComponent.equals(PasswordPanel.this.okButton)) {
                return PasswordPanel.this.savePasswordCheckBox;
            }
            return PasswordPanel.this.passwordField;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return PasswordPanel.this.passwordField;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return PasswordPanel.this.okButton;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return PasswordPanel.this.passwordField;
        }
    }
}

