/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.HeightDepthSelector;
import pt.lsts.neptus.gui.LatLongSelector;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;

public class PointSelector
extends ParametersPanel {
    private static final long serialVersionUID = 1L;
    private HeightDepthSelector heightDepthSelector = null;
    private LatLongSelector latLongSelector = null;
    private boolean editable;

    public PointSelector() {
        this.initialize();
    }

    public HeightDepthSelector getHeightDepthSelector() {
        if (this.heightDepthSelector == null) {
            this.heightDepthSelector = new HeightDepthSelector();
        }
        return this.heightDepthSelector;
    }

    public void setZSelectable(boolean zSelectable) {
        this.heightDepthSelector.setVisible(zSelectable);
    }

    public LatLongSelector getLatLongSelector() {
        if (this.latLongSelector == null) {
            this.latLongSelector = new LatLongSelector();
        }
        return this.latLongSelector;
    }

    @Override
    public String getErrors() {
        if (this.getLatLongSelector().getErrors() != null) {
            return this.getLatLongSelector().getErrors();
        }
        return this.getHeightDepthSelector().getErrors();
    }

    public LocationType getLocationType() {
        if (this.getErrors() != null) {
            return null;
        }
        LocationType location = new LocationType();
        location.setDepth(this.getHeightDepthSelector().getDepth());
        location.setLatitudeStr(this.getLatLongSelector().getLatitude());
        location.setLongitudeStr(this.getLatLongSelector().getLongitude());
        NeptusLog.pub().info((Object)("<###> " + location));
        return location;
    }

    public void setLocationType(LocationType location) {
        this.getHeightDepthSelector().setZ(location.getDepth());
        this.getLatLongSelector().setLatitude(CoordinateUtil.parseLatitudeStringToDMS(location.getLatitudeStr()));
        this.getLatLongSelector().setLongitude(CoordinateUtil.parseLongitudeStringToDMS(location.getLongitudeStr()));
        this.getLatLongSelector().setDMSStyleIndicatorTo(2);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBounds(0, 0, 420, 200);
        this.add((Component)this.getHeightDepthSelector(), "South");
        this.add((Component)this.getLatLongSelector(), "Center");
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getHeightDepthSelector().setEditable(this.editable);
        this.getLatLongSelector().setEditable(this.editable);
    }
}

