/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;

public class PolarOffsetPanel
extends ParametersPanel {
    private static final String HELP_IMAGE = "/images/neptus_NED.png";
    private JLabel jLabel = null;
    private JTextField distanceField = null;
    private JLabel jLabel1 = null;
    private JTextField azimuthField = null;
    private JLabel jLabel2 = null;
    private JTextField zenithField = null;
    private boolean editable;
    private String sphericalCSHelpImage;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;

    public PolarOffsetPanel() {
        this.initialize();
    }

    private void initialize() {
        this.sphericalCSHelpImage = PolarOffsetPanel.class.getResource(HELP_IMAGE).toString();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel = new JLabel();
        this.setSize(406, 29);
        this.jLabel.setText(I18n.text("Distance") + ":");
        this.jLabel1.setText("   " + I18n.text("Azimuth") + ":");
        this.jLabel2.setText("   " + I18n.text("Zenith") + ":");
        this.jLabel3.setText(I18n.textc("m", "meters"));
        this.jLabel4.setText("\u00b0");
        this.jLabel4.setFont(new Font("Dialog", 1, 14));
        this.jLabel5.setText("\u00b0");
        this.jLabel5.setFont(new Font("Dialog", 1, 14));
        this.add((Component)this.jLabel, null);
        this.add((Component)this.getDistanceField(), null);
        this.add((Component)this.jLabel3, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.getAzimuthField(), null);
        this.add((Component)this.jLabel4, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.getZenithField(), null);
        this.add((Component)this.jLabel5, null);
    }

    private JTextField getDistanceField() {
        if (this.distanceField == null) {
            this.distanceField = new JTextField();
            this.distanceField.setColumns(5);
            this.distanceField.setText("0");
            this.distanceField.setToolTipText("<html><img src=\"" + this.sphericalCSHelpImage + "\"></html>");
            this.distanceField.addFocusListener(new SelectAllFocusListener());
        }
        return this.distanceField;
    }

    private JTextField getAzimuthField() {
        if (this.azimuthField == null) {
            this.azimuthField = new JTextField();
            this.azimuthField.setColumns(5);
            this.azimuthField.setText("0");
            this.azimuthField.setToolTipText("<html><img src=\"" + this.sphericalCSHelpImage + "\"></html>");
            this.azimuthField.addFocusListener(new SelectAllFocusListener());
        }
        return this.azimuthField;
    }

    private JTextField getZenithField() {
        if (this.zenithField == null) {
            this.zenithField = new JTextField();
            this.zenithField.setColumns(5);
            this.zenithField.setText("0");
            this.zenithField.setToolTipText("<html><img src=\"" + this.sphericalCSHelpImage + "\"></html>");
            this.zenithField.addFocusListener(new SelectAllFocusListener());
        }
        return this.zenithField;
    }

    @Override
    public String getErrors() {
        try {
            Double.parseDouble(this.getZenithField().getText());
            Double.parseDouble(this.getAzimuthField().getText());
            Double.parseDouble(this.getDistanceField().getText());
        }
        catch (Exception e) {
            return I18n.text("The text entered does not represent valid numbers");
        }
        return null;
    }

    public double getAzimuthOffset() {
        return Double.parseDouble(this.getAzimuthField().getText());
    }

    public double getZenithOffset() {
        return Double.parseDouble(this.getZenithField().getText());
    }

    public double getDistanceOffset() {
        return Double.parseDouble(this.getDistanceField().getText());
    }

    public void setAzimuth(double value) {
        this.getAzimuthField().setText(String.valueOf(value));
    }

    public void setZenith(double value) {
        this.getZenithField().setText(String.valueOf(value));
    }

    public void setDistance(double value) {
        this.getDistanceField().setText(String.valueOf(value));
    }

    public void setLocationType(LocationType location) {
        this.setDistance(location.getOffsetDistance());
        this.setZenith(location.getZenith());
        this.setAzimuth(location.getAzimuth());
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getDistanceField().setEditable(this.editable);
        this.getAzimuthField().setEditable(this.editable);
        this.getZenithField().setEditable(this.editable);
    }
}

