/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.renderer3d.Renderer3D;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.CylinderElement;
import pt.lsts.neptus.types.map.EllipsoidElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.util.GuiUtils;

public class Properties3D
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private Renderer3D renderer = null;
    private AbstractElement obj = null;
    private JLabel jLabel2 = null;
    private JTextArea jTextArea = null;
    private JButton okBtn = null;
    private JButton cancelBtn = null;
    private JCheckBox checktrans = null;
    private JCheckBox checkaxis = null;
    private JCheckBox checkhide = null;
    private JCheckBox checklabel = null;
    private JCheckBox checkinfo = null;
    private JCheckBox checkfocus = null;
    private JButton buttonfocus = null;
    JScrollPane scroll = null;
    private JButton jButton = null;

    public void setRenderer3D(Renderer3D r3d) {
        this.renderer = r3d;
    }

    public void setMapObject(AbstractElement mobj) {
        this.obj = mobj;
        this.jLabel2.setText("Map Object " + this.obj.getId());
        this.checktrans.setSelected(this.renderer.isTrans(this.obj));
        if (!(this.obj instanceof EllipsoidElement || this.obj instanceof CylinderElement || this.obj instanceof ParallelepipedElement || this.obj instanceof ImageElement)) {
            this.checktrans.setEnabled(false);
        }
        this.checkaxis.setSelected(this.renderer.objects.get((Object)this.obj).drawaxis);
        this.checkinfo.setSelected(this.renderer.objects.get((Object)this.obj).drawinfo);
        this.checklabel.setSelected(this.renderer.objects.get((Object)this.obj).drawlabel);
        this.checkhide.setSelected(this.renderer.objects.get((Object)this.obj).hide);
        if (this.renderer.objects.get((Object)this.obj).hide) {
            this.checkfocus.setEnabled(false);
        }
        if (this.renderer.cams[this.renderer.panel_op].lockmapobj == this.obj) {
            this.checkfocus.setSelected(true);
        }
        this.jTextArea.setText("Name:" + this.obj.getId() + "\nId:" + this.obj.getId() + "\nPosition:\nN:" + this.obj.getNEDPosition()[0] + "\nE:" + this.obj.getNEDPosition()[1] + "\nD:" + this.obj.getNEDPosition()[2]);
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setSize(303, 309);
        this.setResizable(false);
        this.setTitle("Object Render3D");
    }

    public Properties3D(Frame parent) {
        super(parent);
        this.initialize();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel2 = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jLabel2.setBounds(10, 10, 265, 20);
            this.jPanel.add((Component)this.getOkBtn(), null);
            this.jPanel.add((Component)this.getCancelBtn(), null);
            this.jPanel.add((Component)this.getCheckTrans(), null);
            this.jPanel.add((Component)this.getCheckHide(), null);
            this.jPanel.add((Component)this.getCheckAxis(), null);
            this.jPanel.add((Component)this.getCheckLabel(), null);
            this.jPanel.add((Component)this.getCheckInfo(), null);
            this.jPanel.add((Component)this.getCheckFocus(), null);
            this.jPanel.add((Component)this.getJTextArea(), null);
            this.jPanel.add((Component)this.getFocusBtn(), null);
            this.jPanel.add((Component)this.jLabel2, null);
            this.jPanel.add((Component)this.getJButton(), null);
        }
        return this.jPanel;
    }

    private JCheckBox getCheckTrans() {
        if (this.checktrans == null) {
            this.checktrans = new JCheckBox();
            this.checktrans.setText("Tranparency");
            this.checktrans.setBounds(97, 74, 108, 20);
        }
        return this.checktrans;
    }

    private JCheckBox getCheckHide() {
        if (this.checkhide == null) {
            this.checkhide = new JCheckBox();
            this.checkhide.setText("Hide");
            this.checkhide.setBounds(8, 53, 55, 20);
        }
        return this.checkhide;
    }

    private JCheckBox getCheckAxis() {
        if (this.checkaxis == null) {
            this.checkaxis = new JCheckBox();
            this.checkaxis.setText("Show Axis");
            this.checkaxis.setBounds(8, 34, 80, 20);
        }
        return this.checkaxis;
    }

    private JCheckBox getCheckLabel() {
        if (this.checklabel == null) {
            this.checklabel = new JCheckBox();
            this.checklabel.setText("Labeling");
            this.checklabel.setBounds(97, 34, 90, 20);
        }
        return this.checklabel;
    }

    private JCheckBox getCheckInfo() {
        if (this.checkinfo == null) {
            this.checkinfo = new JCheckBox();
            this.checkinfo.setText("Show Info");
            this.checkinfo.setBounds(8, 73, 80, 20);
        }
        return this.checkinfo;
    }

    private JCheckBox getCheckFocus() {
        if (this.checkfocus == null) {
            this.checkfocus = new JCheckBox();
            this.checkfocus.setText("Lock view on");
            this.checkfocus.setBounds(97, 55, 105, 20);
        }
        return this.checkfocus;
    }

    private JScrollPane getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setAutoscrolls(true);
            this.jTextArea.setEditable(false);
            this.jTextArea.setBackground(new Color(225, 225, 225));
            this.scroll = new JScrollPane(this.jTextArea);
            this.scroll.setName("Information");
            this.scroll.setBorder(BorderFactory.createTitledBorder(null, "Information", 0, 0, null, null));
            this.scroll.setBounds(10, 110, 272, 103);
        }
        return this.scroll;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null) {
            this.cancelBtn = new JButton();
            this.cancelBtn.setBounds(115, 225, 70, 30);
            this.cancelBtn.setText("Cancel");
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties3D.this.setVisible(false);
                    Properties3D.this.dispose();
                }
            });
        }
        return this.cancelBtn;
    }

    private void setRenderer() {
        if (this.checktrans.isSelected()) {
            this.renderer.setTrans(this.obj);
        } else {
            this.renderer.setNoTrans(this.obj);
        }
        if (this.checkaxis.isSelected()) {
            this.renderer.objects.get(this.obj).DrawAxis(true);
        } else {
            this.renderer.objects.get(this.obj).DrawAxis(false);
        }
        this.renderer.objects.get((Object)this.obj).drawlabel = this.checklabel.isSelected();
        this.renderer.objects.get((Object)this.obj).drawinfo = this.checkinfo.isSelected();
        if (this.checkhide.isSelected()) {
            this.renderer.hide(this.obj);
        } else {
            this.renderer.unHide(this.obj);
        }
        if (this.renderer.cams[this.renderer.panel_op].lockmapobj == this.obj) {
            if (!this.checkfocus.isSelected()) {
                this.renderer.lockView(this.renderer.panel_op, null);
            }
        } else if (this.checkfocus.isSelected()) {
            this.renderer.lockView(this.renderer.panel_op, this.renderer.objects.get(this.obj));
        }
    }

    private JButton getOkBtn() {
        if (this.okBtn == null) {
            this.okBtn = new JButton();
            this.okBtn.setBounds(30, 225, 70, 30);
            this.okBtn.setText("OK");
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties3D.this.setRenderer();
                    Properties3D.this.setVisible(false);
                    Properties3D.this.dispose();
                }
            });
        }
        return this.okBtn;
    }

    private JButton getFocusBtn() {
        if (this.buttonfocus == null) {
            this.buttonfocus = new JButton();
            this.buttonfocus.setBounds(208, 38, 70, 55);
            this.buttonfocus.setText("Focus");
            this.buttonfocus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties3D.this.renderer.focusLocation(Properties3D.this.obj.getCenterLocation());
                }
            });
        }
        return this.buttonfocus;
    }

    public static void showPropreties3DDialog(Renderer3D r3d, AbstractElement mobj) {
        Frame parentFrame = (Frame)SwingUtilities.getRoot(r3d);
        Properties3D p3d = new Properties3D(parentFrame);
        p3d.setRenderer3D(r3d);
        p3d.setVisible(true);
        p3d.setModal(true);
        p3d.setMapObject(mobj);
        GuiUtils.centerOnScreen(p3d);
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setBounds(new Rectangle(200, 225, 70, 30));
            this.jButton.setText("Apply");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties3D.this.setRenderer();
                }
            });
        }
        return this.jButton;
    }
}

