/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetDialog;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.BannerPanel;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.BitmaskPropertyEditor;
import pt.lsts.neptus.gui.editor.ColorMapPropertyEditor;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.gui.editor.EnumeratedPropertyEditor;
import pt.lsts.neptus.gui.editor.ImcId16Editor;
import pt.lsts.neptus.gui.editor.LocationTypePropertyEditor;
import pt.lsts.neptus.gui.editor.NeptusDoubleEditor;
import pt.lsts.neptus.gui.editor.PlanActionsEditor;
import pt.lsts.neptus.gui.editor.RenderSelectionEditor;
import pt.lsts.neptus.gui.editor.RenderType;
import pt.lsts.neptus.gui.editor.Script;
import pt.lsts.neptus.gui.editor.ScriptSelectionEditor;
import pt.lsts.neptus.gui.editor.VehicleSelectionEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.Bitmask;
import pt.lsts.neptus.messages.Enumerated;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.ManeuverLocationEditor;
import pt.lsts.neptus.mp.actions.PlanActions;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class PropertiesEditor {
    static PropertyEditorRegistry per = null;
    static PropertyRendererRegistry prr = null;

    public static boolean editProperties(PropertiesProvider provider, boolean editable) {
        return PropertiesEditor.editPropertiesWorker(provider, null, editable);
    }

    public static boolean editProperties(PropertiesProvider provider, Dialog parent, boolean editable) {
        return PropertiesEditor.editPropertiesWorker(provider, parent, editable);
    }

    public static boolean editProperties(PropertiesProvider provider, Frame parent, boolean editable) {
        return PropertiesEditor.editPropertiesWorker(provider, parent, editable);
    }

    public static boolean editProperties(PropertiesProvider provider, Window parent, boolean editable) {
        return PropertiesEditor.editPropertiesWorker(provider, parent, editable);
    }

    public static boolean createAggregatedPropertiesDialog(ConsoleLayout console, boolean editable) {
        PropertySheetPanel psp = new PropertySheetPanel();
        psp.setEditorFactory((PropertyEditorFactory)PropertiesEditor.getPropertyEditorRegistry());
        psp.setRendererFactory((PropertyRendererFactory)PropertiesEditor.getPropertyRendererRegistry());
        psp.setMode(1);
        psp.setSortingCategories(true);
        psp.setDescriptionVisible(true);
        psp.setToolBarVisible(false);
        return true;
    }

    protected static String normalize(String text) {
        text = text.toUpperCase();
        text = text.replaceAll("[^\\w]", "_");
        return text;
    }

    public static void localizeProperties(Collection<DefaultProperty> original, Vector<DefaultProperty> result) {
        result.clear();
        for (DefaultProperty dp : original) {
            dp.setName(dp.getName());
            dp.setDisplayName(I18n.text(dp.getDisplayName()));
            if (dp.getCategory() != null) {
                dp.setCategory(I18n.text(dp.getCategory()));
            }
            if (dp.getShortDescription() != null) {
                dp.setShortDescription(I18n.text(dp.getShortDescription()));
            }
            result.add(dp);
        }
    }

    private static boolean editPropertiesWorker(PropertiesProvider provider, Window parent, boolean editable) {
        boolean canceled = false;
        PropertySheetPanel psp = new PropertySheetPanel();
        psp.setEditorFactory((PropertyEditorFactory)PropertiesEditor.getPropertyEditorRegistry());
        psp.setRendererFactory((PropertyRendererFactory)PropertiesEditor.getPropertyRendererRegistry());
        psp.setMode(1);
        psp.setToolBarVisible(false);
        psp.setSortingCategories(true);
        psp.setCategorySortingComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String advancedI18nText = I18n.textc("Advance", "Properties category dubbed Advance, normally category is \"Advance\" or STARTS WITH \"Advance - \"");
                if (o1.startsWith("Advance") || o2.startsWith("Advance")) {
                    if (o1.startsWith("Advance") && o2.startsWith("Advance")) {
                        return o1.compareTo(o2);
                    }
                    if (!o1.equalsIgnoreCase(o2)) {
                        return o1.startsWith("Advance") ? 1 : -1;
                    }
                    return o1.compareTo(o2);
                }
                if (o1.startsWith(advancedI18nText) || o2.startsWith(advancedI18nText)) {
                    if (o1.startsWith(advancedI18nText) && o2.startsWith(advancedI18nText)) {
                        return o1.compareTo(o2);
                    }
                    if (!o1.equalsIgnoreCase(o2)) {
                        return o1.startsWith(advancedI18nText) ? 1 : -1;
                    }
                    return o1.compareTo(o2);
                }
                return o1.compareTo(o2);
            }
        });
        psp.setDescriptionVisible(true);
        DefaultProperty[] properties = provider.getProperties();
        Vector<DefaultProperty> result = new Vector<DefaultProperty>();
        PropertiesEditor.localizeProperties(Arrays.asList(properties), result);
        DefaultProperty[] propertiesLocalized = result.toArray(new DefaultProperty[0]);
        if (!editable) {
            for (DefaultProperty p : propertiesLocalized) {
                p.setEditable(false);
            }
        }
        if (propertiesLocalized != null) {
            for (int i = 0; i < propertiesLocalized.length; ++i) {
                psp.addProperty((Property)propertiesLocalized[i]);
            }
        }
        PropertySheetDialog propertySheetDialog = PropertiesEditor.createWindow(parent, editable, psp, provider.getPropertiesDialogTitle());
        LinkedHashMap<String, DefaultProperty> original = PropertiesEditor.createHashMap(properties);
        boolean end = false;
        while (!end) {
            if (!propertySheetDialog.ask()) {
                end = true;
                canceled = true;
                break;
            }
            Property[] newProps = psp.getProperties();
            DefaultProperty[] propsUnlocalized = PropertiesEditor.unlocalizeProps(original, newProps);
            String[] errors = provider.getPropertiesErrors((Property[])propsUnlocalized);
            if (errors != null && errors.length > 0) {
                PropertiesEditor.printErrors(parent, errors);
                continue;
            }
            end = true;
            provider.setProperties((Property[])propsUnlocalized);
        }
        return canceled;
    }

    public static PropertySheetDialog createWindow(Window parent, boolean editable, PropertySheetPanel psp, String title) {
        return PropertiesEditor.createWindow(parent, editable, psp, title, title);
    }

    public static PropertySheetDialog createWindow(Window parent, boolean editable, final PropertySheetPanel psp, String title, String bannerTitle) {
        PropertySheetDialog propertySheetDialog;
        if (parent instanceof Dialog) {
            Dialog pDialog = (Dialog)parent;
            propertySheetDialog = new PropertySheetDialog(pDialog);
        } else if (parent instanceof Frame) {
            Frame pFrame = (Frame)parent;
            propertySheetDialog = new PropertySheetDialog(pFrame);
        } else {
            propertySheetDialog = new PropertySheetDialog(){
                private static final long serialVersionUID = 1L;

                public void ok() {
                    if (psp.getTable().getEditorComponent() != null) {
                        psp.getTable().commitEditing();
                    }
                    super.ok();
                }
            };
        }
        if (editable) {
            propertySheetDialog.setDialogMode(0);
        } else {
            propertySheetDialog.setDialogMode(1);
        }
        int sb = 1;
        for (Component compL0 : propertySheetDialog.getRootPane().getComponents()) {
            if (!(compL0 instanceof JLayeredPane)) continue;
            for (Component compL01 : ((JLayeredPane)compL0).getComponents()) {
                if (!(compL01 instanceof JPanel)) continue;
                block2: for (Component compL1 : ((JPanel)compL01).getComponents()) {
                    if (compL1 instanceof BannerPanel || !(compL1 instanceof JPanel)) continue;
                    for (Component compL2 : ((JPanel)compL1).getComponents()) {
                        for (Component compL3 : ((JPanel)compL2).getComponents()) {
                            if (!(compL3 instanceof JButton)) continue;
                            if (propertySheetDialog.getDialogMode() == 0 && sb == 1) {
                                ((JButton)compL3).setText(I18n.text("OK"));
                                --sb;
                            } else if (propertySheetDialog.getDialogMode() == 1 || sb == 0) {
                                ((JButton)compL3).setText(propertySheetDialog.getDialogMode() == 1 ? I18n.text("Close") : I18n.text("Cancel"));
                                --sb;
                                break;
                            }
                            if (sb < 0) break;
                        }
                        if (sb < 0) continue block2;
                    }
                }
            }
        }
        propertySheetDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window ownerWindow = propertySheetDialog.getOwner();
                if (ownerWindow != null) {
                    ConfigFetch.setSuperParentFrameForced(ownerWindow);
                }
            }
        });
        if (title != null) {
            propertySheetDialog.setTitle(I18n.text(title));
            propertySheetDialog.getBanner().setTitle(I18n.text(bannerTitle == null || bannerTitle.length() == 0 ? title : bannerTitle));
        }
        propertySheetDialog.setIconImage(ImageUtils.getImage("images/menus/settings.png"));
        propertySheetDialog.getBanner().setIcon((Icon)ImageUtils.getIcon("images/settings.png"));
        propertySheetDialog.getContentPane().add((Component)psp);
        propertySheetDialog.pack();
        GuiUtils.centerOnScreen((Window)propertySheetDialog);
        propertySheetDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        return propertySheetDialog;
    }

    public static LinkedHashMap<String, DefaultProperty> createHashMap(DefaultProperty[] properties) {
        LinkedHashMap<String, DefaultProperty> original = new LinkedHashMap<String, DefaultProperty>();
        for (DefaultProperty p : properties) {
            original.put(p.getName(), p);
        }
        return original;
    }

    private static void printErrors(Window parent, String[] errors) {
        boolean hasParentWindow = parent instanceof Dialog || parent instanceof Frame;
        String errorsString = "<html>" + I18n.text("The following errors were found") + ":<br>";
        int i = 1;
        for (String error : errors) {
            errorsString = errorsString + "<br> &nbsp;" + i++ + ") " + error;
        }
        errorsString = errorsString + "</html>";
        GuiUtils.errorMessage(hasParentWindow ? parent : ConfigFetch.getSuperParentFrame(), I18n.text("Invalid properties"), errorsString);
    }

    public static DefaultProperty[] unlocalizeProps(LinkedHashMap<String, DefaultProperty> original, Property[] newProps) {
        DefaultProperty[] propsUnlocalized = new DefaultProperty[newProps.length];
        for (int i = 0; i < newProps.length; ++i) {
            propsUnlocalized[i] = new DefaultProperty();
            String name = newProps[i].getName();
            DefaultProperty orig = original.get(name);
            propsUnlocalized[i].setName(name);
            propsUnlocalized[i].setDisplayName(orig.getDisplayName());
            propsUnlocalized[i].setShortDescription(orig.getShortDescription());
            propsUnlocalized[i].setCategory(orig.getCategory());
            propsUnlocalized[i].setType(orig.getType());
            propsUnlocalized[i].setValue(newProps[i].getValue());
            propsUnlocalized[i].setParentProperty(orig.getParentProperty());
        }
        return propsUnlocalized;
    }

    public static DefaultProperty getPropertyInstance(String propertyName, Class<?> propertyClass, Object value, boolean isEditable) {
        DefaultProperty property = new DefaultProperty();
        property.setName(propertyName);
        property.setDisplayName(I18n.text(propertyName));
        property.setType(propertyClass);
        property.setValue(value);
        property.setEditable(isEditable);
        return property;
    }

    public static DefaultProperty getPropertyInstance(String propertyName, String categoryName, Class<?> propertyClass, Object value, boolean isEditable, String shortDescription) {
        DefaultProperty property = PropertiesEditor.getPropertyInstance(propertyName, categoryName, propertyClass, value, isEditable);
        property.setShortDescription(shortDescription);
        if (propertyClass.isEnum()) {
            PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)property, new ComboEditor(propertyClass.getEnumConstants()));
        }
        return property;
    }

    public static Property[] mergeProperties(PropertiesProvider[] childProviders, Property[] properties) {
        Vector<Object> vec = new Vector<Object>();
        for (Property property : properties) {
            vec.add(property);
        }
        for (PropertiesProvider propertiesProvider : childProviders) {
            for (DefaultProperty property : propertiesProvider.getProperties()) {
                DefaultProperty prop = new DefaultProperty();
                prop.setCategory(propertiesProvider.getPropertiesDialogTitle());
                prop.setDisplayName(property.getDisplayName());
                prop.setName(property.getName());
                prop.setEditable(property.isEditable());
                prop.setType(property.getType());
                prop.setValue(property.getValue());
                vec.add(prop);
            }
        }
        return vec.toArray(new Property[vec.size()]);
    }

    public static DefaultProperty getPropertyInstance(String propertyName, String categoryName, Class<?> propertyClass, Object value, boolean isEditable) {
        DefaultProperty dp = PropertiesEditor.getPropertyInstance(propertyName, propertyClass, value, isEditable);
        dp.setCategory(categoryName);
        return dp;
    }

    public static PropertyEditorRegistry getPropertyEditorRegistry() {
        if (per == null) {
            per = new PropertyEditorRegistry();
            per.registerDefaults();
            per.registerEditor(LocationType.class, LocationTypePropertyEditor.class);
            per.registerEditor(VehicleType.class, VehicleSelectionEditor.class);
            per.registerEditor(Script.class, ScriptSelectionEditor.class);
            per.registerEditor(RenderType.class, RenderSelectionEditor.class);
            per.registerEditor(Enumerated.class, EnumeratedPropertyEditor.class);
            per.registerEditor(Bitmask.class, BitmaskPropertyEditor.class);
            per.registerEditor(ColorMap.class, ColorMapPropertyEditor.class);
            per.registerEditor(ImcId16.class, ImcId16Editor.class);
            per.registerEditor(PlanActions.class, PlanActionsEditor.class);
            per.registerEditor(Double.class, NeptusDoubleEditor.class);
            per.registerEditor(Float.class, NeptusDoubleEditor.class);
            per.registerEditor(ManeuverLocation.class, ManeuverLocationEditor.class);
        }
        return per;
    }

    public static PropertyRendererRegistry getPropertyRendererRegistry() {
        if (prr == null) {
            prr = new PropertyRendererRegistry();
            prr.registerDefaults();
            prr.registerRenderer(ImcId16.class, (TableCellRenderer)new DefaultCellRenderer(){
                {
                    this.setShowOddAndEvenRows(false);
                }

                protected String convertToString(Object value) {
                    try {
                        ImcId16 id = (ImcId16)value;
                        return id.toPrettyString();
                    }
                    catch (Exception e) {
                        return super.convertToString(value);
                    }
                }
            });
            prr.registerRenderer(LocationType.class, (TableCellRenderer)new DefaultCellRenderer(){
                private String toolTip;
                {
                    this.setShowOddAndEvenRows(false);
                    this.toolTip = "";
                }

                protected String convertToString(Object value) {
                    try {
                        LocationType loc = (LocationType)value;
                        this.toolTip = loc.toString();
                        this.setToolTipText(this.toolTip);
                        return loc.toString();
                    }
                    catch (Exception e) {
                        return super.convertToString(value);
                    }
                }
            });
            prr.registerRenderer(Double.class, (TableCellRenderer)new DefaultCellRenderer(){
                protected DecimalFormat format;
                {
                    this.setOpaque(false);
                    this.format = new DecimalFormat("0.0######");
                }

                protected String convertToString(Object value) {
                    return this.format.format(value);
                }
            });
            prr.registerRenderer(Enum.class, (TableCellRenderer)new DefaultCellRenderer(){
                {
                    this.setOpaque(false);
                }

                protected String convertToString(Object value) {
                    return I18n.text(value.toString());
                }
            });
            prr.registerRenderer(String[].class, (TableCellRenderer)new DefaultCellRenderer(){
                {
                    this.setOpaque(false);
                }

                protected String convertToString(Object value) {
                    return I18n.text(Arrays.toString((String[])value).toString());
                }
            });
        }
        return prr;
    }

    public static DefaultProperty getPropertyInstance(Property p) {
        return PropertiesEditor.getPropertyInstance(p.getName(), p.getClass(), p.getValue(), p.isEditable());
    }

    public static AbstractPropertyEditor getComboBoxPropertyEditor(String[] options, String value) {
        ComboBoxPropertyEditor editor = new ComboBoxPropertyEditor();
        editor.setAvailableValues((Object[])options);
        editor.setValue((Object)value);
        return editor;
    }
}

