/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class PropertiesTable
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    PropertySheetPanel psp = new PropertySheetPanel();
    PropertiesProvider pp = null;
    JLabel title = new JLabel("");
    private final Vector<PropertyChangeListener> propertyListeners = new Vector();

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.psp.setEnabled(enabled);
        this.psp.getTable().setEnabled(enabled);
    }

    public PropertiesTable() {
        this.setLayout(new BorderLayout());
        this.psp.setBorder(BorderFactory.createEmptyBorder());
        this.psp.remove(0);
        this.psp.addPropertySheetChangeListener((PropertyChangeListener)this);
        this.psp.setDescriptionVisible(true);
        this.psp.setMode(1);
        this.editProperties(null);
        this.add((Component)this.psp);
        this.add((Component)this.title, "North");
    }

    public void setDescriptionVisible(boolean isDescriptionVisible) {
        this.psp.setDescriptionVisible(isDescriptionVisible);
    }

    public void update() {
        if (this.pp == null) {
            return;
        }
        this.title.setText(this.pp.getPropertiesDialogTitle());
        try {
            this.psp.setProperties((Property[])this.pp.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editProperties(PropertiesProvider pp) {
        if (pp != null) {
            this.psp.setEditorRegistry(PropertiesEditor.getPropertyEditorRegistry());
            this.psp.setProperties((Property[])pp.getProperties());
            this.title.setText(pp.getPropertiesDialogTitle());
        } else {
            this.psp.setProperties(new Property[0]);
            this.title.setText("");
        }
        this.psp.setEnabled(this.isEnabled());
        this.pp = pp;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.pp != null) {
            this.pp.setProperties(this.psp.getProperties());
        }
        for (PropertyChangeListener pcl : this.propertyListeners) {
            pcl.propertyChange(evt);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    public static void main(String[] args) {
        PropertiesTable pt = new PropertiesTable();
        pt.editProperties(new GeneralPreferences());
        GuiUtils.testFrame(pt, "properties table");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }
}

