/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;

public class RegularOffset
extends ParametersPanel {
    private static final long serialVersionUID = 1L;
    private static final String NORTH = I18n.text("North");
    private static final String SOUTH = I18n.text("South");
    private static final String EAST = I18n.text("East");
    private static final String WEST = I18n.text("West");
    private static final String UP = I18n.text("Up");
    private static final String DOWN = I18n.text("Down");
    private JTextField offsetNS = null;
    private JTextField offsetEW = null;
    private JComboBox<?> selectorNS = null;
    private JComboBox<?> selectorEW = null;
    private JComboBox<?> selectorUD = null;
    private JTextField offsetUD = null;
    private boolean editable;

    public RegularOffset() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout());
        this.setSize(416, 30);
        this.add(this.getSelectorNS(), null);
        this.add((Component)this.getOffsetNS(), null);
        this.add(this.getSelectorEW(), null);
        this.add((Component)this.getOffsetEW(), null);
        this.add(this.getSelectorUD(), null);
        this.add((Component)this.getOffsetUD(), null);
    }

    @Override
    public String getErrors() {
        try {
            Double.parseDouble(this.getOffsetNS().getText());
            Double.parseDouble(this.getOffsetEW().getText());
            Double.parseDouble(this.getOffsetUD().getText());
        }
        catch (Exception e) {
            return I18n.text("The entered text does not represent numeric values");
        }
        return null;
    }

    private JTextField getOffsetNS() {
        if (this.offsetNS == null) {
            this.offsetNS = new JTextField();
            this.offsetNS.setColumns(5);
            this.offsetNS.setText("0");
            this.offsetNS.setToolTipText("(m)");
            this.offsetNS.addFocusListener(new SelectAllFocusListener());
        }
        return this.offsetNS;
    }

    public char[] getSelectedOrientations() {
        char[] orientations = new char[]{this.selectorNS.getSelectedItem().equals(NORTH) ? (char)'N' : 'S', this.selectorEW.getSelectedItem().equals(EAST) ? (char)'E' : 'W', this.selectorUD.getSelectedItem().equals(UP) ? (char)'U' : 'D'};
        return orientations;
    }

    public double getDownOffset() {
        char[] orientations = this.getSelectedOrientations();
        if (orientations[2] == 'U') {
            return -Double.parseDouble(this.getOffsetUD().getText());
        }
        return Double.parseDouble(this.getOffsetUD().getText());
    }

    public double getNorthOffset() {
        char[] orientations = this.getSelectedOrientations();
        if (orientations[0] == 'N') {
            return Double.parseDouble(this.getOffsetNS().getText());
        }
        return -Double.parseDouble(this.getOffsetNS().getText());
    }

    public double getEastOffset() {
        char[] orientations = this.getSelectedOrientations();
        if (orientations[1] == 'E') {
            return Double.parseDouble(this.getOffsetEW().getText());
        }
        return -Double.parseDouble(this.getOffsetEW().getText());
    }

    private JTextField getOffsetEW() {
        if (this.offsetEW == null) {
            this.offsetEW = new JTextField();
            this.offsetEW.setColumns(5);
            this.offsetEW.setText("0");
            this.offsetEW.setToolTipText("(m)");
            this.offsetEW.addFocusListener(new SelectAllFocusListener());
        }
        return this.offsetEW;
    }

    private JComboBox<?> getSelectorNS() {
        if (this.selectorNS == null) {
            this.selectorNS = new JComboBox<Object>(new Object[]{NORTH, SOUTH});
            this.selectorNS.setPreferredSize(new Dimension(64, 20));
        }
        return this.selectorNS;
    }

    private JComboBox<?> getSelectorEW() {
        if (this.selectorEW == null) {
            this.selectorEW = new JComboBox<Object>(new Object[]{EAST, WEST});
            this.selectorEW.setPreferredSize(new Dimension(58, 20));
        }
        return this.selectorEW;
    }

    private JComboBox<?> getSelectorUD() {
        if (this.selectorUD == null) {
            this.selectorUD = new JComboBox<Object>(new Object[]{DOWN, UP});
            this.selectorUD.setPreferredSize(new Dimension(69, 20));
        }
        return this.selectorUD;
    }

    public void setNSOffset(double value, boolean isNorthSelected) {
        String selected = NORTH;
        if (!isNorthSelected) {
            selected = SOUTH;
            if ((value = -value) == 0.0) {
                value = 0.0;
            }
        }
        this.getOffsetNS().setText(String.valueOf(value));
        this.getSelectorNS().setSelectedItem(selected);
    }

    public void setEWOffset(double value, boolean isEastSelected) {
        String selected = EAST;
        if (!isEastSelected) {
            selected = WEST;
            if ((value = -value) == 0.0) {
                value = 0.0;
            }
        }
        this.getOffsetEW().setText(String.valueOf(value));
        this.getSelectorEW().setSelectedItem(selected);
    }

    public void setUDOffset(double value, boolean isUpSelected) {
        String selected = UP;
        if ((value = -value) == 0.0) {
            value = 0.0;
        }
        if (!isUpSelected) {
            selected = DOWN;
            if ((value = -value) == 0.0) {
                value = 0.0;
            }
        }
        this.getOffsetUD().setText(String.valueOf(value));
        this.getSelectorUD().setSelectedItem(selected);
    }

    public void setLocationType(LocationType location) {
        this.setUDOffset(location.getOffsetDown(), location.isOffsetUpUsed());
        this.setEWOffset(location.getOffsetEast(), location.isOffsetEastUsed());
        this.setNSOffset(location.getOffsetNorth(), location.isOffsetNorthUsed());
    }

    private JTextField getOffsetUD() {
        if (this.offsetUD == null) {
            this.offsetUD = new JTextField();
            this.offsetUD.setColumns(5);
            this.offsetUD.setText("0");
            this.offsetUD.setToolTipText("(m)");
            this.offsetUD.addFocusListener(new SelectAllFocusListener());
        }
        return this.offsetUD;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getSelectorNS().setEnabled(this.editable);
        this.getSelectorEW().setEnabled(this.editable);
        this.getSelectorUD().setEnabled(this.editable);
        this.getOffsetNS().setEditable(this.editable);
        this.getOffsetEW().setEditable(this.editable);
        this.getOffsetUD().setEditable(this.editable);
    }
}

