/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PointSelector;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class SimpleLocationPanel
extends JPanel {
    protected JDialog dialog = new JDialog();
    protected LocationType location = new LocationType();
    protected PointSelector selector = new PointSelector();
    protected boolean userCancel = false;

    protected JPanel getButtonsPanel() {
        JButton okButton = new JButton(I18n.text("OK"));
        JButton cancelButton = new JButton(I18n.text("Cancel"));
        okButton.setPreferredSize(new Dimension(80, 25));
        cancelButton.setPreferredSize(new Dimension(80, 25));
        JPanel tmp = new JPanel(new FlowLayout(2));
        tmp.add(okButton);
        tmp.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleLocationPanel.this.getErrors() != null) {
                    GuiUtils.errorMessage(SimpleLocationPanel.this, I18n.text("Invalid input"), SimpleLocationPanel.this.getErrors());
                    return;
                }
                SimpleLocationPanel.this.dialog.setVisible(false);
                SimpleLocationPanel.this.dialog.dispose();
                SimpleLocationPanel.this.location = SimpleLocationPanel.this.selector.getLocationType();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLocationPanel.this.dialog.setVisible(false);
                SimpleLocationPanel.this.dialog.dispose();
                SimpleLocationPanel.this.location = null;
                SimpleLocationPanel.this.setUserCancel(true);
            }
        });
        return tmp;
    }

    public SimpleLocationPanel(LocationType lt) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.selector, "Center");
        this.add((Component)this.getButtonsPanel(), "South");
        this.setLocation(lt);
    }

    public void setLocation(LocationType location) {
        this.location.setLocation(location);
        this.location.convertToAbsoluteLatLonDepth();
        this.selector.setLocationType(this.location);
    }

    public static LocationType showHorizontalLocationDialog(LocationType previousLocation, String title, boolean editable, Component parentComponent) {
        LocationType location = new LocationType();
        location.setLocation(previousLocation.convertToAbsoluteLatLonDepth());
        SimpleLocationPanel locPanel = new SimpleLocationPanel(location);
        locPanel.selector.setZSelectable(false);
        locPanel.getLocationDialog(title, parentComponent);
        if (locPanel.isUserCancel()) {
            return null;
        }
        return locPanel.getLocationType();
    }

    public static LocationType showLocationDialog(LocationType previousLocation, String title, boolean editable, Component parentComponent) {
        LocationType location = new LocationType();
        location.setLocation(previousLocation.convertToAbsoluteLatLonDepth());
        SimpleLocationPanel locPanel = new SimpleLocationPanel(location);
        locPanel.getLocationDialog(title, parentComponent);
        if (locPanel.isUserCancel()) {
            return null;
        }
        return locPanel.getLocationType();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(410, 250);
    }

    protected JDialog getLocationDialog(String title, Component parentComponent) {
        Window window = parentComponent == null ? null : SwingUtilities.windowForComponent(parentComponent);
        this.dialog = new JDialog(window);
        this.dialog.setTitle(title);
        this.dialog.setSize(this.getPreferredSize());
        this.dialog.setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SimpleLocationPanel.this.location = null;
                SimpleLocationPanel.this.setUserCancel(true);
                SimpleLocationPanel.this.dialog.setVisible(false);
                SimpleLocationPanel.this.dialog.dispose();
            }
        });
        this.dialog.setAlwaysOnTop(true);
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setModalityType(window != null ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setVisible(true);
        return this.dialog;
    }

    public boolean isUserCancel() {
        return this.userCancel;
    }

    public void setUserCancel(boolean userCancel) {
        this.userCancel = userCancel;
    }

    public LocationType getLocationType() {
        if (this.isUserCancel()) {
            return null;
        }
        return this.selector.getLocationType();
    }

    protected String getErrors() {
        return this.selector.getErrors();
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        LocationType lt = new LocationType();
        lt = SimpleLocationPanel.showHorizontalLocationDialog(lt, "Testing LocationDialog", true, null);
        NeptusLog.pub().info((Object)("<###> " + lt));
    }
}

