/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class StatusLed
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -4028301444416809125L;
    public static final short LEVEL_NONE = -2;
    public static final short LEVEL_OFF = -1;
    public static final short LEVEL_0 = 0;
    public static final short LEVEL_1 = 1;
    public static final short LEVEL_2 = 2;
    public static final short LEVEL_3 = 3;
    public static final short LEVEL_4 = 4;
    private final ImageIcon LED_NOT = new ImageIcon(ImageUtils.getScaledImage("images/led_not.png", 14, 14));
    private final ImageIcon LED_OFF = new ImageIcon(ImageUtils.getScaledImage("images/led_none.png", 14, 14));
    private final ImageIcon LED_GREEN = new ImageIcon(ImageUtils.getScaledImage("images/led_green.png", 14, 14));
    private final ImageIcon LED_BLUE = new ImageIcon(ImageUtils.getScaledImage("images/led_blue.png", 14, 14));
    private final ImageIcon LED_YELLOW = new ImageIcon(ImageUtils.getScaledImage("images/led_yellow.png", 14, 14));
    private final ImageIcon LED_ORANGE = new ImageIcon(ImageUtils.getScaledImage("images/led_orange.png", 14, 14));
    private final ImageIcon LED_RED = new ImageIcon(ImageUtils.getScaledImage("images/led_red.png", 14, 14));
    private final ImageIcon LED_NOT_BIG = new ImageIcon(ImageUtils.getScaledImage("images/led_not.png", 44, 44));
    private final ImageIcon LED_OFF_BIG = new ImageIcon(ImageUtils.getImage("images/bola_none.png"));
    private final ImageIcon LED_GREEN_BIG = new ImageIcon(ImageUtils.getImage("images/bola_green.png"));
    private final ImageIcon LED_BLUE_BIG = new ImageIcon(ImageUtils.getImage("images/bola_blue.png"));
    private final ImageIcon LED_YELLOW_BIG = new ImageIcon(ImageUtils.getImage("images/bola_yellow.png"));
    private final ImageIcon LED_ORANGE_BIG = new ImageIcon(ImageUtils.getImage("images/bola_orange.png"));
    private final ImageIcon LED_RED_BIG = new ImageIcon(ImageUtils.getImage("images/bola_red.png"));
    private final Color COLOR_NOT = Color.BLACK;
    private final Color COLOR_OFF = Color.GRAY;
    private final Color COLOR_GREEN = new Color(0, 200, 125);
    private final Color COLOR_BLUE = Color.BLUE;
    public static final Color COLOR_YELLOW = new Color(200, 200, 0);
    public static final Color COLOR_ORANGE = new Color(255, 180, 0);
    public static final Color COLOR_RED = Color.RED;
    private final ImageIcon IMC_GREEN = new ImageIcon(ImageUtils.getImage("images/imc_green.png"));
    private final ImageIcon IMC_RED = new ImageIcon(ImageUtils.getImage("images/imc_red.png"));
    private final ImageIcon IMC_OFF = new ImageIcon(ImageUtils.getImage("images/imc_off.png"));
    private final ImageIcon SNAPSHOT_ON = new ImageIcon(ImageUtils.getScaledImage("images/menus/snapshot.png", 14, 14));
    private final ImageIcon SNAPSHOT_OFF = new ImageIcon(ImageUtils.getScaledImage("images/menus/snapshot_off.png", 14, 14));
    private final ImageIcon WEB_PUBLISH_ON = new ImageIcon(ImageUtils.getScaledImage("images/buttons/webup_enabled.png", 14, 14));
    private final ImageIcon WEB_PUBLISH_OFF = new ImageIcon(ImageUtils.getScaledImage("images/buttons/webup_disabled.png", 14, 14));
    private LinkedHashMap<Short, Color> levelsColors;
    private LinkedHashMap<Short, ImageIcon> levelsIcons;
    private JLabel statusIndicator = null;
    private short level = (short)-2;

    public StatusLed() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        LinkedHashMap<Short, ImageIcon> levelsIconsTemp = new LinkedHashMap<Short, ImageIcon>();
        levelsIconsTemp.put((short)-2, this.LED_NOT);
        levelsIconsTemp.put((short)-1, this.LED_OFF);
        levelsIconsTemp.put((short)0, this.LED_GREEN);
        levelsIconsTemp.put((short)1, this.LED_ORANGE);
        levelsIconsTemp.put((short)2, this.LED_RED);
        LinkedHashMap<Short, Color> levelsColorsTemp = new LinkedHashMap<Short, Color>();
        levelsColorsTemp.put((short)-2, this.COLOR_NOT);
        levelsColorsTemp.put((short)-1, this.COLOR_OFF);
        levelsColorsTemp.put((short)0, this.COLOR_GREEN);
        levelsColorsTemp.put((short)1, COLOR_ORANGE);
        levelsColorsTemp.put((short)2, COLOR_RED);
        this.levelsIcons = new LinkedHashMap(levelsIconsTemp);
        this.levelsColors = new LinkedHashMap(levelsColorsTemp);
        this.statusIndicator = new JLabel(this.LED_NOT);
        this.statusIndicator.addMouseListener(this);
        this.statusIndicator.setFont(new Font("Dialog", 0, 1));
        this.add((Component)this.statusIndicator, "Center");
    }

    public short getLevel() {
        return this.level;
    }

    public void setLevel(short level) {
        ImageIcon icon1 = this.levelsIcons.get(level);
        if (icon1 != null) {
            this.level = level;
            this.statusIndicator.setIcon(icon1);
            this.statusIndicator.setToolTipText("Level " + this.level);
            this.repaint();
        } else {
            this.level = (short)-2;
            icon1 = this.levelsIcons.get(this.level);
            this.statusIndicator.setIcon(icon1);
            this.statusIndicator.setToolTipText("Level " + this.level);
            this.repaint();
        }
    }

    public void setLevel(short level, String message) {
        this.setLevel(level);
        this.statusIndicator.setToolTipText(message);
    }

    public String getMessage() {
        return this.statusIndicator.getToolTipText();
    }

    public void setMessage(String msg) {
        this.statusIndicator.setToolTipText(msg);
    }

    public Color getColorLevel(int n) {
        Color ret = this.levelsColors.get((short)n);
        if (ret == null) {
            return Color.BLACK;
        }
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public LinkedHashMap<Short, Color> getLevelsColors() {
        return new LinkedHashMap<Short, Color>(this.levelsColors);
    }

    public LinkedHashMap<Short, ImageIcon> getLevelsIcons() {
        return new LinkedHashMap<Short, ImageIcon>(this.levelsIcons);
    }

    public boolean changeLevels(LinkedHashMap<Short, ImageIcon> newLevelsIcons, LinkedHashMap<Short, Color> newLevelsColors) {
        if (newLevelsIcons.size() != newLevelsColors.size()) {
            return false;
        }
        this.levelsIcons = newLevelsIcons;
        this.levelsColors = newLevelsColors;
        return true;
    }

    public void made5LevelIndicator() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.LED_OFF);
        this.levelsIcons.put((short)0, this.LED_GREEN);
        this.levelsIcons.put((short)1, this.LED_BLUE);
        this.levelsIcons.put((short)2, this.LED_YELLOW);
        this.levelsIcons.put((short)3, this.LED_ORANGE);
        this.levelsIcons.put((short)4, this.LED_RED);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, this.COLOR_BLUE);
        this.levelsColors.put((short)2, COLOR_YELLOW);
        this.levelsColors.put((short)3, COLOR_ORANGE);
        this.levelsColors.put((short)4, COLOR_RED);
    }

    public void made3LevelIndicator() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.LED_OFF);
        this.levelsIcons.put((short)0, this.LED_GREEN);
        this.levelsIcons.put((short)1, this.LED_ORANGE);
        this.levelsIcons.put((short)2, this.LED_RED);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, COLOR_ORANGE);
        this.levelsColors.put((short)2, COLOR_RED);
    }

    public void made2LevelIndicator() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.LED_OFF);
        this.levelsIcons.put((short)0, this.LED_GREEN);
        this.levelsIcons.put((short)1, this.LED_RED);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, COLOR_RED);
    }

    public void made1LevelIndicator() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.LED_OFF);
        this.levelsIcons.put((short)0, this.LED_BLUE);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_BLUE);
    }

    public void made5LevelIndicatorBig() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT_BIG);
        this.levelsIcons.put((short)-1, this.LED_OFF_BIG);
        this.levelsIcons.put((short)0, this.LED_GREEN_BIG);
        this.levelsIcons.put((short)1, this.LED_BLUE_BIG);
        this.levelsIcons.put((short)2, this.LED_YELLOW_BIG);
        this.levelsIcons.put((short)3, this.LED_ORANGE_BIG);
        this.levelsIcons.put((short)4, this.LED_RED_BIG);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, this.COLOR_BLUE);
        this.levelsColors.put((short)2, COLOR_YELLOW);
        this.levelsColors.put((short)3, COLOR_ORANGE);
        this.levelsColors.put((short)4, COLOR_RED);
    }

    public void made3LevelIndicatorBig() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT_BIG);
        this.levelsIcons.put((short)-1, this.LED_OFF_BIG);
        this.levelsIcons.put((short)0, this.LED_GREEN_BIG);
        this.levelsIcons.put((short)1, this.LED_ORANGE_BIG);
        this.levelsIcons.put((short)2, this.LED_RED_BIG);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, COLOR_ORANGE);
        this.levelsColors.put((short)2, COLOR_RED);
    }

    public void made2LevelIndicatorBig() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT_BIG);
        this.levelsIcons.put((short)-1, this.LED_OFF_BIG);
        this.levelsIcons.put((short)0, this.LED_GREEN_BIG);
        this.levelsIcons.put((short)1, this.LED_RED_BIG);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, COLOR_RED);
    }

    public void made1LevelIndicatorBig() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT_BIG);
        this.levelsIcons.put((short)-1, this.LED_OFF_BIG);
        this.levelsIcons.put((short)0, this.LED_BLUE_BIG);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_BLUE);
    }

    public void madeImc2LevelIndicator() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.IMC_OFF);
        this.levelsIcons.put((short)0, this.IMC_GREEN);
        this.levelsIcons.put((short)1, this.IMC_RED);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_GREEN);
        this.levelsColors.put((short)1, COLOR_RED);
    }

    public void made1LevelSnapshot() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.SNAPSHOT_OFF);
        this.levelsIcons.put((short)0, this.SNAPSHOT_ON);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_BLUE);
    }

    public void made1LevelWebPublish() {
        this.levelsIcons = new LinkedHashMap();
        this.levelsIcons.put((short)-2, this.LED_NOT);
        this.levelsIcons.put((short)-1, this.WEB_PUBLISH_OFF);
        this.levelsIcons.put((short)0, this.WEB_PUBLISH_ON);
        this.levelsColors = new LinkedHashMap();
        this.levelsColors.put((short)-2, this.COLOR_NOT);
        this.levelsColors.put((short)-1, this.COLOR_OFF);
        this.levelsColors.put((short)0, this.COLOR_BLUE);
    }

    public static void main(String[] args) throws InterruptedException {
        short i;
        JPanel tPanel = new JPanel();
        StatusLed sl = new StatusLed();
        tPanel.add(sl);
        JLabel jl = new JLabel("");
        tPanel.add(jl);
        JFrame frame = GuiUtils.testFrame(tPanel);
        frame.setSize(100, 100);
        sl.made5LevelIndicator();
        for (i = -2; i < 5; i = (short)(i + 1)) {
            sl.setLevel(i);
            jl.setText("Level:" + i);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        sl.made5LevelIndicatorBig();
        for (i = -2; i < 5; i = (short)(i + 1)) {
            sl.setLevel(i);
            jl.setText("Level:" + i);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        for (i = -2; i < 5; i = (short)(i + 1)) {
            sl.setLevel(i);
            jl.setText("Level:" + i);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        sl.madeImc2LevelIndicator();
        for (i = -2; i < 5; i = (short)(i + 1)) {
            sl.setLevel(i);
            jl.setText("Level:" + i);
            Thread.sleep(1000L);
        }
    }
}

