/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pt.lsts.neptus.gui.CloseTabbedPane;

public class TabCloseUI
implements MouseListener,
MouseMotionListener {
    private CloseTabbedPane tabbedPane;
    private int closeX = 0;
    private int closeY = 0;
    private int meX = 0;
    private int meY = 0;
    private int selectedTab;

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.closeUnderMouse(me.getX(), me.getY())) {
            this.tabbedPane.removeTabAt(this.selectedTab);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.meX = me.getX();
        this.meY = me.getY();
        if (this.mouseOverTab(this.meX, this.meY)) {
            this.tabbedPane.repaint();
        }
    }

    private boolean closeUnderMouse(int x, int y) {
        return new Rectangle(this.closeX - 2, this.closeY - 9, 10, 10).contains(x, y);
    }

    public void paint(Graphics g) {
        if (this.mouseOverTab(this.meX, this.meY)) {
            this.drawClose(g, this.closeX, this.closeY);
        }
        int tabCount = this.tabbedPane.getTabCount();
        for (int j = 0; j < tabCount; ++j) {
            if (!this.tabbedPane.getComponent(j).isShowing()) continue;
            int x = this.tabbedPane.getBoundsAt((int)j).x + this.tabbedPane.getBoundsAt((int)j).width - 12;
            int y = this.tabbedPane.getBoundsAt((int)j).y + 14;
            this.drawClose(g, x, y);
            break;
        }
    }

    private void drawClose(Graphics g, int x, int y) {
        if (this.tabbedPane != null && this.tabbedPane.getTabCount() > 0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(3.0f, 1, 1));
            g2.setColor(Color.BLACK);
            if (this.isUnderMouse(x, y)) {
                this.drawColored(g2, Color.RED.darker(), x, y);
            } else {
                this.drawColored(g2, Color.WHITE, x, y);
            }
        }
    }

    private void drawColored(Graphics2D g2, Color color, int x, int y) {
        g2.drawLine(x, y, x + 8, y - 8);
        g2.drawLine(x + 8, y, x, y - 8);
        g2.setColor(color);
        g2.setStroke(new BasicStroke(3.0f, 1, 1));
        g2.drawLine(x, y, x + 8, y - 8);
        g2.drawLine(x + 8, y, x, y - 8);
    }

    private boolean isUnderMouse(int x, int y) {
        return Math.abs(x - this.meX + 3) < 6 && Math.abs(y - this.meY - 4) < 6;
    }

    private boolean mouseOverTab(int x, int y) {
        if (this.tabbedPane.getTabCount() == 0) {
            return false;
        }
        for (int j = 0; j < this.tabbedPane.getTabCount(); ++j) {
            if (!this.tabbedPane.getBoundsAt(j).contains(this.meX, this.meY)) continue;
            this.selectedTab = j;
            this.closeX = this.tabbedPane.getBoundsAt((int)j).x + this.tabbedPane.getBoundsAt((int)j).width - 12;
            this.closeY = this.tabbedPane.getBoundsAt((int)j).y + 14;
            return true;
        }
        return false;
    }

    public void setTabbedPane(CloseTabbedPane ctp) {
        this.tabbedPane = ctp;
    }
}

