/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pt.lsts.neptus.util.FileUtil;

public class TextViewer
extends JPanel {
    private static final long serialVersionUID = -3285334845813428890L;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JTextArea textArea = null;
    private JLabel statusText = null;

    public TextViewer() {
        this.initialize();
    }

    public TextViewer(String filename) {
        this();
        this.showFile(filename);
    }

    public boolean showFile(String filename) {
        String fileContent = FileUtil.getFileAsString(filename);
        this.getTextArea().setText(fileContent);
        this.getStatusText().setText("[viewing " + filename + "]");
        Frame frm = JOptionPane.getFrameForComponent(this);
        frm.setTitle(filename + " - TextViewer");
        return true;
    }

    private void initialize() {
        BorderLayout borderLayout2 = new BorderLayout();
        this.setLayout(borderLayout2);
        this.setSize(400, 300);
        this.setPreferredSize(new Dimension(400, 300));
        borderLayout2.setHgap(0);
        borderLayout2.setVgap(0);
        this.add((Component)this.getJPanel(), "South");
        this.add((Component)this.getJScrollPane(), "Center");
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout1);
            flowLayout1.setAlignment(2);
            this.jPanel.setBorder(BorderFactory.createBevelBorder(0));
            this.jPanel.add((Component)this.getStatusText(), null);
        }
        return this.jPanel;
    }

    private JLabel getStatusText() {
        if (this.statusText == null) {
            this.statusText = new JLabel("[No file opened]");
        }
        return this.statusText;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTextArea());
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.jScrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(false);
        }
        return this.textArea;
    }

    public static void showFileViewer(String filename) {
        JFrame frm = new JFrame(filename + " - TextViewer");
        frm.setContentPane(new TextViewer(filename));
        frm.setSize(640, 500);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
    }

    public static void showFileViewerDialog(Window parent, String filename) {
        JDialog frm = null;
        if (parent instanceof Dialog) {
            frm = new JDialog((Dialog)parent, filename + " - TextViewer");
        } else if (parent instanceof Frame) {
            frm = new JDialog((Frame)parent, filename + " - TextViewer");
        } else {
            frm = new JDialog();
            frm.setTitle(filename + " - TextViewer");
        }
        frm.setContentPane(new TextViewer(filename));
        frm.setSize(640, 500);
        frm.setDefaultCloseOperation(2);
        frm.setModal(true);
        frm.setVisible(true);
    }

    public static void main(String[] args) {
        TextViewer.showFileViewer("/etc/passwd");
    }
}

