/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.texture.TextureType;
import pt.lsts.neptus.types.texture.TexturesHolder;
import pt.lsts.neptus.util.ImageUtils;

public class TextureComboChooser
extends JComboBox<Object> {
    private static final long serialVersionUID = -888237723263535970L;
    ImageIcon[] images;
    String[] texNames;

    private String getSelectedName() {
        int selection = this.getSelectedIndex();
        return this.texNames[selection];
    }

    public TextureType getCurrentlySelectedTexture() {
        return TexturesHolder.getTextureByName(this.getSelectedName());
    }

    public TextureComboChooser(Integer[] intArray) {
        super(intArray);
    }

    public static TextureComboChooser createTextureComboChooser() {
        LinkedHashMap<String, TextureType> tlh = TexturesHolder.getTexturesList();
        ImageIcon[] images = new ImageIcon[tlh.keySet().size() + 1];
        Integer[] intArray = new Integer[tlh.keySet().size() + 1];
        String[] texNames = new String[tlh.keySet().size() + 1];
        texNames[0] = "none";
        Iterator<String> it = tlh.keySet().iterator();
        int i = 1;
        while (it.hasNext()) {
            texNames[i] = it.next();
            ++i;
        }
        for (i = 0; i < texNames.length; ++i) {
            intArray[i] = new Integer(i);
            TextureType texType = TexturesHolder.getTextureByName(texNames[i]);
            images[i] = texType != null ? new ImageIcon(ImageUtils.getScaledImage(texType.getTextureImage(), 50, 30, false)) : null;
            if (images[i] == null) continue;
            images[i].setDescription(texNames[i]);
        }
        TextureComboChooser texturesList = new TextureComboChooser(intArray);
        texturesList.images = images;
        texturesList.texNames = texNames;
        TextureComboBoxRenderer renderer = texturesList.new TextureComboBoxRenderer();
        renderer.setPreferredSize(new Dimension(150, 35));
        texturesList.setRenderer(renderer);
        texturesList.setMaximumRowCount(3);
        return texturesList;
    }

    public static void main(String[] args) {
    }

    public void setSelectedTexture(TextureType selectedTexture) {
        this.setSelectedIndex(0);
        if (selectedTexture == null) {
            System.err.println("Setting- selected index to 0");
            return;
        }
        for (int i = 1; i < this.texNames.length; ++i) {
            if (!this.texNames[i].equals(selectedTexture.getName())) continue;
            System.err.println("Setting selected index to " + i);
            this.setSelectedIndex(i);
            return;
        }
        System.err.println("Setting selected index to 0");
    }

    class TextureComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 5863479457884534402L;
        private Font uhOhFont;

        public TextureComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ImageIcon icon = TextureComboChooser.this.images[selectedIndex];
            String pet = TextureComboChooser.this.texNames[selectedIndex];
            this.setIcon(icon);
            if (icon != null) {
                this.setText(I18n.text(pet));
                this.setFont(list.getFont());
            } else {
                this.setUhOhText(I18n.text(pet), list.getFont());
            }
            return this;
        }

        protected void setUhOhText(String uhOhText, Font normalFont) {
            if (this.uhOhFont == null) {
                this.uhOhFont = normalFont.deriveFont(2);
            }
            this.setFont(this.uhOhFont);
            this.setText(uhOhText);
        }
    }
}

