/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.gui.TimelineChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;

public class Timeline
extends JPanel
implements ChangeListener {
    public static final ImageIcon ICON_PLAY = ImageUtils.getIcon("images/icons/play.png");
    public static final ImageIcon ICON_PAUSE = ImageUtils.getIcon("images/icons/pause.png");
    public static final ImageIcon ICON_FW = ImageUtils.getIcon("images/icons/forward.png");
    public static final ImageIcon ICON_BW = ImageUtils.getIcon("images/icons/backward.png");
    private JSlider slider;
    private JButton play;
    private JButton speedUp;
    private JButton speedDown;
    private JLabel time;
    private AbstractAction playAction;
    private AbstractAction pauseAction;
    private List<TimelineChangeListener> listeners = new ArrayList<TimelineChangeListener>();
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Timeline Thread");
            t.setDaemon(true);
            return t;
        }
    });
    protected SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean waitForAdjustment;
    private boolean running;
    private int frequency;
    private int advancePerSecond;
    private int speed;
    private int maxSpeed = 16;
    private Runnable updater;

    public Timeline(int min, int max, int frequency, int perSecond, boolean wait) {
        this.slider = new JSlider(min, max);
        this.slider.addChangeListener(this);
        this.slider.setPaintTicks(true);
        this.play = new JButton(I18n.text("Play"));
        this.speedUp = new JButton(I18n.text("Faster"));
        this.speedDown = new JButton(I18n.text("Slower"));
        this.time = new JLabel("");
        this.playAction = this.getPlayAction();
        this.pauseAction = this.getPauseAction();
        this.play.setAction(this.playAction);
        this.speedUp.setAction(this.getSpeedUpAction());
        this.speedDown.setAction(this.getSpeedDownAction());
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)this.play, "sg buttons");
        this.add((Component)this.speedDown, "sg buttons");
        this.add((Component)this.speedUp, "sg buttons");
        this.add((Component)this.slider, "h 100%, w 100%");
        this.add(this.time);
        this.speed = 1;
        this.frequency = frequency;
        this.advancePerSecond = perSecond;
        this.waitForAdjustment = wait;
        this.running = false;
        this.updater = new Runnable(){

            @Override
            public void run() {
                if (Timeline.this.running) {
                    Timeline.this.slider.setValue(Timeline.this.slider.getValue() + Timeline.this.advancePerSecond / Timeline.this.frequency * Timeline.this.speed);
                }
            }
        };
        this.service.scheduleAtFixedRate(this.updater, 0L, 1000 / this.frequency, TimeUnit.MILLISECONDS);
    }

    public AbstractAction getPlayAction() {
        return new AbstractAction("", ICON_PLAY){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timeline.this.play();
            }
        };
    }

    public AbstractAction getPauseAction() {
        return new AbstractAction("", ICON_PAUSE){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timeline.this.pause();
            }
        };
    }

    public AbstractAction getSpeedUpAction() {
        return new AbstractAction("", ICON_FW){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timeline.this.speed *= 2;
                if (Timeline.this.speed > Timeline.this.maxSpeed) {
                    Timeline.this.speed = Timeline.this.maxSpeed;
                }
            }
        };
    }

    public AbstractAction getSpeedDownAction() {
        return new AbstractAction("", ICON_BW){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timeline.this.speed /= 2;
                if (Timeline.this.speed < 1) {
                    Timeline.this.speed = 1;
                }
            }
        };
    }

    public void pause() {
        this.running = false;
        this.play.setAction(this.playAction);
    }

    public void play() {
        this.running = true;
        this.play.setAction(this.pauseAction);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setMaxSpeed(int maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addTimelineChangeListener(TimelineChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.slider.getValueIsAdjusting() == this.waitForAdjustment) {
            for (TimelineChangeListener l : this.listeners) {
                l.timelineChanged(this.slider.getValue());
            }
        }
        if (this.slider.getValue() >= this.slider.getMaximum()) {
            this.running = false;
        }
    }

    public void setTime(long epochTimeMillis) {
        this.time.setText(this.fmt.format(new Date(epochTimeMillis)) + "(x" + this.speed + ")");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        final JLabel label = new JLabel("asdad");
        Timeline timeline = new Timeline(0, 100, 10, 10, true);
        frame.setSize(600, 100);
        frame.setLayout((LayoutManager)new MigLayout());
        frame.add((Component)label, "w 100%, wrap");
        frame.add(timeline);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        timeline.addTimelineChangeListener(new TimelineChangeListener(){

            @Override
            public void timelineChanged(int value) {
                label.setText(value + "");
            }
        });
    }
}

