/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXButton;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class ToolbarButton
extends JXButton {
    public static final long serialVersionUID = 17L;
    private Color bgColor;

    public ToolbarButton(String imageURL, String toolTipText, String actionCommand) {
        super((Icon)new ImageIcon(ImageUtils.getImage(imageURL)));
        this.setToolTipText(toolTipText);
        this.setActionCommand(actionCommand);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarButton.this.isEnabled()) {
                    ToolbarButton.this.setBorderPainted(true);
                    ToolbarButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarButton.this.setBorderPainted(false);
                ToolbarButton.this.repaint();
            }
        });
    }

    public ToolbarButton(ImageIcon image, String text, String toolTipText, String actionCommand) {
        super(text);
        if (image != null) {
            this.setIcon(image);
        }
        this.setToolTipText(toolTipText);
        this.setActionCommand(actionCommand);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarButton.this.isEnabled()) {
                    ToolbarButton.this.setBorderPainted(true);
                    ToolbarButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarButton.this.setBorderPainted(false);
                ToolbarButton.this.repaint();
            }
        });
    }

    public ToolbarButton(ImageIcon image, String toolTipText, String actionCommand) {
        super((Icon)image);
        this.setToolTipText(toolTipText);
        this.setActionCommand(actionCommand);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarButton.this.isEnabled()) {
                    ToolbarButton.this.setBorderPainted(true);
                    ToolbarButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarButton.this.setBorderPainted(false);
                ToolbarButton.this.repaint();
            }
        });
    }

    public ToolbarButton(AbstractAction action) {
        super((Action)action);
        this.setText("");
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarButton.this.isEnabled()) {
                    ToolbarButton.this.setBorderPainted(true);
                    ToolbarButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarButton.this.setBorderPainted(false);
                ToolbarButton.this.repaint();
            }
        });
        if (action.getValue("ShortDescription") != null) {
            this.setToolTipText(action.getValue("ShortDescription").toString());
        } else {
            this.setToolTipText(action.getValue("Name").toString());
        }
    }

    public void setBackColor(Color c) {
        this.bgColor = c;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.setOpaque(false);
        }
        super.paintComponent(g);
    }

    public static void main(String[] args) {
        ToolbarButton tb = new ToolbarButton(new AbstractAction("Test", ImageUtils.getScaledIcon("images/buttons/clear.png", 16, 16)){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        GuiUtils.testFrame((JComponent)((Object)tb));
    }
}

