/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class ToolbarSwitch
extends JToggleButton {
    public static final long serialVersionUID = 17L;

    public ToolbarSwitch(String text, String actionCommand) {
        super(text);
        this.setToolTipText(text);
        this.setActionCommand(actionCommand);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarSwitch.this.isEnabled()) {
                    ToolbarSwitch.this.setBorderPainted(true);
                    ToolbarSwitch.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarSwitch.this.setBorderPainted(false);
                ToolbarSwitch.this.repaint();
            }
        });
    }

    public ToolbarSwitch(ImageIcon icon, String tooltipText, String actionCommand) {
        super(icon);
        this.setActionCommand(actionCommand);
        this.setToolTipText(tooltipText);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarSwitch.this.isEnabled()) {
                    ToolbarSwitch.this.setBorderPainted(true);
                    ToolbarSwitch.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                if (!ToolbarSwitch.this.isSelected()) {
                    ToolbarSwitch.this.setBorderPainted(false);
                }
                ToolbarSwitch.this.repaint();
            }
        });
    }

    public ToolbarSwitch(String imageURL, String toolTipText, String actionCommand, ClassLoader cl) {
        super(new ImageIcon(cl.getResource(imageURL)));
        this.setToolTipText(toolTipText);
        this.setActionCommand(actionCommand);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarSwitch.this.isEnabled()) {
                    ToolbarSwitch.this.setBorderPainted(true);
                    ToolbarSwitch.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarSwitch.this.setBorderPainted(false);
                ToolbarSwitch.this.repaint();
            }
        });
    }

    public ToolbarSwitch(AbstractAction action) {
        super(action);
        this.setText("");
        this.setToolTipText(action.getValue("Name").toString());
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarSwitch.this.isEnabled()) {
                    ToolbarSwitch.this.setBorderPainted(true);
                    ToolbarSwitch.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarSwitch.this.setBorderPainted(false);
                ToolbarSwitch.this.repaint();
            }
        });
        this.setSelected(true);
    }

    public ToolbarSwitch(String text, AbstractAction action) {
        super(action);
        this.setText("");
        this.setToolTipText(text);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (ToolbarSwitch.this.isEnabled()) {
                    ToolbarSwitch.this.setBorderPainted(true);
                    ToolbarSwitch.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarSwitch.this.setBorderPainted(false);
                ToolbarSwitch.this.repaint();
            }
        });
        this.setSelected(true);
    }

    public void setState(boolean value) {
        this.setSelected(value);
    }

    public boolean getState() {
        return this.isSelected();
    }
}

