/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.InputStream;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class VehicleDepthFrontDistanceInfo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ImagePanel beanImage = null;
    private JPanel jPanel = null;
    private ImagePanel upSetaImage = null;
    private ImagePanel vehicleImage = null;
    private ImagePanel downSetaImage = null;
    private String vehicleImageFile = null;

    public VehicleDepthFrontDistanceInfo() {
        this.initialize();
    }

    public VehicleDepthFrontDistanceInfo(String vehicleImageFile) {
        this.vehicleImageFile = vehicleImageFile;
        this.initialize();
    }

    private ImagePanel getBeanImage() {
        if (this.beanImage == null) {
            this.beanImage = new ImagePanel();
            this.beanImage.setLayout(null);
            InputStream ist = this.getClass().getResourceAsStream("/images/def-bean.png");
            String inFileName = StreamUtil.copyStreamToTempFile(ist).getAbsolutePath();
            this.beanImage.setImage(inFileName);
            this.beanImage.setImageWidth(42);
            this.beanImage.setPreferredSize(new Dimension(40, 213));
            this.beanImage.setImageHeight(213);
            this.beanImage.setBackground(new Color(3, 113, 172));
        }
        return this.beanImage;
    }

    private void initialize() {
        FlowLayout flowLayout1 = new FlowLayout();
        this.setLayout(flowLayout1);
        this.setPreferredSize(new Dimension(150, 213));
        this.setSize(150, 213);
        this.setForeground(new Color(3, 113, 172));
        this.setBackground(new Color(3, 113, 172));
        flowLayout1.setHgap(0);
        flowLayout1.setVgap(0);
        this.add((Component)this.getJPanel(), null);
        this.add((Component)this.getBeanImage(), null);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout2);
            this.jPanel.setPreferredSize(new Dimension(108, 213));
            flowLayout2.setHgap(0);
            flowLayout2.setVgap(0);
            this.jPanel.add((Component)this.getUpSetaImage(), null);
            this.jPanel.add((Component)this.getVehicleImage(), null);
            this.jPanel.add((Component)this.getDownSetaImage(), null);
        }
        return this.jPanel;
    }

    private ImagePanel getUpSetaImage() {
        if (this.upSetaImage == null) {
            this.upSetaImage = new ImagePanel();
            InputStream ist = this.getClass().getResourceAsStream("/images/def-set.png");
            String inFileName = StreamUtil.copyStreamToTempFile(ist).getAbsolutePath();
            this.upSetaImage.setImage(inFileName);
            this.upSetaImage.setPreferredSize(new Dimension(108, 77));
            this.upSetaImage.setBackground(new Color(3, 113, 172));
            this.upSetaImage.adjustImageSizeToPreferredSize();
        }
        return this.upSetaImage;
    }

    private ImagePanel getVehicleImage() {
        if (this.vehicleImage == null) {
            String inFileName;
            this.vehicleImage = new ImagePanel();
            if (this.vehicleImageFile == null) {
                InputStream ist = this.getClass().getResourceAsStream("/images/def-veh.png");
                inFileName = StreamUtil.copyStreamToTempFile(ist).getAbsolutePath();
            } else {
                inFileName = this.vehicleImageFile;
            }
            this.vehicleImage.setImage(inFileName);
            this.vehicleImage.setPreferredSize(new Dimension(108, 59));
            this.vehicleImage.setBackground(new Color(3, 113, 172));
            this.vehicleImage.adjustImageSizeToPreferredSize();
        }
        return this.vehicleImage;
    }

    private ImagePanel getDownSetaImage() {
        if (this.downSetaImage == null) {
            this.downSetaImage = new ImagePanel();
            InputStream ist = this.getClass().getResourceAsStream("/images/def-set.png");
            String inFileName = StreamUtil.copyStreamToTempFile(ist).getAbsolutePath();
            this.downSetaImage.setImage(inFileName);
            this.downSetaImage.setPreferredSize(new Dimension(108, 77));
            this.downSetaImage.setBackground(new Color(3, 113, 172));
            this.downSetaImage.adjustImageSizeToPreferredSize();
        }
        return this.downSetaImage;
    }

    public void changeVehicleImage(String vehicleImageFile) {
        this.vehicleImageFile = vehicleImageFile;
        this.vehicleImage.setImage(this.vehicleImageFile);
        this.vehicleImage.adjustImageSizeToPreferredSize();
        this.paintImmediately(0, 0, 300, 300);
    }

    public void substituteVehiclePanel(JPanel vehiclePanel) {
        vehiclePanel.setPreferredSize(new Dimension(108, 59));
        this.getJPanel().remove(this.getUpSetaImage());
        this.getJPanel().remove(this.getVehicleImage());
        this.getJPanel().remove(this.getDownSetaImage());
        this.jPanel.add((Component)this.getUpSetaImage(), null);
        this.jPanel.add((Component)vehiclePanel, null);
        this.jPanel.add((Component)this.getDownSetaImage(), null);
        this.jPanel.paintImmediately(0, 0, 300, 300);
    }

    public void restoreVehiclePanel() {
        this.getJPanel().removeAll();
        this.jPanel.add((Component)this.getUpSetaImage(), null);
        this.jPanel.add((Component)this.getVehicleImage(), null);
        this.jPanel.add((Component)this.getDownSetaImage(), null);
        this.jPanel.paintImmediately(0, 0, 300, 300);
    }

    public static void main(String[] args) throws InterruptedException {
        ConfigFetch.initialize();
        VehicleDepthFrontDistanceInfo vv = new VehicleDepthFrontDistanceInfo();
        GuiUtils.testFrame(vv, "Unitary Test");
        Thread.sleep(2000L);
        vv.changeVehicleImage("vehicles-files/rov-kos/conf/images/rov-kos_side.png");
        Thread.sleep(2000L);
        vv.changeVehicleImage("vehicles-files/isurus/conf/images/isurus_side.png");
        Thread.sleep(2000L);
        vv.changeVehicleImage("vehicles-files/rov-ies/conf/images/rov-ies_side.png");
        Thread.sleep(2000L);
        vv.changeVehicleImage("vehicles-files/apv/conf/images/avp-l.png");
    }
}

