/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.dom4j.Document;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.gui.CoordinateSystemPanel;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.TextViewer;
import pt.lsts.neptus.renderer3d.Object3DCreationHelper;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.AdjustTimeShellArgs;
import pt.lsts.neptus.types.comm.protocol.FTPArgs;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.misc.FileType;
import pt.lsts.neptus.types.mission.VehicleMission;
import pt.lsts.neptus.types.vehicle.TemplateFileVehicle;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.JTreeUtils;
import pt.lsts.neptus.util.editors.EditorLauncher;

public class VehicleInfo
extends JPanel
implements PropertiesProvider {
    private static final long serialVersionUID = 1L;
    private VehicleType vehicle = null;
    private JPanel jContentPane = null;
    private JDialog vehicleInfoDialog = null;
    private JPanel genInfoPanel = null;
    private JPanel idPanel = null;
    private JLabel idLabel = null;
    private JLabel idValue = null;
    private JPanel namePanel = null;
    private JLabel nameLabel = null;
    private JLabel nameValue = null;
    private JPanel typePanel = null;
    private JLabel typeLabel = null;
    private JLabel typeValue = null;
    private ImagePanel imagePanel = null;
    private JPanel ginfoPanel = null;
    private JTree filesTree = null;
    private DefaultMutableTreeNode root = null;
    private JPanel fileInfoPanel = null;
    private JPanel filesPanel = null;
    private JScrollPane jScrollPane = null;
    private JLabel fxTypeLabel = null;
    private JLabel fxTypeValue = null;
    private JLabel fxHrefLabel = null;
    private JLabel fxDescLabel = null;
    private JTextArea fxDescTextArea = null;
    private JTextField fxHrefTextField = null;
    private JButton fxEditButton = null;
    private JLabel dimLabel = null;
    private JTextField dimTextField = null;
    private JScrollPane fxDescScrollPane = null;
    private CoordinateSystemPanel coordinateSystemPanel = null;
    private JPanel attitudePanel = null;
    private CoordinateSystem coordinateSystem = null;
    private boolean editableInfo = true;
    private boolean editableVehicleRef = false;
    private JButton okButton = null;
    private JPanel okPanel = null;
    private JButton cancelButton = null;
    private JPanel cardsPanel = null;
    private JPanel card1 = null;
    private JPanel card2 = null;
    private JScrollPane jScrollPane1 = null;
    private JTextArea fxDescTextArea2 = null;
    private JTextField fxParamXsltTextField = null;
    private JTextField fxOutputFileTextField = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JButton viewer3DButton = null;
    private JButton propertiesButton = null;
    private JButton openConsolesButton = null;
    private JPanel modelPanel = null;
    private JLabel modelLabel = null;
    private JLabel modelValue = null;

    public VehicleInfo(VehicleType vehicle) {
        this.vehicle = vehicle;
        this.initialize();
    }

    public VehicleInfo(VehicleType vehicle, CoordinateSystem cs) {
        this.vehicle = vehicle;
        this.coordinateSystem = cs;
        this.initialize();
    }

    public VehicleInfo(VehicleType vehicle, CoordinateSystem cs, boolean editInfo, boolean editCS) {
        this.vehicle = vehicle;
        this.coordinateSystem = cs;
        this.initialize();
        this.setInfoEditable(editInfo);
        this.setVehicleRefEditable(editCS);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JDialog getVehicleInfoDialog() {
        if (this.vehicleInfoDialog == null) {
            this.vehicleInfoDialog = new JDialog();
            this.vehicleInfoDialog.setContentPane(this.getJContentPane());
            this.vehicleInfoDialog.setTitle("System Info");
            this.vehicleInfoDialog.setResizable(false);
            this.vehicleInfoDialog.setSize(410, 550);
            this.vehicleInfoDialog.setLayout(new BorderLayout());
            this.vehicleInfoDialog.getContentPane().add((Component)this, "Center");
            this.vehicleInfoDialog.setDefaultCloseOperation(2);
            this.vehicleInfoDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.vehicleInfoDialog.setAlwaysOnTop(true);
            GuiUtils.centerOnScreen(this.vehicleInfoDialog);
            this.vehicleInfoDialog.setVisible(true);
            this.vehicleInfoDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    VehicleInfo.this.closeFrame();
                }
            });
            return this.vehicleInfoDialog;
        }
        return this.vehicleInfoDialog;
    }

    public void setInfoEditable(boolean value) {
        this.editableInfo = value;
    }

    public void setVehicleRefEditable(boolean value) {
        this.editableVehicleRef = value;
        if (!this.editableVehicleRef) {
            this.getCoordinateSystemPanel().setEditable(false);
            this.getOkButton().setEnabled(false);
            this.getCancelButton().setEnabled(false);
        } else {
            this.getCoordinateSystemPanel().setEditable(true);
            this.getOkButton().setEnabled(true);
            this.getCancelButton().setEnabled(true);
        }
    }

    public static VehicleType showVehicleInfoDialog(VehicleType ve) {
        VehicleInfo vecPanel = new VehicleInfo(ve);
        vecPanel.getVehicleInfoDialog();
        return ve;
    }

    public static CoordinateSystem showVehicleMissionEditDialog(VehicleType ve, CoordinateSystem cs) {
        VehicleInfo vecPanel = new VehicleInfo(ve, cs, false, false);
        vecPanel.getVehicleInfoDialog();
        return cs;
    }

    public static CoordinateSystem showVehiclePlannerEditDialog(VehicleType ve, CoordinateSystem cs) {
        VehicleInfo vecPanel = new VehicleInfo(ve, cs, false, true);
        vecPanel.getVehicleInfoDialog();
        return cs;
    }

    private void initialize() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(402, 479));
        this.setSize(402, 563);
        this.setLocation(5, 5);
        this.add((Component)this.getGenInfoPanel(), null);
        this.add((Component)this.getFilesPanel(), null);
        this.add((Component)this.getAttitudePanel(), null);
        this.add((Component)this.getOkPanel(), null);
        int width = this.getGenInfoPanel().getWidth();
        int height = this.getGenInfoPanel().getHeight() + this.getFilesPanel().getHeight() + this.getCoordinateSystemPanel().getHeight() + 20 + 200;
        this.setSize(width, height);
    }

    private JPanel getGenInfoPanel() {
        if (this.genInfoPanel == null) {
            this.dimLabel = new JLabel();
            this.genInfoPanel = new JPanel();
            this.genInfoPanel.setLayout(null);
            this.genInfoPanel.setBorder(BorderFactory.createTitledBorder(null, "Info", 0, 0, null, null));
            this.genInfoPanel.setBounds(6, 9, 390, 130);
            this.dimLabel.setBounds(191, 105, 73, 17);
            this.dimLabel.setText("L/W/H (m):");
            this.dimLabel.setToolTipText("Length/Width/Height");
            this.genInfoPanel.add((Component)this.getImagePanel(), null);
            this.genInfoPanel.add((Component)this.getGinfoPanel(), null);
            this.genInfoPanel.add((Component)this.dimLabel, null);
            this.genInfoPanel.add((Component)this.getDimTextField(), null);
            this.genInfoPanel.add((Component)this.getViewer3DButton(), null);
            this.genInfoPanel.add((Component)this.getPropertiesButton(), null);
        }
        return this.genInfoPanel;
    }

    private JPanel getIdPanel() {
        if (this.idPanel == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            this.idValue = new JLabel();
            this.idLabel = new JLabel();
            this.idPanel = new JPanel();
            this.idPanel.setBounds(new Rectangle(0, 0, 200, 18));
            this.idPanel.setLayout(flowLayout3);
            this.idLabel.setText("Id:");
            this.idValue.setText(this.vehicle.getId());
            this.idValue.setForeground(Color.darkGray);
            flowLayout3.setAlignment(0);
            flowLayout3.setHgap(5);
            flowLayout3.setVgap(1);
            this.idPanel.add((Component)this.idLabel, null);
            this.idPanel.add((Component)this.idValue, null);
        }
        return this.idPanel;
    }

    private JPanel getNamePanel() {
        if (this.namePanel == null) {
            this.nameValue = new JLabel();
            this.nameLabel = new JLabel();
            FlowLayout flowLayout4 = new FlowLayout();
            this.namePanel = new JPanel();
            this.namePanel.setLocation(new Point(0, 22));
            this.namePanel.setSize(new Dimension(200, 18));
            this.namePanel.setLayout(flowLayout4);
            flowLayout4.setAlignment(0);
            flowLayout4.setHgap(5);
            flowLayout4.setVgap(1);
            this.nameLabel.setText("Name:");
            this.nameValue.setText(this.vehicle.getName());
            this.nameValue.setForeground(Color.darkGray);
            this.namePanel.add((Component)this.nameLabel, null);
            this.namePanel.add((Component)this.nameValue, null);
        }
        return this.namePanel;
    }

    private JPanel getTypePanel() {
        if (this.typePanel == null) {
            this.typeValue = new JLabel();
            this.typeLabel = new JLabel();
            FlowLayout flowLayout6 = new FlowLayout();
            this.typePanel = new JPanel();
            this.typePanel.setBounds(new Rectangle(0, 65, 112, 19));
            this.typePanel.setLayout(flowLayout6);
            flowLayout6.setAlignment(0);
            this.typeLabel.setText("Type:");
            this.typeValue.setText(this.vehicle.getType().toUpperCase());
            this.typeValue.setForeground(Color.darkGray);
            flowLayout6.setHgap(5);
            flowLayout6.setVgap(1);
            this.typePanel.add((Component)this.typeLabel, null);
            this.typePanel.add((Component)this.typeValue, null);
        }
        return this.typePanel;
    }

    private ImagePanel getImagePanel() {
        if (this.imagePanel == null) {
            this.imagePanel = new ImagePanel();
            if (this.vehicle.getPresentationImageHref().equalsIgnoreCase("")) {
                this.imagePanel.setImage(this.vehicle.getSideImageHref());
            } else {
                this.imagePanel.setImage(this.vehicle.getPresentationImageHref());
            }
            this.imagePanel.setSize(174, 92);
            this.imagePanel.setPreferredSize(new Dimension(150, 60));
            this.imagePanel.adjustImageSizeToPanelSize();
            this.imagePanel.setLocation(7, 17);
        }
        return this.imagePanel;
    }

    private JPanel getGinfoPanel() {
        if (this.ginfoPanel == null) {
            this.ginfoPanel = new JPanel();
            this.ginfoPanel.setLayout(null);
            this.ginfoPanel.setBounds(185, 16, 200, 86);
            this.ginfoPanel.add((Component)this.getIdPanel(), null);
            this.ginfoPanel.add((Component)this.getNamePanel(), null);
            this.ginfoPanel.add((Component)this.getTypePanel(), null);
            this.ginfoPanel.add((Component)this.getOpenConsolesButton(), null);
            this.ginfoPanel.add((Component)this.getModelPanel(), null);
        }
        return this.ginfoPanel;
    }

    private JTree getFilesTree() {
        if (this.filesTree == null) {
            this.root = new DefaultMutableTreeNode("Files");
            this.constructTree(this.root);
            this.filesTree = new JTree(this.root);
            this.filesTree.setEditable(false);
            this.filesTree.setRootVisible(false);
            this.filesTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)VehicleInfo.this.filesTree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    Object nodeInfo = node.getUserObject();
                    if (nodeInfo instanceof TemplateFileVehicle) {
                        CardLayout cl = (CardLayout)VehicleInfo.this.getCardsPanel().getLayout();
                        cl.show(VehicleInfo.this.getCardsPanel(), "card2");
                        TemplateFileVehicle ft = (TemplateFileVehicle)nodeInfo;
                        VehicleInfo.this.fxTypeValue.setText(ft.getType());
                        VehicleInfo.this.fxHrefTextField.setText(ft.getHref());
                        VehicleInfo.this.fxDescTextArea2.setText(ft.getDescription());
                        VehicleInfo.this.fxParamXsltTextField.setText(ft.getParametersToPass());
                        VehicleInfo.this.fxOutputFileTextField.setText(ft.getOutputFileName());
                        VehicleInfo.this.fxEditButton.setEnabled(true);
                        if (VehicleInfo.this.editableInfo) {
                            VehicleInfo.this.fxEditButton.setText("Edit");
                        } else {
                            VehicleInfo.this.fxEditButton.setText("View");
                        }
                    } else if (nodeInfo instanceof FileType) {
                        CardLayout cl = (CardLayout)VehicleInfo.this.getCardsPanel().getLayout();
                        cl.show(VehicleInfo.this.getCardsPanel(), "card1");
                        FileType ft = (FileType)nodeInfo;
                        VehicleInfo.this.fxTypeValue.setText(ft.getType());
                        VehicleInfo.this.fxHrefTextField.setText(ft.getHref());
                        VehicleInfo.this.fxDescTextArea.setText(ft.getDescription());
                        VehicleInfo.this.fxEditButton.setEnabled(true);
                        if (VehicleInfo.this.editableInfo) {
                            VehicleInfo.this.fxEditButton.setText("Edit");
                        } else {
                            VehicleInfo.this.fxEditButton.setText("View");
                        }
                    } else {
                        CardLayout cl = (CardLayout)VehicleInfo.this.getCardsPanel().getLayout();
                        cl.show(VehicleInfo.this.getCardsPanel(), "card1");
                        VehicleInfo.this.fxTypeValue.setText("");
                        VehicleInfo.this.fxHrefTextField.setText("");
                        VehicleInfo.this.fxDescTextArea.setText("");
                        VehicleInfo.this.fxEditButton.setEnabled(false);
                    }
                }
            });
            JTreeUtils.expandAll(this.filesTree);
        }
        return this.filesTree;
    }

    private void constructTree(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode child;
        DefaultMutableTreeNode parent = root;
        Iterator<FileType> it = this.vehicle.getTransformationXSLTTemplates().values().iterator();
        if (it.hasNext()) {
            parent = new DefaultMutableTreeNode("Transformation XSLT");
            root.add(parent);
        }
        while (it.hasNext()) {
            TemplateFileVehicle tfx = it.next();
            child = new DefaultMutableTreeNode(tfx);
            parent.add(child);
        }
        FileType aft = this.vehicle.getManeuverAdditionalFile();
        if (aft != null) {
            parent = new DefaultMutableTreeNode("Adicional Maneuver File");
            root.add(parent);
            child = new DefaultMutableTreeNode(aft);
            parent.add(child);
        }
        if ((it = this.vehicle.getMiscConfigurationFiles().values().iterator()).hasNext()) {
            parent = new DefaultMutableTreeNode("Misc files");
            root.add(parent);
        }
        while (it.hasNext()) {
            FileType tfx = it.next();
            DefaultMutableTreeNode child2 = new DefaultMutableTreeNode(tfx);
            parent.add(child2);
        }
    }

    private JPanel getFileInfoPanel() {
        if (this.fileInfoPanel == null) {
            this.fxTypeLabel = new JLabel();
            this.fxTypeValue = new JLabel();
            this.fxHrefLabel = new JLabel();
            this.fxDescLabel = new JLabel();
            this.fileInfoPanel = new JPanel();
            this.fileInfoPanel.setLayout(null);
            this.fxTypeLabel.setBounds(11, 18, 35, 18);
            this.fxTypeLabel.setText("Type:");
            this.fxTypeValue.setBounds(54, 18, 135, 18);
            this.fxTypeValue.setText("");
            this.fileInfoPanel.setSize(272, 209);
            this.fileInfoPanel.setLocation(114, 19);
            this.fileInfoPanel.setBorder(BorderFactory.createTitledBorder(null, "File info", 0, 0, null, null));
            this.fxHrefLabel.setBounds(11, 44, 35, 18);
            this.fxHrefLabel.setText("Href:");
            this.fxDescLabel.setBounds(11, 70, 78, 18);
            this.fxDescLabel.setText("Description:");
            this.fileInfoPanel.add((Component)this.fxTypeLabel, null);
            this.fileInfoPanel.add((Component)this.fxTypeValue, null);
            this.fileInfoPanel.add((Component)this.fxHrefLabel, null);
            this.fileInfoPanel.add((Component)this.getFxHrefTextField(), null);
            this.fileInfoPanel.add((Component)this.fxDescLabel, null);
            this.fileInfoPanel.add((Component)this.getFxEditButton(), null);
            this.fileInfoPanel.add((Component)this.getCardsPanel(), null);
        }
        return this.fileInfoPanel;
    }

    private JPanel getFilesPanel() {
        if (this.filesPanel == null) {
            this.filesPanel = new JPanel();
            this.filesPanel.setLayout(null);
            this.filesPanel.setBorder(BorderFactory.createTitledBorder(null, "Files", 0, 0, null, null));
            this.filesPanel.setBounds(5, 146, 390, 232);
            this.filesPanel.add((Component)this.getJScrollPane(), null);
            this.filesPanel.add((Component)this.getFileInfoPanel(), null);
        }
        return this.filesPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getFilesTree());
            this.jScrollPane.setBounds(6, 19, 101, 208);
            this.jScrollPane.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        return this.jScrollPane;
    }

    private JTextArea getFxDescTextArea() {
        if (this.fxDescTextArea == null) {
            this.fxDescTextArea = new JTextArea();
            this.fxDescTextArea.setEditable(false);
            this.fxDescTextArea.setForeground(Color.gray);
            this.fxDescTextArea.setLineWrap(true);
        }
        return this.fxDescTextArea;
    }

    private JTextField getFxHrefTextField() {
        if (this.fxHrefTextField == null) {
            this.fxHrefTextField = new JTextField();
            this.fxHrefTextField.setBounds(54, 44, 209, 18);
            this.fxHrefTextField.setEditable(false);
            this.fxHrefTextField.setForeground(Color.gray);
        }
        return this.fxHrefTextField;
    }

    private JButton getFxEditButton() {
        if (this.fxEditButton == null) {
            this.fxEditButton = new JButton(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setEnabled(boolean value) {
                    if (!value) {
                        super.setEnabled(false);
                    } else {
                        super.setEnabled(value);
                    }
                }
            };
            this.fxEditButton.setBounds(180, 74, 74, 16);
            this.fxEditButton.setText("Edit");
            this.fxEditButton.setEnabled(false);
            this.fxEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!new File(VehicleInfo.this.fxHrefTextField.getText()).exists()) {
                        JOptionPane.showMessageDialog(VehicleInfo.this.fxEditButton, "The file doesn't exists!");
                        return;
                    }
                    if (new File(VehicleInfo.this.fxHrefTextField.getText()).isDirectory()) {
                        JOptionPane.showMessageDialog(VehicleInfo.this.fxEditButton, "Cannot edit a directory!");
                        return;
                    }
                    if (VehicleInfo.this.editableInfo) {
                        short edType;
                        EditorLauncher ed = new EditorLauncher();
                        if ("xml".equals(VehicleInfo.this.fxTypeValue.getText()) | "xslt".equals(VehicleInfo.this.fxTypeValue.getText()) | "xsl".equals(VehicleInfo.this.fxTypeValue.getText())) {
                            ed.getClass();
                            edType = 1;
                        } else {
                            ed.getClass();
                            edType = 0;
                        }
                        boolean rsb = ed.editFile(VehicleInfo.this.fxHrefTextField.getText(), edType, false);
                        NeptusLog.pub().info((Object)("<###>>" + rsb));
                    } else {
                        TextViewer.showFileViewerDialog(SwingUtilities.getWindowAncestor(VehicleInfo.this), VehicleInfo.this.fxHrefTextField.getText());
                    }
                }
            });
        }
        return this.fxEditButton;
    }

    private JTextField getDimTextField() {
        if (this.dimTextField == null) {
            this.dimTextField = new JTextField();
            this.dimTextField.setBounds(267, 105, 117, 17);
            this.dimTextField.setEditable(false);
            this.dimTextField.setText(this.vehicle.getXSize() + " x " + this.vehicle.getYSize() + " x " + this.vehicle.getZSize());
            this.dimTextField.setToolTipText("Length/Width/Height");
        }
        return this.dimTextField;
    }

    private JScrollPane getFxDescScrollPane() {
        if (this.fxDescScrollPane == null) {
            this.fxDescScrollPane = new JScrollPane();
            this.fxDescScrollPane.setBounds(0, 0, 249, 109);
            this.fxDescScrollPane.setViewportView(this.getFxDescTextArea());
            this.fxDescScrollPane.setVerticalScrollBarPolicy(20);
            this.fxDescScrollPane.setHorizontalScrollBarPolicy(30);
        }
        return this.fxDescScrollPane;
    }

    private CoordinateSystemPanel getCoordinateSystemPanel() {
        if (this.coordinateSystemPanel == null) {
            if (this.coordinateSystem == null) {
                this.coordinateSystemPanel = new CoordinateSystemPanel(this.vehicle.getCoordinateSystem());
                this.coordinateSystemPanel.setChangeHomeVisible(false);
            } else {
                this.coordinateSystemPanel = new CoordinateSystemPanel(this.coordinateSystem);
                this.coordinateSystemPanel.setChangeHomeVisible(true);
            }
            this.coordinateSystemPanel.setPreferredSize(new Dimension(100, 16));
            this.coordinateSystemPanel.setEditable(false);
        }
        return this.coordinateSystemPanel;
    }

    private JPanel getAttitudePanel() {
        if (this.attitudePanel == null) {
            this.attitudePanel = new JPanel();
            this.attitudePanel.setLayout(new BorderLayout());
            this.attitudePanel.setBounds(5, 387, 390, 121);
            this.attitudePanel.setBorder(BorderFactory.createTitledBorder(null, "Inertial Coordinate System", 0, 0, null, null));
            this.attitudePanel.add((Component)this.getCoordinateSystemPanel(), "Center");
        }
        return this.attitudePanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setPreferredSize(new Dimension(90, 28));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoordinateSystem cs = VehicleInfo.this.getCoordinateSystemPanel().getCoordinateSystem();
                    VehicleInfo.this.coordinateSystem.setCoordinateSystem(cs);
                    VehicleInfo.this.closeFrame();
                }
            });
        }
        return this.okButton;
    }

    private void closeFrame() {
        Container hier = this.getOkPanel();
        while (!(hier instanceof JFrame) && !(hier instanceof JInternalFrame)) {
            hier = ((JComponent)hier).getParent();
        }
        if (hier instanceof JFrame) {
            ((JFrame)hier).dispose();
        } else if (hier instanceof JInternalFrame) {
            ((JInternalFrame)hier).dispose();
        }
    }

    private JPanel getOkPanel() {
        if (this.okPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.okPanel = new JPanel();
            this.okPanel.setLayout(flowLayout1);
            this.okPanel.setBounds(8, 518, 387, 42);
            flowLayout1.setAlignment(2);
            this.okPanel.add((Component)this.getOkButton(), null);
            this.okPanel.add((Component)this.getCancelButton(), null);
        }
        return this.okPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setPreferredSize(new Dimension(90, 28));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleInfo.this.closeFrame();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getCardsPanel() {
        if (this.cardsPanel == null) {
            this.cardsPanel = new JPanel();
            this.cardsPanel.setLayout(new CardLayout());
            this.cardsPanel.setBounds(10, 92, 252, 111);
            this.cardsPanel.add((Component)this.getCard1(), this.getCard1().getName());
            this.cardsPanel.add((Component)this.getCard2(), this.getCard2().getName());
        }
        return this.cardsPanel;
    }

    private JPanel getCard1() {
        if (this.card1 == null) {
            this.card1 = new JPanel();
            this.card1.setLayout(null);
            this.card1.setName("card1");
            this.card1.add((Component)this.getFxDescScrollPane(), null);
        }
        return this.card1;
    }

    private JPanel getCard2() {
        if (this.card2 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel = new JLabel();
            this.card2 = new JPanel();
            this.card2.setLayout(null);
            this.card2.setName("card2");
            this.jLabel.setBounds(3, 68, 48, 16);
            this.jLabel.setText("Params:");
            this.jLabel1.setBounds(3, 91, 48, 16);
            this.jLabel1.setText("Output:");
            this.card2.add((Component)this.getJScrollPane1(), null);
            this.card2.add((Component)this.getFxParamXsltTextField(), null);
            this.card2.add((Component)this.getFxOutputFileTextField(), null);
            this.card2.add((Component)this.jLabel, null);
            this.card2.add((Component)this.jLabel1, null);
        }
        return this.card2;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBounds(0, 0, 252, 64);
            this.jScrollPane1.setViewportView(this.getFxDescTextArea2());
        }
        return this.jScrollPane1;
    }

    private JTextArea getFxDescTextArea2() {
        if (this.fxDescTextArea2 == null) {
            this.fxDescTextArea2 = new JTextArea();
            this.fxDescTextArea2.setEditable(false);
            this.fxDescTextArea2.setForeground(Color.gray);
            this.fxDescTextArea2.setLineWrap(false);
        }
        return this.fxDescTextArea2;
    }

    private JTextField getFxParamXsltTextField() {
        if (this.fxParamXsltTextField == null) {
            this.fxParamXsltTextField = new JTextField();
            this.fxParamXsltTextField.setBounds(57, 68, 192, 18);
            this.fxParamXsltTextField.setEditable(false);
            this.fxParamXsltTextField.setForeground(Color.gray);
        }
        return this.fxParamXsltTextField;
    }

    private JTextField getFxOutputFileTextField() {
        if (this.fxOutputFileTextField == null) {
            this.fxOutputFileTextField = new JTextField();
            this.fxOutputFileTextField.setBounds(57, 91, 191, 18);
            this.fxOutputFileTextField.setEditable(false);
            this.fxOutputFileTextField.setForeground(Color.gray);
        }
        return this.fxOutputFileTextField;
    }

    public VehicleMission getVehicleMission() {
        VehicleMission vm = new VehicleMission();
        vm.setCoordinateSystem(this.getCoordinateSystemPanel().getCoordinateSystem());
        vm.setId(this.vehicle.getId());
        vm.setName(this.vehicle.getName());
        vm.setVehicle(this.vehicle);
        return vm;
    }

    private JButton getViewer3DButton() {
        if (this.viewer3DButton == null) {
            this.viewer3DButton = new JButton();
            this.viewer3DButton.setText("3D model");
            this.viewer3DButton.setBounds(new Rectangle(8, 111, 85, 15));
            this.viewer3DButton.setFont(new Font("Dialog", 1, 10));
            this.viewer3DButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleInfo.this.viewer3DButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            try {
                                Object3DCreationHelper.open3DViewerDialogForModelPath(VehicleInfo.this, VehicleInfo.this.vehicle.getName(), VehicleInfo.this.vehicle.getModel3DHref());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            catch (Error e) {
                                e.printStackTrace();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            VehicleInfo.this.viewer3DButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.viewer3DButton;
    }

    @Override
    public DefaultProperty[] getProperties() {
        LinkedList<DefaultProperty> propertiesList = new LinkedList<DefaultProperty>();
        DefaultProperty comP = PropertiesEditor.getPropertyInstance("icon color", "Properties", Color.class, this.vehicle.getIconColor(), true);
        propertiesList.add(comP);
        String categoryBase = "Base";
        String protocolsStringBase = "";
        for (String protocol : this.vehicle.getProtocols()) {
            protocolsStringBase = protocolsStringBase + protocol + " ";
        }
        comP = PropertiesEditor.getPropertyInstance("protocols suported", categoryBase, String.class, protocolsStringBase, false);
        propertiesList.add(comP);
        if ((CommUtil.isProtocolSupported(this.vehicle.getId(), "ssh") || CommUtil.isProtocolSupported(this.vehicle.getId(), "telnet")) && !this.vehicle.getProtocolsArgs().containsKey("time-shell")) {
            this.vehicle.getProtocolsArgs().put("time-shell", new AdjustTimeShellArgs());
        }
        for (ProtocolArgs pArgs : this.vehicle.getProtocolsArgs().values()) {
            if (pArgs instanceof IMCArgs) {
                IMCArgs nArgs = (IMCArgs)pArgs;
                comP = PropertiesEditor.getPropertyInstance("imc.port", categoryBase, Integer.class, new Integer(nArgs.getPort()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("imc.portTCP", categoryBase, Integer.class, new Integer(nArgs.getPortTCP()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("imc.udp-on", categoryBase, Boolean.class, new Boolean(nArgs.isUdpOn()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("imc.tcp-on", categoryBase, Boolean.class, new Boolean(nArgs.isTcpOn()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("imc.imc3-id", categoryBase, ImcId16.class, nArgs.getImc3Id() == null ? ImcId16.NULL_ID : nArgs.getImc3Id(), true);
                propertiesList.add(comP);
                continue;
            }
            if (pArgs instanceof AdjustTimeShellArgs) {
                AdjustTimeShellArgs tArgs = (AdjustTimeShellArgs)pArgs;
                comP = PropertiesEditor.getPropertyInstance("time-shell.set-seconds", categoryBase, Boolean.class, new Boolean(tArgs.isSetSeconds()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("time-shell.set-year", categoryBase, Boolean.class, new Boolean(tArgs.isSetYear()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("time-shell.use-2-digit-year", categoryBase, Boolean.class, new Boolean(tArgs.isUse2DigitYear()), true);
                propertiesList.add(comP);
                comP = PropertiesEditor.getPropertyInstance("time-shell.use-hwclock", categoryBase, Boolean.class, new Boolean(tArgs.isUseHwClock()), true);
                propertiesList.add(comP);
                continue;
            }
            if (pArgs instanceof FTPArgs) {
                FTPArgs fArgs = (FTPArgs)pArgs;
                comP = PropertiesEditor.getPropertyInstance("ftp", categoryBase, String.class, new String("transfer mode = " + fArgs.getTransferMode() + ", connection mode = " + fArgs.getConnectionMode()), false);
                propertiesList.add(comP);
                continue;
            }
            if (!(pArgs instanceof PropertiesProvider)) continue;
            for (DefaultProperty prop : ((PropertiesProvider)((Object)pArgs)).getProperties()) {
                prop.setCategory(((PropertiesProvider)((Object)pArgs)).getPropertiesDialogTitle());
                propertiesList.add(prop);
            }
        }
        for (CommMean cm : this.vehicle.getCommunicationMeans().values()) {
            String category = cm.getName();
            comP = PropertiesEditor.getPropertyInstance("host name", category, String.class, new String(cm.getHostAddress()), true);
            propertiesList.add(comP);
            comP = PropertiesEditor.getPropertyInstance("user name", category, String.class, new String(cm.getUserName()), true);
            propertiesList.add(comP);
            comP = PropertiesEditor.getPropertyInstance("is password saved", category, Boolean.class, new Boolean(cm.isPasswordSaved()), true);
            propertiesList.add(comP);
            String protocolsString = "";
            for (String protocol : cm.getProtocols()) {
                protocolsString = protocolsString + protocol + " ";
            }
            comP = PropertiesEditor.getPropertyInstance("protocols suported", category, String.class, protocolsString, false);
            propertiesList.add(comP);
            comP = PropertiesEditor.getPropertyInstance("latency", category, String.class, new String(cm.getLatency() + " " + cm.getLatencyUnit()), false);
            propertiesList.add(comP);
            for (ProtocolArgs pArgs : cm.getProtocolsArgs().values()) {
                if (pArgs instanceof IMCArgs) {
                    IMCArgs nArgs = (IMCArgs)pArgs;
                    comP = PropertiesEditor.getPropertyInstance("imc.port", category, Integer.class, new Integer(nArgs.getPort()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("imc.portTCP", category, Integer.class, new Integer(nArgs.getPortTCP()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("imc.udp-on", category, Boolean.class, new Boolean(nArgs.isUdpOn()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("imc.tcp-on", category, Boolean.class, new Boolean(nArgs.isTcpOn()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("imc.imc3-id", category, ImcId16.class, nArgs.getImc3Id() == null ? ImcId16.NULL_ID : nArgs.getImc3Id(), true);
                    propertiesList.add(comP);
                    continue;
                }
                if (pArgs instanceof AdjustTimeShellArgs) {
                    AdjustTimeShellArgs tArgs = (AdjustTimeShellArgs)pArgs;
                    comP = PropertiesEditor.getPropertyInstance("time-shell.set-seconds", categoryBase, Boolean.class, new Boolean(tArgs.isSetSeconds()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("time-shell.set-year", categoryBase, Boolean.class, new Boolean(tArgs.isSetYear()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("time-shell.use-2-digit-year", categoryBase, Boolean.class, new Boolean(tArgs.isUse2DigitYear()), true);
                    propertiesList.add(comP);
                    comP = PropertiesEditor.getPropertyInstance("time-shell.set-year", categoryBase, Boolean.class, new Boolean(tArgs.isUseHwClock()), true);
                    propertiesList.add(comP);
                    continue;
                }
                if (!(pArgs instanceof FTPArgs)) continue;
                FTPArgs fArgs = (FTPArgs)pArgs;
                comP = PropertiesEditor.getPropertyInstance("ftp", category, String.class, new String("transfer mode = " + fArgs.getTransferMode() + ", connection mode = " + fArgs.getConnectionMode()), false);
                propertiesList.add(comP);
            }
        }
        for (String id : this.vehicle.getTransformationXSLTTemplates().keySet()) {
            TemplateFileVehicle tfile = this.vehicle.getTransformationXSLTTemplates().get(id);
            String category = id + ":" + tfile.getName() + " parameters";
            for (String param : tfile.getParametersToPassList().keySet()) {
                String value = tfile.getParametersToPassList().get(param);
                comP = PropertiesEditor.getPropertyInstance(param, category, String.class, value, true);
                propertiesList.add(comP);
            }
        }
        DefaultProperty[] prop = new DefaultProperty[propertiesList.size()];
        return propertiesList.toArray(prop);
    }

    @Override
    public void setProperties(Property[] properties) {
        LinkedHashMap<String, String> transFilesList = new LinkedHashMap<String, String>();
        for (String id : this.vehicle.getTransformationXSLTTemplates().keySet()) {
            TemplateFileVehicle tfile = this.vehicle.getTransformationXSLTTemplates().get(id);
            String category = id + ":" + tfile.getName() + " parameters";
            transFilesList.put(category, id);
        }
        for (Property prop : properties) {
            String idTFile;
            CommMean cm;
            String cat = prop.getCategory();
            if ("Properties".equalsIgnoreCase(cat) && prop.getName().equals("icon color")) {
                this.vehicle.setIconColor((Color)prop.getValue());
            }
            if ("Base".equalsIgnoreCase(cat)) {
                for (String protocol : this.vehicle.getProtocolsArgs().keySet()) {
                    ProtocolArgs protoArgs;
                    if (!prop.getName().startsWith(protocol)) continue;
                    if (protocol.equalsIgnoreCase("imc")) {
                        protoArgs = this.vehicle.getProtocolsArgs().get(protocol);
                        if (protoArgs == null) continue;
                        if (prop.getName().equals("imc.port")) {
                            ((IMCArgs)protoArgs).setPort((Integer)prop.getValue());
                            continue;
                        }
                        if (prop.getName().equals("imc.portTCP")) {
                            ((IMCArgs)protoArgs).setPortTCP((Integer)prop.getValue());
                            continue;
                        }
                        if (prop.getName().equals("imc.udp-on")) {
                            ((IMCArgs)protoArgs).setUdpOn((Boolean)prop.getValue());
                            continue;
                        }
                        if (prop.getName().equals("imc.tcp-on")) {
                            ((IMCArgs)protoArgs).setTcpOn((Boolean)prop.getValue());
                            continue;
                        }
                        if (!prop.getName().equals("imc.imc3-id")) continue;
                        ((IMCArgs)protoArgs).setImc3Id((ImcId16)prop.getValue());
                        continue;
                    }
                    if (!protocol.equalsIgnoreCase("time-shell") || (protoArgs = this.vehicle.getProtocolsArgs().get(protocol)) == null) continue;
                    if (prop.getName().equals("time-shell.set-seconds")) {
                        ((AdjustTimeShellArgs)protoArgs).setSetSeconds((Boolean)prop.getValue());
                        continue;
                    }
                    if (prop.getName().equals("time-shell.set-year")) {
                        ((AdjustTimeShellArgs)protoArgs).setSetYear((Boolean)prop.getValue());
                        continue;
                    }
                    if (prop.getName().equals("time-shell.use-2-digit-year")) {
                        ((AdjustTimeShellArgs)protoArgs).setUse2DigitYear((Boolean)prop.getValue());
                        continue;
                    }
                    if (!prop.getName().equals("time-shell.use-hwclock")) continue;
                    ((AdjustTimeShellArgs)protoArgs).setUseHwClock((Boolean)prop.getValue());
                }
            }
            if ((cm = this.vehicle.getCommunicationMeans().get(cat)) != null) {
                if (prop.getName().equals("host name")) {
                    cm.setHostAddress((String)prop.getValue());
                } else if (prop.getName().equals("user name")) {
                    cm.setUserName((String)prop.getValue());
                } else if (prop.getName().equals("is password saved")) {
                    cm.setPasswordSaved((Boolean)prop.getValue());
                } else {
                    for (String protocol : cm.getProtocolsArgs().keySet()) {
                        ProtocolArgs protoArgs;
                        if (!prop.getName().startsWith(protocol)) continue;
                        if (protocol.equalsIgnoreCase("imc")) {
                            protoArgs = cm.getProtocolsArgs().get(protocol);
                            if (protoArgs == null) continue;
                            if (prop.getName().equals("imc.port")) {
                                ((IMCArgs)protoArgs).setPort((Integer)prop.getValue());
                                continue;
                            }
                            if (prop.getName().equals("imc.portTCP")) {
                                ((IMCArgs)protoArgs).setPortTCP((Integer)prop.getValue());
                                continue;
                            }
                            if (prop.getName().equals("imc.udp-on")) {
                                ((IMCArgs)protoArgs).setUdpOn((Boolean)prop.getValue());
                                continue;
                            }
                            if (prop.getName().equals("imc.tcp-on")) {
                                ((IMCArgs)protoArgs).setTcpOn((Boolean)prop.getValue());
                                continue;
                            }
                            if (!prop.getName().equals("imc.imc3-id")) continue;
                            ((IMCArgs)protoArgs).setImc3Id((ImcId16)prop.getValue());
                            continue;
                        }
                        if (!protocol.equalsIgnoreCase("time-shell") || (protoArgs = cm.getProtocolsArgs().get(protocol)) == null) continue;
                        if (prop.getName().equals("time-shell.set-seconds")) {
                            ((AdjustTimeShellArgs)protoArgs).setSetSeconds((Boolean)prop.getValue());
                            continue;
                        }
                        if (prop.getName().equals("time-shell.set-year")) {
                            ((AdjustTimeShellArgs)protoArgs).setSetYear((Boolean)prop.getValue());
                            continue;
                        }
                        if (prop.getName().equals("time-shell.use-2-digit-year")) {
                            ((AdjustTimeShellArgs)protoArgs).setUse2DigitYear((Boolean)prop.getValue());
                            continue;
                        }
                        if (!prop.getName().equals("time-shell.use-hwclock")) continue;
                        ((AdjustTimeShellArgs)protoArgs).setUseHwClock((Boolean)prop.getValue());
                    }
                }
            }
            if ((idTFile = (String)transFilesList.get(cat)) == null) continue;
            TemplateFileVehicle tFile = this.vehicle.getTransformationXSLTTemplates().get(idTFile);
            tFile.getParametersToPassList().put(prop.getName(), (String)prop.getValue());
        }
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Vehicle properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    private JButton getPropertiesButton() {
        if (this.propertiesButton == null) {
            this.propertiesButton = new JButton();
            this.propertiesButton.setBounds(new Rectangle(95, 111, 85, 15));
            this.propertiesButton.setFont(new Font("Dialog", 1, 10));
            this.propertiesButton.setText("Properties");
            this.propertiesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!PropertiesEditor.editProperties((PropertiesProvider)VehicleInfo.this, SwingUtilities.getWindowAncestor(VehicleInfo.this), true)) {
                        String filePath = VehicleInfo.this.vehicle.getOriginalFilePath();
                        Document doc = VehicleInfo.this.vehicle.asDocument();
                        String dataToSave = FileUtil.getAsPrettyPrintFormatedXMLString(doc);
                        FileUtil.saveToFile(filePath, dataToSave);
                    }
                    try {
                        ImcMsgManager.getManager().stop();
                        Thread.sleep(100L);
                        ImcMsgManager.getManager().start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.propertiesButton;
    }

    private JButton getOpenConsolesButton() {
        if (this.openConsolesButton == null) {
            this.openConsolesButton = new JButton();
            this.openConsolesButton.setFont(new Font("Dialog", 1, 10));
            this.openConsolesButton.setBounds(new Rectangle(116, 63, 80, 15));
            this.openConsolesButton.setText("Consoles");
            this.openConsolesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehiclesHolder.showConsole(VehicleInfo.this.vehicle, VehicleInfo.this);
                }
            });
        }
        return this.openConsolesButton;
    }

    private JPanel getModelPanel() {
        if (this.modelPanel == null) {
            this.modelValue = new JLabel();
            this.modelValue.setForeground(Color.darkGray);
            this.modelValue.setText(this.vehicle.getModel());
            this.modelLabel = new JLabel();
            this.modelLabel.setText("Model:");
            FlowLayout flowLayout41 = new FlowLayout();
            flowLayout41.setHgap(5);
            flowLayout41.setAlignment(0);
            flowLayout41.setVgap(1);
            this.modelPanel = new JPanel();
            this.modelPanel.setLocation(new Point(0, 44));
            this.modelPanel.setSize(new Dimension(200, 18));
            this.modelPanel.setLayout(flowLayout41);
            this.modelPanel.add((Component)this.modelLabel, null);
            this.modelPanel.add((Component)this.modelValue, null);
        }
        return this.modelPanel;
    }
}

