/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class VehicleSelectionDialog
extends JPanel {
    private static final long serialVersionUID = 1146328105007254093L;
    protected boolean canceled = true;
    protected Vector<String> selection = new Vector();
    protected String[] oldSelection = null;

    protected void setSelection(String[] selectedIds) {
        this.oldSelection = selectedIds;
        this.selection.clear();
        if (selectedIds != null) {
            for (String s : selectedIds) {
                this.selection.add(s.toLowerCase());
            }
        }
    }

    public String[] getSelection() {
        if (this.canceled) {
            return this.oldSelection;
        }
        return this.selection.toArray(new String[0]);
    }

    protected JPanel getVehiclesPanel() {
        JPanel vehicles = new JPanel();
        vehicles.setLayout(new GridLayout(0, 1));
        vehicles.setBackground(Color.white);
        Object[] allVehicles = VehiclesHolder.getVehiclesArray();
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                if (VehicleSelectionDialog.this.selection.contains(source.getText())) {
                    VehicleSelectionDialog.this.selection.remove(source.getText());
                } else {
                    VehicleSelectionDialog.this.selection.add(source.getText());
                }
            }
        };
        Arrays.sort(allVehicles);
        for (Object v : allVehicles) {
            try {
                JToggleButton check = new JToggleButton((String)v, new ImageIcon(ImageUtils.getImage(VehiclesHolder.getVehicleById((String)v).getPresentationImageHref()).getScaledInstance(16, 16, 1)), this.selection.contains(v));
                vehicles.add(check);
                check.addChangeListener(cl);
                check.setBackground(Color.white);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        return vehicles;
    }

    public static String[] showSelectionDialog(Window owner, VehicleType[] initialSelection) {
        String[] vehicles = new String[initialSelection.length];
        for (int i = 0; i < initialSelection.length; ++i) {
            vehicles[i] = initialSelection[i].getId();
        }
        return VehicleSelectionDialog.showSelectionDialog(owner, vehicles);
    }

    public static String[] showSelectionDialog(Window owner, String[] initialSelection) {
        JDialog dialog = owner == null ? new JDialog((Frame)ConfigFetch.getSuperParentFrame()) : new JDialog(owner);
        VehicleSelectionDialog vs = new VehicleSelectionDialog(initialSelection);
        dialog.getContentPane().add(vs);
        dialog.setSize(500, 300);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        GuiUtils.centerOnScreen(dialog);
        dialog.setVisible(true);
        return vs.getSelection();
    }

    public VehicleSelectionDialog() {
        this(new String[0]);
    }

    public VehicleSelectionDialog(String[] initialSelection) {
        this.setSelection(initialSelection);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(new JScrollPane(this.getVehiclesPanel()));
        JButton btnOk = new JButton(I18n.text("OK"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VehicleSelectionDialog.this.canceled = false;
                SwingUtilities.getWindowAncestor((JButton)arg0.getSource()).dispose();
            }
        });
        JButton btnCancel = new JButton(I18n.text("Cancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VehicleSelectionDialog.this.canceled = true;
                SwingUtilities.getWindowAncestor((JButton)arg0.getSource()).dispose();
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(btnOk, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(btnCancel, -2, 85, -2)).addComponent(mainPanel, -1, 426, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(mainPanel, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(btnOk, -1, -1, Short.MAX_VALUE).addComponent(btnCancel, -1, 31, Short.MAX_VALUE)).addGap(9)));
        this.setLayout(groupLayout);
    }

    public static void main(String[] args) {
        String[] sel;
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        JFrame f = GuiUtils.testFrame(new VehicleSelectionDialog());
        for (String s : sel = VehicleSelectionDialog.showSelectionDialog((Window)f, new String[]{"Isurus", "NAUV"})) {
            NeptusLog.pub().info((Object)("<###> " + s));
        }
    }
}

