/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class WaitPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -8115526495271837748L;
    private JProgressBar progressBar = null;
    private JDialog jDialog = null;
    private JPanel dialogContentPane = null;
    private JFrame jFrame = null;
    private JPanel frameContentPane = null;
    private Window parentComponent = null;
    private Dialog.ModalityType modalityType = Dialog.ModalityType.MODELESS;
    private Thread loaderThread;
    private JLabel jLabel = null;
    private boolean forceRepaint = false;

    public WaitPanel() {
        this.initialize();
    }

    public WaitPanel(boolean forceRepaint) {
        this.forceRepaint = forceRepaint;
        this.initialize();
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (WaitPanel.this.forceRepaint) {
                        RepaintManager rpm = RepaintManager.currentManager(WaitPanel.this.getProgressBar());
                        rpm.markCompletelyDirty(WaitPanel.this.getProgressBar());
                        rpm.paintDirtyRegions();
                    } else {
                        WaitPanel.this.repaint();
                    }
                }
            });
            this.progressBar.setIndeterminate(true);
        }
        return this.progressBar;
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            if (this.parentComponent == null) {
                this.jDialog = new JDialog();
            } else if (this.parentComponent instanceof JDialog) {
                this.jDialog = new JDialog((JDialog)this.parentComponent);
            } else if (this.parentComponent instanceof JFrame) {
                this.jDialog = new JDialog((JFrame)this.parentComponent);
            }
            this.jDialog.setContentPane(this.getDialogContentPane());
            this.jDialog.setUndecorated(true);
            this.jDialog.setModal(true);
            this.jDialog.setAlwaysOnTop(true);
        }
        return this.jDialog;
    }

    private JPanel getDialogContentPane() {
        if (this.dialogContentPane == null) {
            this.dialogContentPane = new JPanel();
            this.dialogContentPane.setLayout(new BorderLayout());
        }
        return this.dialogContentPane;
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setTitle("Wait please...");
            this.jFrame.setDefaultCloseOperation(2);
            this.jFrame.setContentPane(this.getFrameContentPane());
            this.jFrame.setUndecorated(true);
            this.jFrame.setIconImages(ConfigFetch.getIconImagesForFrames());
            this.jFrame.setAlwaysOnTop(true);
        }
        return this.jFrame;
    }

    private JPanel getFrameContentPane() {
        if (this.frameContentPane == null) {
            this.frameContentPane = new JPanel();
            this.frameContentPane.setLayout(new BorderLayout());
        }
        return this.frameContentPane;
    }

    public String getText() {
        return this.jLabel.getText();
    }

    public void setText(String text) {
        this.jLabel.setText(text);
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.jLabel.setText("Wait please...");
        this.jLabel.setBackground(new Color(250, 250, 250));
        this.jLabel.setOpaque(true);
        this.jLabel.setForeground(new Color(164, 164, 164));
        this.jLabel.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.setSize(242, 30);
        this.setPreferredSize(new Dimension(242, 30));
        this.add((Component)this.getProgressBar(), "Center");
        this.add((Component)this.jLabel, "North");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int ret = JOptionPane.showConfirmDialog(WaitPanel.this, "Close this wait panel?", "Wait Panel", 0);
                    switch (ret) {
                        case 0: {
                            WaitPanel.this.stop();
                            break;
                        }
                    }
                }
            }
        });
    }

    public boolean start() {
        if (this.loaderThread != null) {
            return false;
        }
        this.loaderThread = new Thread(this);
        this.loaderThread.setPriority(10);
        this.parentComponent = null;
        this.loaderThread.start();
        return true;
    }

    public boolean start(JDialog parent, boolean modal) {
        return this.start((Window)parent, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    public boolean start(JDialog parent, Dialog.ModalityType modalityType) {
        return this.start((Window)parent, modalityType);
    }

    public boolean start(JFrame parent, boolean modal) {
        return this.start((Window)parent, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    public boolean start(JFrame parent, Dialog.ModalityType modalityType) {
        return this.start((Window)parent, modalityType);
    }

    private boolean start(Window parent, Dialog.ModalityType modalityType) {
        if (this.loaderThread != null) {
            return false;
        }
        this.loaderThread = new Thread(this);
        this.parentComponent = parent;
        this.modalityType = modalityType;
        this.loaderThread.start();
        return true;
    }

    public boolean stop() {
        if (this.loaderThread == null) {
            return false;
        }
        this.loaderThread = null;
        this.getJDialog().dispose();
        this.getJFrame().dispose();
        this.jDialog = null;
        this.jFrame = null;
        return true;
    }

    @Override
    public void run() {
        if (this.parentComponent != null) {
            JDialog dialog = this.getJDialog();
            dialog.getContentPane().add(this);
            dialog.setModalityType(this.modalityType);
            dialog.pack();
            GuiUtils.centerParent(dialog, this.parentComponent);
            dialog.setVisible(true);
        } else {
            JFrame frame = this.getJFrame();
            frame.getContentPane().add(this);
            frame.pack();
            GuiUtils.centerOnScreen(frame);
            frame.setVisible(true);
        }
        while (this.isRunning() && this.forceRepaint) {
            try {
                RepaintManager rpm = RepaintManager.currentManager(this);
                rpm.markCompletelyDirty(this);
                rpm.paintDirtyRegions();
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isRunning() {
        return this.loaderThread != null;
    }

    public static void main(String[] args) throws InterruptedException {
        GuiUtils.setLookAndFeel();
        WaitPanel wait = new WaitPanel();
        JPanel panel = new JPanel();
        panel.setSize(new Dimension(123, 34));
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel("North"), "North");
        panel.add((Component)new JLabel("Center"), "Center");
        panel.add((Component)new JLabel("South"), "South");
        panel.add((Component)new JLabel("East"), "East");
        panel.add((Component)new JLabel("West"), "West");
        JFrame frame = new JFrame();
        frame.add(panel);
        frame.setSize(new Dimension(123, 34));
        frame.setDefaultCloseOperation(2);
        frame.setLocation(100, 100);
        frame.pack();
        frame.setVisible(true);
        wait.start(frame, true);
        Thread.sleep(5000L);
        wait.stop();
        wait.start();
        Thread.sleep(5000L);
        wait.stop();
    }
}

