/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ZValueSelector
extends ParametersPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<ManeuverLocation.Z_UNITS> selectorHD = null;
    private JFormattedTextField heightDepthField = null;
    private boolean editable;
    private JLabel jLabel = null;
    private boolean canceled = false;

    public ZValueSelector() {
        this.initialize();
    }

    @Override
    public String getErrors() {
        try {
            Double.parseDouble(this.getZField().getText());
        }
        catch (Exception e) {
            return "The Z parameters are not valid";
        }
        return null;
    }

    public double getZ() {
        return Double.parseDouble(this.getZField().getText());
    }

    public void setZ(double z) {
        this.getZField().setText(String.valueOf(z));
    }

    public ManeuverLocation.Z_UNITS getZUnits() {
        return (ManeuverLocation.Z_UNITS)((Object)this.selectorHD.getSelectedItem());
    }

    public void setZUnits(ManeuverLocation.Z_UNITS zunits) {
        this.selectorHD.setSelectedItem((Object)zunits);
    }

    private JComboBox<ManeuverLocation.Z_UNITS> getZUnitsCombo() {
        if (this.selectorHD == null) {
            this.selectorHD = new ZUnitsComboBox();
            this.selectorHD.setPreferredSize(new Dimension(90, 20));
        }
        return this.selectorHD;
    }

    private JTextField getZField() {
        if (this.heightDepthField == null) {
            this.heightDepthField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat());
            this.heightDepthField.setColumns(7);
            this.heightDepthField.addFocusListener(new SelectAllFocusListener());
        }
        return this.heightDepthField;
    }

    public static void main(String[] args) throws Exception {
        ManeuverLocation loc = new ManeuverLocation();
        loc.setZ(10.0);
        ZValueSelector.showHeightDepthDialog(null, loc, "Set plan depth / altitude");
        NeptusLog.pub().info((Object)("<###> " + loc.asXML()));
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.setLayout(new FlowLayout());
        this.setBounds(0, 0, 204, 30);
        this.jLabel.setText("m ");
        this.add((Component)this.getZField(), null);
        this.add((Component)this.jLabel, null);
        this.add(this.getZUnitsCombo(), null);
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
        this.getZUnitsCombo().setEnabled(this.editable);
        this.getZField().setEditable(this.editable);
    }

    public static boolean showHeightDepthDialog(JComponent parentComponent, ManeuverLocation loc, String title) {
        final ZValueSelector selector = new ZValueSelector();
        selector.setZ(loc.getZ());
        selector.setZUnits(loc.getZUnits());
        selector.setBorder(new TitledBorder(I18n.text("Value for Z")));
        Window parent = parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent);
        final JDialog dialog = new JDialog(parent == null ? ConfigFetch.getSuperParentAsFrame() : parent);
        dialog.setLocationRelativeTo(dialog.getParent());
        JButton btnOk = new JButton(I18n.text("OK"));
        btnOk.setPreferredSize(new Dimension(86, 24));
        JButton btnCancel = new JButton(I18n.text("Cancel"));
        btnCancel.setPreferredSize(new Dimension(86, 24));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selector.canceled = true;
                dialog.dispose();
            }
        });
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)selector, "Center");
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setSize(300, 120);
        JPanel controls = new JPanel(new FlowLayout(2));
        controls.add(btnOk);
        controls.add(btnCancel);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.add((Component)controls, "South");
        dialog.setVisible(true);
        if (!selector.canceled) {
            loc.setZ(selector.getZ());
            loc.setZUnits(selector.getZUnits());
        }
        return !selector.canceled;
    }

    public class ZUnitsComboBox
    extends JComboBox<ManeuverLocation.Z_UNITS> {
        public ZUnitsComboBox() {
            super(ManeuverLocation.Z_UNITS.values());
            this.setRenderer(new ListCellRenderer<ManeuverLocation.Z_UNITS>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends ManeuverLocation.Z_UNITS> list, ManeuverLocation.Z_UNITS value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = new JLabel(I18n.text(value.toString()));
                    label.setOpaque(true);
                    if (isSelected) {
                        label.setBackground(list.getSelectionBackground());
                        label.setForeground(list.getSelectionForeground());
                    } else {
                        label.setBackground(list.getBackground());
                        label.setForeground(list.getForeground());
                    }
                    return label;
                }
            });
        }
    }
}

