/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.CheckSubItem;
import pt.lsts.neptus.gui.checklist.UserActionItem;
import pt.lsts.neptus.gui.checklist.UserCommentItem;
import pt.lsts.neptus.gui.checklist.VariableIntervalItem;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;

public class AutoItemsList
extends JPanel {
    private static final long serialVersionUID = -7753351429507075143L;
    private static final ImageIcon ICON_ADD = new ImageIcon(ImageUtils.getScaledImage("images/checklists/add.png", 16, 16));
    private JComboBox<?> optionsList = null;
    private String[] optionsListString;
    private JButton addAutoCheckItem = null;
    private CheckItemPanel parentCheckItemPanel;

    public AutoItemsList(CheckItemPanel p) {
        this.parentCheckItemPanel = p;
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.addAutoCheckItem = new JButton(I18n.text("Add"), ICON_ADD);
        this.addAutoCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int Selection = AutoItemsList.this.getOptionsList().getSelectedIndex();
                if (Selection == 2) {
                    AutoItemsList.this.add(new VariableIntervalItem(AutoItemsList.this));
                } else if (Selection == 0) {
                    AutoItemsList.this.add(new UserActionItem(AutoItemsList.this));
                } else if (Selection == 1) {
                    AutoItemsList.this.add(new UserCommentItem(AutoItemsList.this));
                }
                AutoItemsList.this.repaintCheck();
                AutoItemsList.this.fireChangeEvent(AutoItemsList.this);
            }
        });
        JPanel title = new JPanel();
        title.setLayout(new FlowLayout(0));
        title.setOpaque(false);
        title.add(this.addAutoCheckItem);
        title.add(this.getOptionsList());
        this.setLayout(new BoxLayout(this, 1));
        this.add(title);
    }

    private JComboBox<?> getOptionsList() {
        if (this.optionsList == null) {
            this.optionsListString = new String[2];
            this.optionsListString[0] = I18n.text("User Action");
            this.optionsListString[1] = I18n.text("User Comment");
            this.optionsList = new JComboBox<String>(this.optionsListString);
        }
        return this.optionsList;
    }

    public void removeVarIntervalItem(VariableIntervalItem vti) {
        this.remove(vti);
        this.repaintCheck();
        this.fireChangeEvent(vti);
    }

    public void removeUserActionItem(UserActionItem uai) {
        this.remove(uai);
        this.repaintCheck();
        this.fireChangeEvent(uai);
    }

    public void removeUserCommentItem(UserCommentItem uci) {
        this.remove(uci);
        this.repaintCheck();
        this.fireChangeEvent(uci);
    }

    public void repaintCheck() {
        for (Container cmp = this.parentCheckItemPanel.getParent(); cmp != null; cmp = cmp.getParent()) {
            ((Component)cmp).doLayout();
            ((Component)cmp).invalidate();
            ((Component)cmp).validate();
        }
    }

    public int numberOfSubItems() {
        Component[] list = this.getComponents();
        int count = 0;
        for (Component c : list) {
            try {
                CheckSubItem si = (CheckSubItem)((Object)c);
                ++count;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return count;
    }

    void fireChangeEvent(Component source) {
        this.parentCheckItemPanel.fireChangeEvent(source);
    }
}

