/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.checklist.AutoItemsList;
import pt.lsts.neptus.gui.checklist.CheckSubItem;
import pt.lsts.neptus.gui.checklist.MyJTaskPaneGroup;
import pt.lsts.neptus.gui.checklist.UserActionItem;
import pt.lsts.neptus.gui.checklist.UserCommentItem;
import pt.lsts.neptus.gui.checklist.VariableIntervalItem;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;
import pt.lsts.neptus.types.checklist.CheckItem;
import pt.lsts.neptus.util.ImageUtils;

public class CheckItemPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static Icon OK_IMAGE_ICON = new ImageIcon(ImageUtils.getScaledImage("images/checklists/selectedIcon.png", 18, 18));
    public static Icon NOT_OK_IMAGE_ICON = new ImageIcon(ImageUtils.getScaledImage("images/checklists/boxIcon.png", 18, 18));
    private static final Icon EDIT_IMAGE_ICON = new ImageIcon(ImageUtils.getScaledImage("images/checklists/edit.png", 16, 16));
    public static final Color CHECK_COLOR = new Color(190, 220, 240);
    private JPanel infoPanel = null;
    private JCheckBox checkBox = null;
    private JLabel nameCheckItem = null;
    private JPanel notesPanel = null;
    private JScrollPane noteScrollPane = null;
    private JTextArea noteTextArea = null;
    private JToggleButton noteToggleButton = null;
    private JPanel buttonsPanel = null;
    private JLabel statesLabel = null;
    private JPanel actionsPanel = null;
    private AutoItemsList actionsListPanelHolder = null;
    private CheckItem checkItem = null;
    private JLabel dateChangedLabel = null;
    private JPanel datePanel = null;
    private JLabel dateLabLabel = null;
    private Date trialTime = new Date();
    private Color baseBackgroundColor = null;
    public static final SimpleDateFormat dateXMLFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.0Z'");

    public CheckItemPanel() {
        this.initialize();
    }

    public CheckItemPanel(CheckItem ci) {
        this.checkItem = ci;
        this.initialize();
        this.getCheckBox().setSelected(this.checkItem.isChecked());
        this.nameCheckItem.setText(this.checkItem.getName());
        this.getNoteTextArea().setText(this.checkItem.getNote());
        this.dateChangedLabel.setText(this.checkItem.getDateChecked());
        for (CheckAutoSubItem casi : this.checkItem.getAutoSubItems()) {
            if (casi.getSubItemType().equals("variableTestRange")) {
                this.getActionsListPanelHolder().add(new VariableIntervalItem(this.getActionsListPanelHolder(), (CheckAutoVarIntervalItem)casi));
            }
            if (casi.getSubItemType().equals("userAction")) {
                this.getActionsListPanelHolder().add(new UserActionItem(this.getActionsListPanelHolder(), (CheckAutoUserActionItem)casi));
            }
            if (!casi.getSubItemType().equals("userLog")) continue;
            this.getActionsListPanelHolder().add(new UserCommentItem(this.getActionsListPanelHolder(), (CheckAutoUserLogItem)casi));
        }
        this.fixStateLabel();
    }

    public boolean isChecked() {
        return this.getCheckBox().isSelected();
    }

    public void setChecked(boolean isChecked) {
        this.getCheckBox().setSelected(isChecked);
        this.getCheckBox().revalidate();
        this.getCheckBox().repaint();
    }

    private void initialize() {
        this.baseBackgroundColor = this.getBackground();
        this.setInheritsPopupMenu(true);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.add((Component)this.getInfoPanel(), null);
        this.add((Component)this.getNotesPanel(), null);
        this.add((Component)this.getActionsPanel(), null);
        this.addPropertyChangeListener("user change", this);
        this.fixStateLabel();
    }

    public static MyJTaskPaneGroup getMyJTaskPaneGroupFromItem(Component itemPanel) {
        try {
            MyJTaskPaneGroup mjtpg = (MyJTaskPaneGroup)((Object)itemPanel.getParent().getParent().getParent().getParent());
            return mjtpg;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.nameCheckItem = new JLabel();
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new BorderLayout());
            this.infoPanel.setOpaque(false);
            this.infoPanel.setInheritsPopupMenu(true);
            this.nameCheckItem.setText("JLabel");
            this.nameCheckItem.setPreferredSize(new Dimension(300, 16));
            this.infoPanel.add((Component)this.getCheckBox(), "West");
            this.infoPanel.add((Component)this.nameCheckItem, "Center");
            this.infoPanel.add((Component)this.getButtonsPanel(), "East");
            this.infoPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() != 3) {
                        CheckItemPanel.this.getCheckBox().doClick();
                    } else {
                        e.setSource(CheckItemPanel.this);
                        for (MouseListener ml : CheckItemPanel.this.getMouseListeners()) {
                            ml.mouseClicked(e);
                        }
                    }
                }
            });
        }
        return this.infoPanel;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new BorderLayout());
            this.buttonsPanel.setOpaque(false);
            this.buttonsPanel.setBorder(null);
            this.buttonsPanel.add((Component)this.getStatesLabel(), "West");
            this.buttonsPanel.add((Component)this.getNoteToggleButton(), "East");
        }
        return this.buttonsPanel;
    }

    public JLabel getStatesLabel() {
        if (this.statesLabel == null) {
            this.statesLabel = new JLabel();
            this.statesLabel.setForeground(CHECK_COLOR.darker().darker());
        }
        return this.statesLabel;
    }

    private void fixStateLabel() {
        String lb = " ";
        if (!"".equalsIgnoreCase(this.getNoteTextArea().getText())) {
            lb = lb + "N ";
        }
        if (this.getActionsListPanelHolder().numberOfSubItems() > 0) {
            lb = lb + "A ";
        }
        this.getStatesLabel().setText(lb);
    }

    @Override
    public void setName(String name) {
        this.nameCheckItem.setText(name);
        super.setName(name);
    }

    @Override
    public String getName() {
        if (this.nameCheckItem == null) {
            return "";
        }
        return this.nameCheckItem.getText();
    }

    private JCheckBox getCheckBox() {
        if (this.checkBox == null) {
            this.checkBox = new JCheckBox();
            this.checkBox.setIcon(NOT_OK_IMAGE_ICON);
            this.checkBox.setOpaque(false);
            this.checkBox.setText(" ");
            this.checkBox.setInheritsPopupMenu(true);
            this.checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyJTaskPaneGroup mtpg = CheckItemPanel.getMyJTaskPaneGroupFromItem(CheckItemPanel.this);
                    if (CheckItemPanel.this.getCheckBox().isSelected()) {
                        CheckItemPanel.this.setBackground(CHECK_COLOR);
                        CheckItemPanel.this.checkBox.setIcon(OK_IMAGE_ICON);
                        CheckItemPanel.this.getDatePanel().setVisible(true);
                        CheckItemPanel.this.trialTime = new Date();
                        String dateTime = dateXMLFormater.format(CheckItemPanel.this.trialTime);
                        CheckItemPanel.this.dateChangedLabel.setText(dateTime);
                        if (mtpg != null) {
                            mtpg.firePropertyChange("child item checked change", false, true);
                        }
                    } else {
                        CheckItemPanel.this.setBackground(CheckItemPanel.this.baseBackgroundColor);
                        CheckItemPanel.this.checkBox.setIcon(NOT_OK_IMAGE_ICON);
                        CheckItemPanel.this.getDatePanel().setVisible(false);
                        if (mtpg != null) {
                            mtpg.firePropertyChange("child item checked change", true, false);
                        }
                    }
                    if (mtpg != null) {
                        mtpg.firePropertyChange("user change", false, true);
                    }
                }
            });
        }
        return this.checkBox;
    }

    private JPanel getNotesPanel() {
        if (this.notesPanel == null) {
            this.notesPanel = new JPanel();
            this.notesPanel.setLayout(new BorderLayout());
            this.notesPanel.setOpaque(false);
            this.notesPanel.setVisible(false);
            this.notesPanel.add((Component)this.getNoteScrollPane(), "Center");
            this.notesPanel.add((Component)this.getDatePanel(), "North");
        }
        return this.notesPanel;
    }

    private JPanel getActionsPanel() {
        if (this.actionsPanel == null) {
            this.actionsPanel = new JPanel();
            this.actionsPanel.setLayout(new BorderLayout());
            this.actionsPanel.setBorder(new TitledBorder(I18n.text("Actions")));
            this.actionsPanel.setOpaque(false);
            this.actionsPanel.setVisible(false);
            this.actionsPanel.add((Component)this.getActionsListPanelHolder(), "Center");
        }
        return this.actionsPanel;
    }

    private AutoItemsList getActionsListPanelHolder() {
        if (this.actionsListPanelHolder == null) {
            this.actionsListPanelHolder = new AutoItemsList(this);
        }
        return this.actionsListPanelHolder;
    }

    private JScrollPane getNoteScrollPane() {
        if (this.noteScrollPane == null) {
            this.noteScrollPane = new JScrollPane();
            this.noteScrollPane.setOpaque(false);
            this.noteScrollPane.setVerticalScrollBarPolicy(20);
            this.noteScrollPane.setHorizontalScrollBarPolicy(31);
            this.noteScrollPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.noteScrollPane.setPreferredSize(new Dimension(300, 50));
            this.noteScrollPane.setViewportView(this.getNoteTextArea());
        }
        return this.noteScrollPane;
    }

    private JTextArea getNoteTextArea() {
        if (this.noteTextArea == null) {
            this.noteTextArea = new JTextArea();
            this.noteTextArea.setLineWrap(true);
            this.noteTextArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    CheckItemPanel.this.fireChangeEvent((Component)e.getSource());
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    CheckItemPanel.this.fixStateLabel();
                }
            });
        }
        return this.noteTextArea;
    }

    private JToggleButton getNoteToggleButton() {
        if (this.noteToggleButton == null) {
            this.noteToggleButton = new JToggleButton();
            this.noteToggleButton.setMargin(new Insets(0, 0, 0, 0));
            this.noteToggleButton.setIcon(EDIT_IMAGE_ICON);
            this.noteToggleButton.setToolTipText(I18n.text("See Note & Actions"));
            this.noteToggleButton.setFont(new Font("Dialog", 1, 10));
            this.noteToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (CheckItemPanel.this.getNoteToggleButton().isSelected()) {
                        CheckItemPanel.this.getNotesPanel().setVisible(true);
                        CheckItemPanel.this.getActionsPanel().setVisible(true);
                    } else {
                        CheckItemPanel.this.getNotesPanel().setVisible(false);
                        CheckItemPanel.this.getActionsPanel().setVisible(false);
                    }
                }
            });
        }
        return this.noteToggleButton;
    }

    private JLabel getDateChangedLabel() {
        if (this.dateChangedLabel == null) {
            this.dateChangedLabel = new JLabel();
            this.dateChangedLabel.setText(I18n.text("DateTime"));
            this.dateChangedLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                }
            });
        }
        return this.dateChangedLabel;
    }

    private JPanel getDatePanel() {
        if (this.datePanel == null) {
            this.dateLabLabel = new JLabel();
            this.dateLabLabel.setText(I18n.text("Date checked:"));
            this.datePanel = new JPanel();
            this.datePanel.setOpaque(false);
            this.datePanel.setVisible(false);
            this.datePanel.add((Component)this.dateLabLabel, null);
            this.datePanel.add((Component)this.getDateChangedLabel(), null);
        }
        return this.datePanel;
    }

    public Container getParentGroup() {
        return this.getParent().getParent().getParent().getParent();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CheckItemPanel) {
            CheckItemPanel comp = (CheckItemPanel)obj;
            return this.nameCheckItem.getText().equals(comp.nameCheckItem.getText());
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("user change")) {
            NeptusLog.pub().info((Object)(this + ": user change"));
            boolean newValue = (Boolean)e.getNewValue();
            ((MyJTaskPaneGroup)((Object)this.getParentGroup())).firePropertyChange("user change", !newValue, newValue);
        }
    }

    void fireChangeEvent(Component source) {
        Container parent = this.getParent();
        if (parent != null) {
            parent = parent.getParent().getParent().getParent();
            ((MyJTaskPaneGroup)((Object)parent)).firePropertyChange("user change", false, true);
        }
        this.fixStateLabel();
    }

    public CheckItem getCheckItem() {
        Component[] list;
        CheckItem ci = new CheckItem();
        ci.setChecked(this.checkBox.isSelected());
        ci.setName(this.nameCheckItem.getText());
        if (ci.isChecked()) {
            ci.setDateChecked(this.dateChangedLabel.getText());
        }
        ci.setNote(this.noteTextArea.getText());
        for (Component c : list = this.getActionsListPanelHolder().getComponents()) {
            try {
                ci.addAutoSubItem(((CheckSubItem)((Object)c)).getCheckAutoSubItem());
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return ci;
    }
}

